<?php
// This file was auto-generated from sdk-root/src/data/s3/2006-03-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p/>', 'operations' => [ 'AbortMultipartUpload' => '<p>This operation aborts a multipart upload. After a multipart upload is aborted, no additional parts can be uploaded using that upload ID. The storage consumed by any previously uploaded parts will be freed. However, if any part uploads are currently in progress, those part uploads might or might not succeed. As a result, it might be necessary to abort a given multipart upload multiple times in order to completely free all storage consumed by all parts. </p> <p>To verify that all parts have been removed, so you don\'t get charged for the part storage, you should call the <a>ListParts</a> operation and ensure that the parts list is empty.</p> <p>For information about permissions required to use the multipart upload API, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html">Multipart Upload API and Permissions</a>.</p> <p>The following operations are related to <code>AbortMultipartUpload</code>:</p> <ul> <li> <p> <a>CreateMultipartUpload</a> </p> </li> <li> <p> <a>UploadPart</a> </p> </li> <li> <p> <a>CompleteMultipartUpload</a> </p> </li> <li> <p> <a>ListParts</a> </p> </li> <li> <p> <a>ListMultipartUploads</a> </p> </li> </ul>', 'CompleteMultipartUpload' => '<p>Completes a multipart upload by assembling previously uploaded parts.</p> <p>You first initiate the multipart upload and then upload all parts using the <a>UploadPart</a> operation. After successfully uploading all relevant parts of an upload, you call this operation to complete the upload. Upon receiving this request, Amazon S3 concatenates all the parts in ascending order by part number to create a new object. In the Complete Multipart Upload request, you must provide the parts list. You must ensure that the parts list is complete. This operation concatenates the parts that you provide in the list. For each part in the list, you must provide the part number and the <code>ETag</code> value, returned after that part was uploaded.</p> <p>Processing of a Complete Multipart Upload request could take several minutes to complete. After Amazon S3 begins processing the request, it sends an HTTP response header that specifies a 200 OK response. While processing is in progress, Amazon S3 periodically sends white space characters to keep the connection from timing out. Because a request could fail after the initial 200 OK response has been sent, it is important that you check the response body to determine whether the request succeeded.</p> <p>Note that if <code>CompleteMultipartUpload</code> fails, applications should be prepared to retry the failed requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ErrorBestPractices.html">Amazon S3 Error Best Practices</a>.</p> <p>For more information about multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html">Uploading Objects Using Multipart Upload</a>.</p> <p>For information about permissions required to use the multipart upload API, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html">Multipart Upload API and Permissions</a>.</p> <p> <code>CompleteMultipartUpload</code> has the following special errors:</p> <ul> <li> <p>Error code: <code>EntityTooSmall</code> </p> <ul> <li> <p>Description: Your proposed upload is smaller than the minimum allowed object size. Each part must be at least 5 MB in size, except the last part.</p> </li> <li> <p>400 Bad Request</p> </li> </ul> </li> <li> <p>Error code: <code>InvalidPart</code> </p> <ul> <li> <p>Description: One or more of the specified parts could not be found. The part might not have been uploaded, or the specified entity tag might not have matched the part\'s entity tag.</p> </li> <li> <p>400 Bad Request</p> </li> </ul> </li> <li> <p>Error code: <code>InvalidPartOrder</code> </p> <ul> <li> <p>Description: The list of parts was not in ascending order. The parts list must be specified in order by part number.</p> </li> <li> <p>400 Bad Request</p> </li> </ul> </li> <li> <p>Error code: <code>NoSuchUpload</code> </p> <ul> <li> <p>Description: The specified multipart upload does not exist. The upload ID might be invalid, or the multipart upload might have been aborted or completed.</p> </li> <li> <p>404 Not Found</p> </li> </ul> </li> </ul> <p>The following operations are related to <code>CompleteMultipartUpload</code>:</p> <ul> <li> <p> <a>CreateMultipartUpload</a> </p> </li> <li> <p> <a>UploadPart</a> </p> </li> <li> <p> <a>AbortMultipartUpload</a> </p> </li> <li> <p> <a>ListParts</a> </p> </li> <li> <p> <a>ListMultipartUploads</a> </p> </li> </ul>', 'CopyObject' => '<p>Creates a copy of an object that is already stored in Amazon S3.</p> <note> <p>You can store individual objects of up to 5 TB in Amazon S3. You create a copy of your object up to 5 GB in size in a single atomic operation using this API. However, to copy an object greater than 5 GB, you must use the multipart upload Upload Part - Copy API. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/CopyingObjctsUsingRESTMPUapi.html">Copy Object Using the REST Multipart Upload API</a>.</p> </note> <p>All copy requests must be authenticated. Additionally, you must have <i>read</i> access to the source object and <i>write</i> access to the destination bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">REST Authentication</a>. Both the Region that you want to copy the object from and the Region that you want to copy the object to must be enabled for your account.</p> <p>A copy request might return an error when Amazon S3 receives the copy request or while Amazon S3 is copying the files. If the error occurs before the copy operation starts, you receive a standard Amazon S3 error. If the error occurs during the copy operation, the error response is embedded in the <code>200 OK</code> response. This means that a <code>200 OK</code> response can contain either a success or an error. Design your application to parse the contents of the response and handle it appropriately.</p> <p>If the copy is successful, you receive a response with information about the copied object.</p> <note> <p>If the request is an HTTP 1.1 request, the response is chunk encoded. If it were not, it would not contain the content-length, and you would need to read the entire body.</p> </note> <p>The copy request charge is based on the storage class and Region that you specify for the destination object. For pricing information, see <a href="https://aws.amazon.com/s3/pricing/">Amazon S3 pricing</a>.</p> <important> <p>Amazon S3 transfer acceleration does not support cross-Region copies. If you request a cross-Region copy using a transfer acceleration endpoint, you get a 400 <code>Bad Request</code> error. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Transfer Acceleration</a>.</p> </important> <p> <b>Metadata</b> </p> <p>When copying an object, you can preserve all metadata (default) or specify new metadata. However, the ACL is not preserved and is set to private for the user making the request. To override the default ACL setting, specify a new ACL when generating a copy request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html">Using ACLs</a>. </p> <p>To specify whether you want the object metadata copied from the source object or replaced with metadata provided in the request, you can optionally add the <code>x-amz-metadata-directive</code> header. When you grant permissions, you can use the <code>s3:x-amz-metadata-directive</code> condition key to enforce certain metadata behavior when objects are uploaded. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/amazon-s3-policy-keys.html">Specifying Conditions in a Policy</a> in the <i>Amazon S3 Developer Guide</i>. For a complete list of Amazon S3-specific condition keys, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html">Actions, Resources, and Condition Keys for Amazon S3</a>.</p> <p> <b> <code>x-amz-copy-source-if</code> Headers</b> </p> <p>To only copy an object under certain conditions, such as whether the <code>Etag</code> matches or whether the object was modified before or after a specified date, use the following request parameters:</p> <ul> <li> <p> <code>x-amz-copy-source-if-match</code> </p> </li> <li> <p> <code>x-amz-copy-source-if-none-match</code> </p> </li> <li> <p> <code>x-amz-copy-source-if-unmodified-since</code> </p> </li> <li> <p> <code>x-amz-copy-source-if-modified-since</code> </p> </li> </ul> <p> If both the <code>x-amz-copy-source-if-match</code> and <code>x-amz-copy-source-if-unmodified-since</code> headers are present in the request and evaluate as follows, Amazon S3 returns <code>200 OK</code> and copies the data:</p> <ul> <li> <p> <code>x-amz-copy-source-if-match</code> condition evaluates to true</p> </li> <li> <p> <code>x-amz-copy-source-if-unmodified-since</code> condition evaluates to false</p> </li> </ul> <p>If both the <code>x-amz-copy-source-if-none-match</code> and <code>x-amz-copy-source-if-modified-since</code> headers are present in the request and evaluate as follows, Amazon S3 returns the <code>412 Precondition Failed</code> response code:</p> <ul> <li> <p> <code>x-amz-copy-source-if-none-match</code> condition evaluates to false</p> </li> <li> <p> <code>x-amz-copy-source-if-modified-since</code> condition evaluates to true</p> </li> </ul> <note> <p>All headers with the <code>x-amz-</code> prefix, including <code>x-amz-copy-source</code>, must be signed.</p> </note> <p> <b>Encryption</b> </p> <p>The source object that you are copying can be encrypted or unencrypted. The source object can be encrypted with server-side encryption using AWS managed encryption keys (SSE-S3 or SSE-KMS) or by using a customer-provided encryption key. With server-side encryption, Amazon S3 encrypts your data as it writes it to disks in its data centers and decrypts the data when you access it. </p> <p>You can optionally use the appropriate encryption-related headers to request server-side encryption for the target object. You have the option to provide your own encryption key or use SSE-S3 or SSE-KMS, regardless of the form of server-side encryption that was used to encrypt the source object. You can even request encryption if the source object was not encrypted. For more information about server-side encryption, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html">Using Server-Side Encryption</a>.</p> <p> <b>Access Control List (ACL)-Specific Request Headers</b> </p> <p>When copying an object, you can optionally use headers to grant ACL-based permissions. By default, all objects are private. Only the owner has full access control. When adding a new object, you can grant permissions to individual AWS accounts or to predefined groups defined by Amazon S3. These permissions are then added to the ACL on the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-using-rest-api.html">Managing ACLs Using the REST API</a>. </p> <p> <b>Storage Class Options</b> </p> <p>You can use the <code>CopyObject</code> operation to change the storage class of an object that is already stored in Amazon S3 using the <code>StorageClass</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 Service Developer Guide</i>.</p> <p> <b>Versioning</b> </p> <p>By default, <code>x-amz-copy-source</code> identifies the current version of an object to copy. If the current version is a delete marker, Amazon S3 behaves as if the object was deleted. To copy a different version, use the <code>versionId</code> subresource.</p> <p>If you enable versioning on the target bucket, Amazon S3 generates a unique version ID for the object being copied. This version ID is different from the version ID of the source object. Amazon S3 returns the version ID of the copied object in the <code>x-amz-version-id</code> response header in the response.</p> <p>If you do not enable versioning or suspend it on the target bucket, the version ID that Amazon S3 generates is always null.</p> <p>If the source object\'s storage class is GLACIER, you must restore a copy of this object before you can use it as a source object for the copy operation. For more information, see .</p> <p>The following operations are related to <code>CopyObject</code>:</p> <ul> <li> <p> <a>PutObject</a> </p> </li> <li> <p> <a>GetObject</a> </p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/CopyingObjectsExamples.html">Copying Objects</a>.</p>', 'CreateBucket' => '<p>Creates a new bucket. To create a bucket, you must register with Amazon S3 and have a valid AWS Access Key ID to authenticate requests. Anonymous requests are never allowed to create buckets. By creating the bucket, you become the bucket owner.</p> <p>Not every string is an acceptable bucket name. For information on bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingBucket.html">Working with Amazon S3 Buckets</a>.</p> <p>By default, the bucket is created in the US East (N. Virginia) Region. You can optionally specify a Region in the request body. You might choose a Region to optimize latency, minimize costs, or address regulatory requirements. For example, if you reside in Europe, you will probably find it advantageous to create buckets in the Europe (Ireland) Region. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingBucket.html#access-bucket-intro">How to Select a Region for Your Buckets</a>.</p> <note> <p>If you send your create bucket request to the <code>s3.amazonaws.com</code> endpoint, the request goes to the us-east-1 Region. Accordingly, the signature calculations in Signature Version 4 must use us-east-1 as the Region, even if the location constraint in the request specifies another Region where the bucket is to be created. If you create a bucket in a Region other than US East (N. Virginia), your application must be able to handle 307 redirect. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html">Virtual Hosting of Buckets</a>.</p> </note> <p>When creating a bucket using this operation, you can optionally specify the accounts or groups that should be granted specific permissions on the bucket. There are two ways to grant the appropriate permissions using the request headers.</p> <ul> <li> <p>Specify a canned ACL using the <code>x-amz-acl</code> request header. Amazon S3 supports a set of predefined ACLs, known as <i>canned ACLs</i>. Each canned ACL has a predefined set of grantees and permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.</p> </li> <li> <p>Specify access permissions explicitly using the <code>x-amz-grant-read</code>, <code>x-amz-grant-write</code>, <code>x-amz-grant-read-acp</code>, <code>x-amz-grant-write-acp</code>, and <code>x-amz-grant-full-control</code> headers. These headers map to the set of permissions Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a>.</p> <p>You specify each grantee as a type=value pair, where the type is one of the following:</p> <ul> <li> <p> <code>id</code> – if the value specified is the canonical user ID of an AWS account</p> </li> <li> <p> <code>uri</code> – if you are granting permissions to a predefined group</p> </li> <li> <p> <code>emailAddress</code> – if the value specified is the email address of an AWS account</p> <note> <p>Using email addresses to specify a grantee is only supported in the following AWS Regions: </p> <ul> <li> <p>US East (N. Virginia)</p> </li> <li> <p>US West (N. California)</p> </li> <li> <p> US West (Oregon)</p> </li> <li> <p> Asia Pacific (Singapore)</p> </li> <li> <p>Asia Pacific (Sydney)</p> </li> <li> <p>Asia Pacific (Tokyo)</p> </li> <li> <p>Europe (Ireland)</p> </li> <li> <p>South America (São Paulo)</p> </li> </ul> <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the AWS General Reference.</p> </note> </li> </ul> <p>For example, the following <code>x-amz-grant-read</code> header grants the AWS accounts identified by account IDs permissions to read object data and its metadata:</p> <p> <code>x-amz-grant-read: id="11112222333", id="444455556666" </code> </p> </li> </ul> <note> <p>You can use either a canned ACL or specify access permissions explicitly. You cannot do both.</p> </note> <p>The following operations are related to <code>CreateBucket</code>:</p> <ul> <li> <p> <a>PutObject</a> </p> </li> <li> <p> <a>DeleteBucket</a> </p> </li> </ul>', 'CreateMultipartUpload' => '<p>This operation initiates a multipart upload and returns an upload ID. This upload ID is used to associate all of the parts in the specific multipart upload. You specify this upload ID in each of your subsequent upload part requests (see <a>UploadPart</a>). You also include this upload ID in the final request to either complete or abort the multipart upload request.</p> <p>For more information about multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html">Multipart Upload Overview</a>.</p> <p>If you have configured a lifecycle rule to abort incomplete multipart uploads, the upload must complete within the number of days specified in the bucket lifecycle configuration. Otherwise, the incomplete multipart upload becomes eligible for an abort operation and Amazon S3 aborts the multipart upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config">Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a>.</p> <p>For information about the permissions required to use the multipart upload API, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html">Multipart Upload API and Permissions</a>.</p> <p>For request signing, multipart upload is just a series of regular requests. You initiate a multipart upload, send one or more requests to upload parts, and then complete the multipart upload process. You sign each request individually. There is nothing special about signing multipart upload requests. For more information about signing, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html">Authenticating Requests (AWS Signature Version 4)</a>.</p> <note> <p> After you initiate a multipart upload and upload one or more parts, to stop being charged for storing the uploaded parts, you must either complete or abort the multipart upload. Amazon S3 frees up the space used to store the parts and stop charging you for storing them only after you either complete or abort a multipart upload. </p> </note> <p>You can optionally request server-side encryption. For server-side encryption, Amazon S3 encrypts your data as it writes it to disks in its data centers and decrypts it when you access it. You can provide your own encryption key, or use AWS Key Management Service (AWS KMS) customer master keys (CMKs) or Amazon S3-managed encryption keys. If you choose to provide your own encryption key, the request headers you provide in <a>UploadPart</a>) and <a>UploadPartCopy</a>) requests must match the headers you used in the request to initiate the upload by using <code>CreateMultipartUpload</code>. </p> <p>To perform a multipart upload with encryption using an AWS KMS CMK, the requester must have permission to the <code>kms:Encrypt</code>, <code>kms:Decrypt</code>, <code>kms:ReEncrypt*</code>, <code>kms:GenerateDataKey*</code>, and <code>kms:DescribeKey</code> actions on the key. These permissions are required because Amazon S3 must decrypt and read data from the encrypted file parts before it completes the multipart upload.</p> <p>If your AWS Identity and Access Management (IAM) user or role is in the same AWS account as the AWS KMS CMK, then you must have these permissions on the key policy. If your IAM user or role belongs to a different account than the key, then you must have the permissions on both the key policy and your IAM user or role.</p> <p> For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html">Protecting Data Using Server-Side Encryption</a>.</p> <dl> <dt>Access Permissions</dt> <dd> <p>When copying an object, you can optionally specify the accounts or groups that should be granted specific permissions on the new object. There are two ways to grant the permissions using the request headers:</p> <ul> <li> <p>Specify a canned ACL with the <code>x-amz-acl</code> request header. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.</p> </li> <li> <p>Specify access permissions explicitly with the <code>x-amz-grant-read</code>, <code>x-amz-grant-read-acp</code>, <code>x-amz-grant-write-acp</code>, and <code>x-amz-grant-full-control</code> headers. These parameters map to the set of permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a>.</p> </li> </ul> <p>You can use either a canned ACL or specify access permissions explicitly. You cannot do both.</p> </dd> <dt>Server-Side- Encryption-Specific Request Headers</dt> <dd> <p>You can optionally tell Amazon S3 to encrypt data at rest using server-side encryption. Server-side encryption is for data encryption at rest. Amazon S3 encrypts your data as it writes it to disks in its data centers and decrypts it when you access it. The option you use depends on whether you want to use AWS managed encryption keys or provide your own encryption key. </p> <ul> <li> <p>Use encryption keys managed by Amazon S3 or customer master keys (CMKs) stored in AWS Key Management Service (AWS KMS) – If you want AWS to manage the keys used to encrypt data, specify the following headers in the request.</p> <ul> <li> <p>x-amz-server-side​-encryption</p> </li> <li> <p>x-amz-server-side-encryption-aws-kms-key-id</p> </li> <li> <p>x-amz-server-side-encryption-context</p> </li> </ul> <note> <p>If you specify <code>x-amz-server-side-encryption:aws:kms</code>, but don\'t provide <code>x-amz-server-side-encryption-aws-kms-key-id</code>, Amazon S3 uses the AWS managed CMK in AWS KMS to protect the data.</p> </note> <important> <p>All GET and PUT requests for an object protected by AWS KMS fail if you don\'t make them with SSL or by using SigV4.</p> </important> <p>For more information about server-side encryption with CMKs stored in AWS KMS (SSE-KMS), see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">Protecting Data Using Server-Side Encryption with CMKs stored in AWS KMS</a>.</p> </li> <li> <p>Use customer-provided encryption keys – If you want to manage your own encryption keys, provide all the following headers in the request.</p> <ul> <li> <p>x-amz-server-side​-encryption​-customer-algorithm</p> </li> <li> <p>x-amz-server-side​-encryption​-customer-key</p> </li> <li> <p>x-amz-server-side​-encryption​-customer-key-MD5</p> </li> </ul> <p>For more information about server-side encryption with CMKs stored in AWS KMS (SSE-KMS), see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">Protecting Data Using Server-Side Encryption with CMKs stored in AWS KMS</a>.</p> </li> </ul> </dd> <dt>Access-Control-List (ACL)-Specific Request Headers</dt> <dd> <p>You also can use the following access control–related headers with this operation. By default, all objects are private. Only the owner has full access control. When adding a new object, you can grant permissions to individual AWS accounts or to predefined groups defined by Amazon S3. These permissions are then added to the access control list (ACL) on the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html">Using ACLs</a>. With this operation, you can grant access permissions using one of the following two methods:</p> <ul> <li> <p>Specify a canned ACL (<code>x-amz-acl</code>) — Amazon S3 supports a set of predefined ACLs, known as <i>canned ACLs</i>. Each canned ACL has a predefined set of grantees and permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.</p> </li> <li> <p>Specify access permissions explicitly — To explicitly grant access permissions to specific AWS accounts or groups, use the following headers. Each header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a>. In the header, you specify a list of grantees who get the specific permission. To grant permissions explicitly, use:</p> <ul> <li> <p>x-amz-grant-read</p> </li> <li> <p>x-amz-grant-write</p> </li> <li> <p>x-amz-grant-read-acp</p> </li> <li> <p>x-amz-grant-write-acp</p> </li> <li> <p>x-amz-grant-full-control</p> </li> </ul> <p>You specify each grantee as a type=value pair, where the type is one of the following:</p> <ul> <li> <p> <code>id</code> – if the value specified is the canonical user ID of an AWS account</p> </li> <li> <p> <code>uri</code> – if you are granting permissions to a predefined group</p> </li> <li> <p> <code>emailAddress</code> – if the value specified is the email address of an AWS account</p> <note> <p>Using email addresses to specify a grantee is only supported in the following AWS Regions: </p> <ul> <li> <p>US East (N. Virginia)</p> </li> <li> <p>US West (N. California)</p> </li> <li> <p> US West (Oregon)</p> </li> <li> <p> Asia Pacific (Singapore)</p> </li> <li> <p>Asia Pacific (Sydney)</p> </li> <li> <p>Asia Pacific (Tokyo)</p> </li> <li> <p>Europe (Ireland)</p> </li> <li> <p>South America (São Paulo)</p> </li> </ul> <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the AWS General Reference.</p> </note> </li> </ul> <p>For example, the following <code>x-amz-grant-read</code> header grants the AWS accounts identified by account IDs permissions to read object data and its metadata:</p> <p> <code>x-amz-grant-read: id="11112222333", id="444455556666" </code> </p> </li> </ul> </dd> </dl> <p>The following operations are related to <code>CreateMultipartUpload</code>:</p> <ul> <li> <p> <a>UploadPart</a> </p> </li> <li> <p> <a>CompleteMultipartUpload</a> </p> </li> <li> <p> <a>AbortMultipartUpload</a> </p> </li> <li> <p> <a>ListParts</a> </p> </li> <li> <p> <a>ListMultipartUploads</a> </p> </li> </ul>', 'DeleteBucket' => '<p>Deletes the bucket. All objects (including all object versions and delete markers) in the bucket must be deleted before the bucket itself can be deleted.</p> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> </p> </li> <li> <p> </p> </li> </ul>', 'DeleteBucketAnalyticsConfiguration' => '<p>Deletes an analytics configuration for the bucket (specified by the analytics configuration ID).</p> <p>To use this operation, you must have permissions to perform the <code>s3:PutAnalyticsConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <p>For information about the Amazon S3 analytics feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html">Amazon S3 Analytics – Storage Class Analysis</a>. </p> <p>The following operations are related to <code>DeleteBucketAnalyticsConfiguration</code>:</p> <ul> <li> <p> </p> </li> <li> <p> </p> </li> <li> <p> </p> </li> </ul>', 'DeleteBucketCors' => '<p>Deletes the <code>cors</code> configuration information set for the bucket.</p> <p>To use this operation, you must have permission to perform the <code>s3:PutBucketCORS</code> action. The bucket owner has this permission by default and can grant this permission to others. </p> <p>For information about <code>cors</code>, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> <p class="title"> <b>Related Resources:</b> </p> <ul> <li> <p> </p> </li> <li> <p> <a>RESTOPTIONSobject</a> </p> </li> </ul>', 'DeleteBucketEncryption' => '<p>This implementation of the DELETE operation removes default encryption from the bucket. For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Bucket Encryption</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> <p>To use this operation, you must have permissions to perform the <code>s3:PutEncryptionConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to your Amazon S3 Resources</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> <a>PutBucketEncryption</a> </p> </li> <li> <p> <a>GetBucketEncryption</a> </p> </li> </ul>', 'DeleteBucketInventoryConfiguration' => '<p>Deletes an inventory configuration (identified by the inventory ID) from the bucket.</p> <p>To use this operation, you must have permissions to perform the <code>s3:PutInventoryConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <p>For information about the Amazon S3 inventory feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html">Amazon S3 Inventory</a>.</p> <p>Operations related to <code>DeleteBucketInventoryConfiguration</code> include: </p> <ul> <li> <p> <a>GetBucketInventoryConfiguration</a> </p> </li> <li> <p> <a>PutBucketInventoryConfiguration</a> </p> </li> <li> <p> <a>ListBucketInventoryConfigurations</a> </p> </li> </ul>', 'DeleteBucketLifecycle' => '<p>Deletes the lifecycle configuration from the specified bucket. Amazon S3 removes all the lifecycle configuration rules in the lifecycle subresource associated with the bucket. Your objects never expire, and Amazon S3 no longer automatically deletes any objects on the basis of rules contained in the deleted lifecycle configuration.</p> <p>To use this operation, you must have permission to perform the <code>s3:PutLifecycleConfiguration</code> action. By default, the bucket owner has this permission and the bucket owner can grant this permission to others.</p> <p>There is usually some time lag before lifecycle configuration deletion is fully propagated to all the Amazon S3 systems.</p> <p>For more information about the object expiration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#intro-lifecycle-rules-actions">Elements to Describe Lifecycle Actions</a>.</p> <p>Related actions include:</p> <ul> <li> <p> <a>PutBucketLifecycleConfiguration</a> </p> </li> <li> <p> <a>GetBucketLifecycleConfiguration</a> </p> </li> </ul>', 'DeleteBucketMetricsConfiguration' => '<p>Deletes a metrics configuration for the Amazon CloudWatch request metrics (specified by the metrics configuration ID) from the bucket. Note that this doesn\'t include the daily storage metrics.</p> <p> To use this operation, you must have permissions to perform the <code>s3:PutMetricsConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <p>For information about CloudWatch request metrics for Amazon S3, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with Amazon CloudWatch</a>. </p> <p>The following operations are related to <code>DeleteBucketMetricsConfiguration</code>:</p> <ul> <li> <p> <a>GetBucketMetricsConfiguration</a> </p> </li> <li> <p> <a>PutBucketMetricsConfiguration</a> </p> </li> <li> <p> <a>ListBucketMetricsConfigurations</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with Amazon CloudWatch</a> </p> </li> </ul>', 'DeleteBucketPolicy' => '<p>This implementation of the DELETE operation uses the policy subresource to delete the policy of a specified bucket. If you are using an identity other than the root user of the AWS account that owns the bucket, the calling identity must have the <code>DeleteBucketPolicy</code> permissions on the specified bucket and belong to the bucket owner\'s account to use this operation. </p> <p>If you don\'t have <code>DeleteBucketPolicy</code> permissions, Amazon S3 returns a <code>403 Access Denied</code> error. If you have the correct permissions, but you\'re not using an identity that belongs to the bucket owner\'s account, Amazon S3 returns a <code>405 Method Not Allowed</code> error. </p> <important> <p>As a security precaution, the root user of the AWS account that owns a bucket can always use this operation, even if the policy explicitly denies the root user the ability to perform this action.</p> </important> <p>For more information about bucket policies, see <a href=" https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and UserPolicies</a>. </p> <p>The following operations are related to <code>DeleteBucketPolicy</code> </p> <ul> <li> <p> <a>CreateBucket</a> </p> </li> <li> <p> <a>DeleteObject</a> </p> </li> </ul>', 'DeleteBucketReplication' => '<p> Deletes the replication configuration from the bucket.</p> <p>To use this operation, you must have permissions to perform the <code>s3:PutReplicationConfiguration</code> action. The bucket owner has these permissions by default and can grant it to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>. </p> <note> <p>It can take a while for the deletion of a replication configuration to fully propagate.</p> </note> <p> For information about replication configuration, see <a href=" https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html">Replication</a> in the <i>Amazon S3 Developer Guide</i>. </p> <p>The following operations are related to <code>DeleteBucketReplication</code>:</p> <ul> <li> <p> <a>PutBucketReplication</a> </p> </li> <li> <p> <a>GetBucketReplication</a> </p> </li> </ul>', 'DeleteBucketTagging' => '<p>Deletes the tags from the bucket.</p> <p>To use this operation, you must have permission to perform the <code>s3:PutBucketTagging</code> action. By default, the bucket owner has this permission and can grant this permission to others. </p> <p>The following operations are related to <code>DeleteBucketTagging</code>:</p> <ul> <li> <p> <a>GetBucketTagging</a> </p> </li> <li> <p> <a>PutBucketTagging</a> </p> </li> </ul>', 'DeleteBucketWebsite' => '<p>This operation removes the website configuration for a bucket. Amazon S3 returns a <code>200 OK</code> response upon successfully deleting a website configuration on the specified bucket. You will get a <code>200 OK</code> response if the website configuration you are trying to delete does not exist on the bucket. Amazon S3 returns a <code>404</code> response if the bucket specified in the request does not exist.</p> <p>This DELETE operation requires the <code>S3:DeleteBucketWebsite</code> permission. By default, only the bucket owner can delete the website configuration attached to a bucket. However, bucket owners can grant other users permission to delete the website configuration by writing a bucket policy granting them the <code>S3:DeleteBucketWebsite</code> permission. </p> <p>For more information about hosting websites, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a>. </p> <p>The following operations are related to <code>DeleteBucketWebsite</code>:</p> <ul> <li> <p> <a>GetBucketWebsite</a> </p> </li> <li> <p> <a>PutBucketWebsite</a> </p> </li> </ul>', 'DeleteObject' => '<p>Removes the null version (if there is one) of an object and inserts a delete marker, which becomes the latest version of the object. If there isn\'t a null version, Amazon S3 does not remove any objects.</p> <p>To remove a specific version, you must be the bucket owner and you must use the version Id subresource. Using this subresource permanently deletes the version. If the object deleted is a delete marker, Amazon S3 sets the response header, <code>x-amz-delete-marker</code>, to true. </p> <p>If the object you want to delete is in a bucket where the bucket versioning configuration is MFA Delete enabled, you must include the <code>x-amz-mfa</code> request header in the DELETE <code>versionId</code> request. Requests that include <code>x-amz-mfa</code> must use HTTPS. </p> <p> For more information about MFA Delete, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMFADelete.html">Using MFA Delete</a>. To see sample requests that use versioning, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectDELETE.html#ExampleVersionObjectDelete">Sample Request</a>. </p> <p>You can delete objects by explicitly calling the DELETE Object API or configure its lifecycle (<a>PutBucketLifecycle</a>) to enable Amazon S3 to remove them for you. If you want to block users or accounts from removing or deleting objects from your bucket, you must deny them the <code>s3:DeleteObject</code>, <code>s3:DeleteObjectVersion</code>, and <code>s3:PutLifeCycleConfiguration</code> actions. </p> <p>The following operation is related to <code>DeleteObject</code>:</p> <ul> <li> <p> <a>PutObject</a> </p> </li> </ul>', 'DeleteObjectTagging' => '<p>Removes the entire tag set from the specified object. For more information about managing object tags, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html"> Object Tagging</a>.</p> <p>To use this operation, you must have permission to perform the <code>s3:DeleteObjectTagging</code> action.</p> <p>To delete tags of a specific object version, add the <code>versionId</code> query parameter in the request. You will need permission for the <code>s3:DeleteObjectVersionTagging</code> action.</p> <p>The following operations are related to <code>DeleteBucketMetricsConfiguration</code>:</p> <ul> <li> <p> <a>PutObjectTagging</a> </p> </li> <li> <p> <a>GetObjectTagging</a> </p> </li> </ul>', 'DeleteObjects' => '<p>This operation enables you to delete multiple objects from a bucket using a single HTTP request. If you know the object keys that you want to delete, then this operation provides a suitable alternative to sending individual delete requests, reducing per-request overhead.</p> <p>The request contains a list of up to 1000 keys that you want to delete. In the XML, you provide the object key names, and optionally, version IDs if you want to delete a specific version of the object from a versioning-enabled bucket. For each key, Amazon S3 performs a delete operation and returns the result of that delete, success, or failure, in the response. Note that if the object specified in the request is not found, Amazon S3 returns the result as deleted.</p> <p> The operation supports two modes for the response: verbose and quiet. By default, the operation uses verbose mode in which the response includes the result of deletion of each key in your request. In quiet mode the response includes only keys where the delete operation encountered an error. For a successful deletion, the operation does not return any information about the delete in the response body.</p> <p>When performing this operation on an MFA Delete enabled bucket, that attempts to delete any versioned objects, you must include an MFA token. If you do not provide one, the entire request will fail, even if there are non-versioned objects you are trying to delete. If you provide an invalid token, whether there are versioned keys in the request or not, the entire Multi-Object Delete request will fail. For information about MFA Delete, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html#MultiFactorAuthenticationDelete"> MFA Delete</a>.</p> <p>Finally, the Content-MD5 header is required for all Multi-Object Delete requests. Amazon S3 uses the header value to ensure that your request body has not been altered in transit.</p> <p>The following operations are related to <code>DeleteObjects</code>:</p> <ul> <li> <p> <a>CreateMultipartUpload</a> </p> </li> <li> <p> <a>UploadPart</a> </p> </li> <li> <p> <a>CompleteMultipartUpload</a> </p> </li> <li> <p> <a>ListParts</a> </p> </li> <li> <p> <a>AbortMultipartUpload</a> </p> </li> </ul>', 'DeletePublicAccessBlock' => '<p>Removes the <code>PublicAccessBlock</code> configuration for an Amazon S3 bucket. To use this operation, you must have the <code>s3:PutBucketPublicAccessBlock</code> permission. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <p>The following operations are related to <code>DeletePublicAccessBlock</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html">Using Amazon S3 Block Public Access</a> </p> </li> <li> <p> <a>GetPublicAccessBlock</a> </p> </li> <li> <p> <a>PutPublicAccessBlock</a> </p> </li> <li> <p> <a>GetBucketPolicyStatus</a> </p> </li> </ul>', 'GetBucketAccelerateConfiguration' => '<p>This implementation of the GET operation uses the <code>accelerate</code> subresource to return the Transfer Acceleration state of a bucket, which is either <code>Enabled</code> or <code>Suspended</code>. Amazon S3 Transfer Acceleration is a bucket-level feature that enables you to perform faster data transfers to and from Amazon S3.</p> <p>To use this operation, you must have permission to perform the <code>s3:GetAccelerateConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to your Amazon S3 Resources</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> <p>You set the Transfer Acceleration state of an existing bucket to <code>Enabled</code> or <code>Suspended</code> by using the <a>PutBucketAccelerateConfiguration</a> operation. </p> <p>A GET <code>accelerate</code> request does not return a state value for a bucket that has no transfer acceleration state. A bucket has no Transfer Acceleration state if a state has never been set on the bucket. </p> <p>For more information about transfer acceleration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Transfer Acceleration</a> in the Amazon Simple Storage Service Developer Guide.</p> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> <a>PutBucketAccelerateConfiguration</a> </p> </li> </ul>', 'GetBucketAcl' => '<p>This implementation of the <code>GET</code> operation uses the <code>acl</code> subresource to return the access control list (ACL) of a bucket. To use <code>GET</code> to return the ACL of the bucket, you must have <code>READ_ACP</code> access to the bucket. If <code>READ_ACP</code> permission is granted to the anonymous user, you can return the ACL of the bucket without using an authorization header.</p> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> </p> </li> </ul>', 'GetBucketAnalyticsConfiguration' => '<p>This implementation of the GET operation returns an analytics configuration (identified by the analytics configuration ID) from the bucket.</p> <p>To use this operation, you must have permissions to perform the <code>s3:GetAnalyticsConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"> Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a> in the <i>Amazon Simple Storage Service Developer Guide</i>. </p> <p>For information about Amazon S3 analytics feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html">Amazon S3 Analytics – Storage Class Analysis</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> </p> </li> <li> <p> </p> </li> <li> <p> </p> </li> </ul>', 'GetBucketCors' => '<p>Returns the cors configuration information set for the bucket.</p> <p> To use this operation, you must have permission to perform the s3:GetBucketCORS action. By default, the bucket owner has this permission and can grant it to others.</p> <p> For more information about cors, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html"> Enabling Cross-Origin Resource Sharing</a>.</p> <p>The following operations are related to <code>GetBucketCors</code>:</p> <ul> <li> <p> <a>PutBucketCors</a> </p> </li> <li> <p> <a>DeleteBucketCors</a> </p> </li> </ul>', 'GetBucketEncryption' => '<p>Returns the default encryption configuration for an Amazon S3 bucket. For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Bucket Encryption</a>.</p> <p> To use this operation, you must have permission to perform the <code>s3:GetEncryptionConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <p>The following operations are related to <code>GetBucketEncryption</code>:</p> <ul> <li> <p> <a>PutBucketEncryption</a> </p> </li> <li> <p> <a>DeleteBucketEncryption</a> </p> </li> </ul>', 'GetBucketInventoryConfiguration' => '<p>Returns an inventory configuration (identified by the inventory configuration ID) from the bucket.</p> <p>To use this operation, you must have permissions to perform the <code>s3:GetInventoryConfiguration</code> action. The bucket owner has this permission by default and can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <p>For information about the Amazon S3 inventory feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html">Amazon S3 Inventory</a>.</p> <p>The following operations are related to <code>GetBucketInventoryConfiguration</code>:</p> <ul> <li> <p> <a>DeleteBucketInventoryConfiguration</a> </p> </li> <li> <p> <a>ListBucketInventoryConfigurations</a> </p> </li> <li> <p> <a>PutBucketInventoryConfiguration</a> </p> </li> </ul>', 'GetBucketLifecycle' => '<important> <p>For an updated version of this API, see <a>GetBucketLifecycleConfiguration</a>. If you configured a bucket lifecycle using the <code>filter</code> element, you should see the updated version of this topic. This topic is provided for backward compatibility.</p> </important> <p>Returns the lifecycle configuration information set on the bucket. For information about lifecycle configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle Management</a>.</p> <p> To use this operation, you must have permission to perform the <code>s3:GetLifecycleConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <p> <code>GetBucketLifecycle</code> has the following special error:</p> <ul> <li> <p>Error code: <code>NoSuchLifecycleConfiguration</code> </p> <ul> <li> <p>Description: The lifecycle configuration does not exist.</p> </li> <li> <p>HTTP Status Code: 404 Not Found</p> </li> <li> <p>SOAP Fault Code Prefix: Client</p> </li> </ul> </li> </ul> <p>The following operations are related to <code>GetBucketLifecycle</code>:</p> <ul> <li> <p> <a>GetBucketLifecycleConfiguration</a> </p> </li> <li> <p> <a>PutBucketLifecycle</a> </p> </li> <li> <p> <a>DeleteBucketLifecycle</a> </p> </li> </ul>', 'GetBucketLifecycleConfiguration' => '<note> <p>Bucket lifecycle configuration now supports specifying a lifecycle rule using an object key name prefix, one or more object tags, or a combination of both. Accordingly, this section describes the latest API. The response describes the new filter element that you can use to specify a filter to select a subset of objects to which the rule applies. If you are still using previous version of the lifecycle configuration, it works. For the earlier API description, see <a>GetBucketLifecycle</a>.</p> </note> <p>Returns the lifecycle configuration information set on the bucket. For information about lifecycle configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle Management</a>.</p> <p>To use this operation, you must have permission to perform the <code>s3:GetLifecycleConfiguration</code> action. The bucket owner has this permission, by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <p> <code>GetBucketLifecycleConfiguration</code> has the following special error:</p> <ul> <li> <p>Error code: <code>NoSuchLifecycleConfiguration</code> </p> <ul> <li> <p>Description: The lifecycle configuration does not exist.</p> </li> <li> <p>HTTP Status Code: 404 Not Found</p> </li> <li> <p>SOAP Fault Code Prefix: Client</p> </li> </ul> </li> </ul> <p>The following operations are related to <code>GetBucketLifecycleConfiguration</code>:</p> <ul> <li> <p> <a>GetBucketLifecycle</a> </p> </li> <li> <p> <a>PutBucketLifecycle</a> </p> </li> <li> <p> <a>DeleteBucketLifecycle</a> </p> </li> </ul>', 'GetBucketLocation' => '<p>Returns the Region the bucket resides in. You set the bucket\'s Region using the <code>LocationConstraint</code> request parameter in a <code>CreateBucket</code> request. For more information, see <a>CreateBucket</a>.</p> <p> To use this implementation of the operation, you must be the bucket owner.</p> <p>The following operations are related to <code>GetBucketLocation</code>:</p> <ul> <li> <p> <a>GetObject</a> </p> </li> <li> <p> <a>CreateBucket</a> </p> </li> </ul>', 'GetBucketLogging' => '<p>Returns the logging status of a bucket and the permissions users have to view and modify that status. To use GET, you must be the bucket owner.</p> <p>The following operations are related to <code>GetBucketLogging</code>:</p> <ul> <li> <p> <a>CreateBucket</a> </p> </li> <li> <p> <a>PutBucketLogging</a> </p> </li> </ul>', 'GetBucketMetricsConfiguration' => '<p>Gets a metrics configuration (specified by the metrics configuration ID) from the bucket. Note that this doesn\'t include the daily storage metrics.</p> <p> To use this operation, you must have permissions to perform the <code>s3:GetMetricsConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <p> For information about CloudWatch request metrics for Amazon S3, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with Amazon CloudWatch</a>.</p> <p>The following operations are related to <code>GetBucketMetricsConfiguration</code>:</p> <ul> <li> <p> <a>PutBucketMetricsConfiguration</a> </p> </li> <li> <p> <a>DeleteBucketMetricsConfiguration</a> </p> </li> <li> <p> <a>ListBucketMetricsConfigurations</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with Amazon CloudWatch</a> </p> </li> </ul>', 'GetBucketNotification' => '<p> No longer used, see <a>GetBucketNotificationConfiguration</a>.</p>', 'GetBucketNotificationConfiguration' => '<p>Returns the notification configuration of a bucket.</p> <p>If notifications are not enabled on the bucket, the operation returns an empty <code>NotificationConfiguration</code> element.</p> <p>By default, you must be the bucket owner to read the notification configuration of a bucket. However, the bucket owner can use a bucket policy to grant permission to other users to read this configuration with the <code>s3:GetBucketNotification</code> permission.</p> <p>For more information about setting and reading the notification configuration on a bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Setting Up Notification of Bucket Events</a>. For more information about bucket policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies</a>.</p> <p>The following operation is related to <code>GetBucketNotification</code>:</p> <ul> <li> <p> <a>PutBucketNotification</a> </p> </li> </ul>', 'GetBucketPolicy' => '<p>Returns the policy of a specified bucket. If you are using an identity other than the root user of the AWS account that owns the bucket, the calling identity must have the <code>GetBucketPolicy</code> permissions on the specified bucket and belong to the bucket owner\'s account in order to use this operation.</p> <p>If you don\'t have <code>GetBucketPolicy</code> permissions, Amazon S3 returns a <code>403 Access Denied</code> error. If you have the correct permissions, but you\'re not using an identity that belongs to the bucket owner\'s account, Amazon S3 returns a <code>405 Method Not Allowed</code> error.</p> <important> <p>As a security precaution, the root user of the AWS account that owns a bucket can always use this operation, even if the policy explicitly denies the root user the ability to perform this action.</p> </important> <p>For more information about bucket policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User Policies</a>.</p> <p>The following operation is related to <code>GetBucketPolicy</code>:</p> <ul> <li> <p> <a>GetObject</a> </p> </li> </ul>', 'GetBucketPolicyStatus' => '<p>Retrieves the policy status for an Amazon S3 bucket, indicating whether the bucket is public. In order to use this operation, you must have the <code>s3:GetBucketPolicyStatus</code> permission. For more information about Amazon S3 permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a Policy</a>.</p> <p> For more information about when Amazon S3 considers a bucket public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a>. </p> <p>The following operations are related to <code>GetBucketPolicyStatus</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html">Using Amazon S3 Block Public Access</a> </p> </li> <li> <p> <a>GetPublicAccessBlock</a> </p> </li> <li> <p> <a>PutPublicAccessBlock</a> </p> </li> <li> <p> <a>DeletePublicAccessBlock</a> </p> </li> </ul>', 'GetBucketReplication' => '<p>Returns the replication configuration of a bucket.</p> <note> <p> It can take a while to propagate the put or delete a replication configuration to all Amazon S3 systems. Therefore, a get request soon after put or delete can return a wrong result. </p> </note> <p> For information about replication configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html">Replication</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> <p>This operation requires permissions for the <code>s3:GetReplicationConfiguration</code> action. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User Policies</a>.</p> <p>If you include the <code>Filter</code> element in a replication configuration, you must also include the <code>DeleteMarkerReplication</code> and <code>Priority</code> elements. The response also returns those elements.</p> <p>For information about <code>GetBucketReplication</code> errors, see <a>ReplicationErrorCodeList</a> </p> <p>The following operations are related to <code>GetBucketReplication</code>:</p> <ul> <li> <p> <a>PutBucketReplication</a> </p> </li> <li> <p> <a>DeleteBucketReplication</a> </p> </li> </ul>', 'GetBucketRequestPayment' => '<p>Returns the request payment configuration of a bucket. To use this version of the operation, you must be the bucket owner. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a>.</p> <p>The following operations are related to <code>GetBucketRequestPayment</code>:</p> <ul> <li> <p> <a>ListObjects</a> </p> </li> </ul>', 'GetBucketTagging' => '<p>Returns the tag set associated with the bucket.</p> <p>To use this operation, you must have permission to perform the <code>s3:GetBucketTagging</code> action. By default, the bucket owner has this permission and can grant this permission to others.</p> <p> <code>GetBucketTagging</code> has the following special error:</p> <ul> <li> <p>Error code: <code>NoSuchTagSetError</code> </p> <ul> <li> <p>Description: There is no tag set associated with the bucket.</p> </li> </ul> </li> </ul> <p>The following operations are related to <code>GetBucketTagging</code>:</p> <ul> <li> <p> <a>PutBucketTagging</a> </p> </li> <li> <p> <a>DeleteBucketTagging</a> </p> </li> </ul>', 'GetBucketVersioning' => '<p>Returns the versioning state of a bucket.</p> <p>To retrieve the versioning state of a bucket, you must be the bucket owner.</p> <p>This implementation also returns the MFA Delete status of the versioning state. If the MFA Delete status is <code>enabled</code>, the bucket owner must use an authentication device to change the versioning state of the bucket.</p> <p>The following operations are related to <code>GetBucketVersioning</code>:</p> <ul> <li> <p> <a>GetObject</a> </p> </li> <li> <p> <a>PutObject</a> </p> </li> <li> <p> <a>DeleteObject</a> </p> </li> </ul>', 'GetBucketWebsite' => '<p>Returns the website configuration for a bucket. To host website on Amazon S3, you can configure a bucket as website by adding a website configuration. For more information about hosting websites, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a>. </p> <p>This GET operation requires the <code>S3:GetBucketWebsite</code> permission. By default, only the bucket owner can read the bucket website configuration. However, bucket owners can allow other users to read the website configuration by writing a bucket policy granting them the <code>S3:GetBucketWebsite</code> permission.</p> <p>The following operations are related to <code>DeleteBucketWebsite</code>:</p> <ul> <li> <p> <a>DeleteBucketWebsite</a> </p> </li> <li> <p> <a>PutBucketWebsite</a> </p> </li> </ul>', 'GetObject' => '<p>Retrieves objects from Amazon S3. To use <code>GET</code>, you must have <code>READ</code> access to the object. If you grant <code>READ</code> access to the anonymous user, you can return the object without using an authorization header.</p> <p>An Amazon S3 bucket has no directory hierarchy such as you would find in a typical computer file system. You can, however, create a logical hierarchy by using object key names that imply a folder structure. For example, instead of naming an object <code>sample.jpg</code>, you can name it <code>photos/2006/February/sample.jpg</code>.</p> <p>To get an object from such a logical hierarchy, specify the full key name for the object in the <code>GET</code> operation. For a virtual hosted-style request example, if you have the object <code>photos/2006/February/sample.jpg</code>, specify the resource as <code>/photos/2006/February/sample.jpg</code>. For a path-style request example, if you have the object <code>photos/2006/February/sample.jpg</code> in the bucket named <code>examplebucket</code>, specify the resource as <code>/examplebucket/photos/2006/February/sample.jpg</code>. For more information about request types, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html#VirtualHostingSpecifyBucket">HTTP Host Header Bucket Specification</a>.</p> <p>To distribute large files to many people, you can save bandwidth costs by using BitTorrent. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3Torrent.html">Amazon S3 Torrent</a>. For more information about returning the ACL of an object, see <a>GetObjectAcl</a>.</p> <p>If the object you are retrieving is stored in the GLACIER or DEEP_ARCHIVE storage classes, before you can retrieve the object you must first restore a copy using . Otherwise, this operation returns an <code>InvalidObjectStateError</code> error. For information about restoring archived objects, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html">Restoring Archived Objects</a>.</p> <p>Encryption request headers, like <code>x-amz-server-side-encryption</code>, should not be sent for GET requests if your object uses server-side encryption with CMKs stored in AWS KMS (SSE-KMS) or server-side encryption with Amazon S3–managed encryption keys (SSE-S3). If your object does use these types of keys, you’ll get an HTTP 400 BadRequest error.</p> <p>If you encrypt an object by using server-side encryption with customer-provided encryption keys (SSE-C) when you store the object in Amazon S3, then when you GET the object, you must use the following headers:</p> <ul> <li> <p>x-amz-server-side​-encryption​-customer-algorithm</p> </li> <li> <p>x-amz-server-side​-encryption​-customer-key</p> </li> <li> <p>x-amz-server-side​-encryption​-customer-key-MD5</p> </li> </ul> <p>For more information about SSE-C, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Server-Side Encryption (Using Customer-Provided Encryption Keys)</a>.</p> <p>Assuming you have permission to read object tags (permission for the <code>s3:GetObjectVersionTagging</code> action), the response also returns the <code>x-amz-tagging-count</code> header that provides the count of number of tags associated with the object. You can use <a>GetObjectTagging</a> to retrieve the tag set associated with an object.</p> <p> <b>Permissions</b> </p> <p>You need the <code>s3:GetObject</code> permission for this operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a Policy</a>. If the object you request does not exist, the error Amazon S3 returns depends on whether you also have the <code>s3:ListBucket</code> permission.</p> <ul> <li> <p>If you have the <code>s3:ListBucket</code> permission on the bucket, Amazon S3 will return an HTTP status code 404 ("no such key") error.</p> </li> <li> <p>If you don’t have the <code>s3:ListBucket</code> permission, Amazon S3 will return an HTTP status code 403 ("access denied") error.</p> </li> </ul> <p> <b>Versioning</b> </p> <p>By default, the GET operation returns the current version of an object. To return a different version, use the <code>versionId</code> subresource.</p> <note> <p>If the current version of the object is a delete marker, Amazon S3 behaves as if the object was deleted and includes <code>x-amz-delete-marker: true</code> in the response.</p> </note> <p>For more information about versioning, see <a>PutBucketVersioning</a>. </p> <p> <b>Overriding Response Header Values</b> </p> <p>There are times when you want to override certain response header values in a GET response. For example, you might override the Content-Disposition response header value in your GET request.</p> <p>You can override values for a set of response headers using the following query parameters. These response header values are sent only on a successful request, that is, when status code 200 OK is returned. The set of headers you can override using these parameters is a subset of the headers that Amazon S3 accepts when you create an object. The response headers that you can override for the GET response are <code>Content-Type</code>, <code>Content-Language</code>, <code>Expires</code>, <code>Cache-Control</code>, <code>Content-Disposition</code>, and <code>Content-Encoding</code>. To override these header values in the GET response, you use the following request parameters.</p> <note> <p>You must sign the request, either using an Authorization header or a presigned URL, when using these parameters. They cannot be used with an unsigned (anonymous) request.</p> </note> <ul> <li> <p> <code>response-content-type</code> </p> </li> <li> <p> <code>response-content-language</code> </p> </li> <li> <p> <code>response-expires</code> </p> </li> <li> <p> <code>response-cache-control</code> </p> </li> <li> <p> <code>response-content-disposition</code> </p> </li> <li> <p> <code>response-content-encoding</code> </p> </li> </ul> <p> <b>Additional Considerations about Request Headers</b> </p> <p>If both of the <code>If-Match</code> and <code>If-Unmodified-Since</code> headers are present in the request as follows: <code>If-Match</code> condition evaluates to <code>true</code>, and; <code>If-Unmodified-Since</code> condition evaluates to <code>false</code>; then, S3 returns 200 OK and the data requested. </p> <p>If both of the <code>If-None-Match</code> and <code>If-Modified-Since</code> headers are present in the request as follows:<code> If-None-Match</code> condition evaluates to <code>false</code>, and; <code>If-Modified-Since</code> condition evaluates to <code>true</code>; then, S3 returns 304 Not Modified response code.</p> <p>For more information about conditional requests, see <a href="https://tools.ietf.org/html/rfc7232">RFC 7232</a>.</p> <p>The following operations are related to <code>GetObject</code>:</p> <ul> <li> <p> <a>ListBuckets</a> </p> </li> <li> <p> <a>GetObjectAcl</a> </p> </li> </ul>', 'GetObjectAcl' => '<p>Returns the access control list (ACL) of an object. To use this operation, you must have READ_ACP access to the object.</p> <p> <b>Versioning</b> </p> <p>By default, GET returns ACL information about the current version of an object. To return ACL information about a different version, use the versionId subresource.</p> <p>The following operations are related to <code>GetObjectAcl</code>:</p> <ul> <li> <p> <a>GetObject</a> </p> </li> <li> <p> <a>DeleteObject</a> </p> </li> <li> <p> <a>PutObject</a> </p> </li> </ul>', 'GetObjectLegalHold' => '<p>Gets an object\'s current Legal Hold status. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a>.</p>', 'GetObjectLockConfiguration' => '<p>Gets the Object Lock configuration for a bucket. The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a>.</p>', 'GetObjectRetention' => '<p>Retrieves an object\'s retention settings. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a>.</p>', 'GetObjectTagging' => '<p>Returns the tag-set of an object. You send the GET request against the tagging subresource associated with the object.</p> <p>To use this operation, you must have permission to perform the <code>s3:GetObjectTagging</code> action. By default, the GET operation returns information about current version of an object. For a versioned bucket, you can have multiple versions of an object in your bucket. To retrieve tags of any other version, use the versionId query parameter. You also need permission for the <code>s3:GetObjectVersionTagging</code> action.</p> <p> By default, the bucket owner has this permission and can grant this permission to others.</p> <p> For information about the Amazon S3 object tagging feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html">Object Tagging</a>.</p> <p>The following operation is related to <code>GetObjectTagging</code>:</p> <ul> <li> <p> <a>PutObjectTagging</a> </p> </li> </ul>', 'GetObjectTorrent' => '<p>Return torrent files from a bucket. BitTorrent can save you bandwidth when you\'re distributing large files. For more information about BitTorrent, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3Torrent.html">Amazon S3 Torrent</a>.</p> <note> <p>You can get torrent only for objects that are less than 5 GB in size and that are not encrypted using server-side encryption with customer-provided encryption key.</p> </note> <p>To use GET, you must have READ access to the object.</p> <p>The following operation is related to <code>GetObjectTorrent</code>:</p> <ul> <li> <p> <a>GetObject</a> </p> </li> </ul>', 'GetPublicAccessBlock' => '<p>Retrieves the <code>PublicAccessBlock</code> configuration for an Amazon S3 bucket. To use this operation, you must have the <code>s3:GetBucketPublicAccessBlock</code> permission. For more information about Amazon S3 permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a Policy</a>.</p> <important> <p>When Amazon S3 evaluates the <code>PublicAccessBlock</code> configuration for a bucket or an object, it checks the <code>PublicAccessBlock</code> configuration for both the bucket (or the bucket that contains the object) and the bucket owner\'s account. If the <code>PublicAccessBlock</code> settings are different between the bucket and the account, Amazon S3 uses the most restrictive combination of the bucket-level and account-level settings.</p> </important> <p>For more information about when Amazon S3 considers a bucket or an object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a>.</p> <p>The following operations are related to <code>GetPublicAccessBlock</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html">Using Amazon S3 Block Public Access</a> </p> </li> <li> <p> <a>PutPublicAccessBlock</a> </p> </li> <li> <p> <a>GetPublicAccessBlock</a> </p> </li> <li> <p> <a>DeletePublicAccessBlock</a> </p> </li> </ul>', 'HeadBucket' => '<p>This operation is useful to determine if a bucket exists and you have permission to access it. The operation returns a <code>200 OK</code> if the bucket exists and you have permission to access it. Otherwise, the operation might return responses such as <code>404 Not Found</code> and <code>403 Forbidden</code>. </p> <p>To use this operation, you must have permissions to perform the <code>s3:ListBucket</code> action. The bucket owner has this permission by default and can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p>', 'HeadObject' => '<p>The HEAD operation retrieves metadata from an object without returning the object itself. This operation is useful if you\'re only interested in an object\'s metadata. To use HEAD, you must have READ access to the object.</p> <p>A <code>HEAD</code> request has the same options as a <code>GET</code> operation on an object. The response is identical to the <code>GET</code> response except that there is no response body.</p> <p>If you encrypt an object by using server-side encryption with customer-provided encryption keys (SSE-C) when you store the object in Amazon S3, then when you retrieve the metadata from the object, you must use the following headers:</p> <ul> <li> <p>x-amz-server-side​-encryption​-customer-algorithm</p> </li> <li> <p>x-amz-server-side​-encryption​-customer-key</p> </li> <li> <p>x-amz-server-side​-encryption​-customer-key-MD5</p> </li> </ul> <p>For more information about SSE-C, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Server-Side Encryption (Using Customer-Provided Encryption Keys)</a>.</p> <note> <p>Encryption request headers, like <code>x-amz-server-side-encryption</code>, should not be sent for GET requests if your object uses server-side encryption with CMKs stored in AWS KMS (SSE-KMS) or server-side encryption with Amazon S3–managed encryption keys (SSE-S3). If your object does use these types of keys, you’ll get an HTTP 400 BadRequest error.</p> </note> <p>Request headers are limited to 8 KB in size. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTCommonRequestHeaders.html">Common Request Headers</a>.</p> <p>Consider the following when using request headers:</p> <ul> <li> <p> Consideration 1 – If both of the <code>If-Match</code> and <code>If-Unmodified-Since</code> headers are present in the request as follows:</p> <ul> <li> <p> <code>If-Match</code> condition evaluates to <code>true</code>, and;</p> </li> <li> <p> <code>If-Unmodified-Since</code> condition evaluates to <code>false</code>;</p> </li> </ul> <p>Then Amazon S3 returns <code>200 OK</code> and the data requested.</p> </li> <li> <p> Consideration 2 – If both of the <code>If-None-Match</code> and <code>If-Modified-Since</code> headers are present in the request as follows:</p> <ul> <li> <p> <code>If-None-Match</code> condition evaluates to <code>false</code>, and;</p> </li> <li> <p> <code>If-Modified-Since</code> condition evaluates to <code>true</code>;</p> </li> </ul> <p>Then Amazon S3 returns the <code>304 Not Modified</code> response code.</p> </li> </ul> <p>For more information about conditional requests, see <a href="https://tools.ietf.org/html/rfc7232">RFC 7232</a>.</p> <p> <b>Permissions</b> </p> <p>You need the <code>s3:GetObject</code> permission for this operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a Policy</a>. If the object you request does not exist, the error Amazon S3 returns depends on whether you also have the s3:ListBucket permission.</p> <ul> <li> <p>If you have the <code>s3:ListBucket</code> permission on the bucket, Amazon S3 returns an HTTP status code 404 ("no such key") error.</p> </li> <li> <p>If you don’t have the <code>s3:ListBucket</code> permission, Amazon S3 returns an HTTP status code 403 ("access denied") error.</p> </li> </ul> <p>The following operation is related to <code>HeadObject</code>:</p> <ul> <li> <p> <a>GetObject</a> </p> </li> </ul>', 'ListBucketAnalyticsConfigurations' => '<p>Lists the analytics configurations for the bucket. You can have up to 1,000 analytics configurations per bucket.</p> <p>This operation supports list pagination and does not return more than 100 configurations at a time. You should always check the <code>IsTruncated</code> element in the response. If there are no more configurations to list, <code>IsTruncated</code> is set to false. If there are more configurations to list, <code>IsTruncated</code> is set to true, and there will be a value in <code>NextContinuationToken</code>. You use the <code>NextContinuationToken</code> value to continue the pagination of the list by passing the value in continuation-token in the request to <code>GET</code> the next page.</p> <p>To use this operation, you must have permissions to perform the <code>s3:GetAnalyticsConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <p>For information about Amazon S3 analytics feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html">Amazon S3 Analytics – Storage Class Analysis</a>. </p> <p>The following operations are related to <code>ListBucketAnalyticsConfigurations</code>:</p> <ul> <li> <p> <a>GetBucketAnalyticsConfiguration</a> </p> </li> <li> <p> <a>DeleteBucketAnalyticsConfiguration</a> </p> </li> <li> <p> <a>PutBucketAnalyticsConfiguration</a> </p> </li> </ul>', 'ListBucketInventoryConfigurations' => '<p>Returns a list of inventory configurations for the bucket. You can have up to 1,000 analytics configurations per bucket.</p> <p>This operation supports list pagination and does not return more than 100 configurations at a time. Always check the <code>IsTruncated</code> element in the response. If there are no more configurations to list, <code>IsTruncated</code> is set to false. If there are more configurations to list, <code>IsTruncated</code> is set to true, and there is a value in <code>NextContinuationToken</code>. You use the <code>NextContinuationToken</code> value to continue the pagination of the list by passing the value in continuation-token in the request to <code>GET</code> the next page.</p> <p> To use this operation, you must have permissions to perform the <code>s3:GetInventoryConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <p>For information about the Amazon S3 inventory feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html">Amazon S3 Inventory</a> </p> <p>The following operations are related to <code>ListBucketInventoryConfigurations</code>:</p> <ul> <li> <p> <a>GetBucketInventoryConfiguration</a> </p> </li> <li> <p> <a>DeleteBucketInventoryConfiguration</a> </p> </li> <li> <p> <a>PutBucketInventoryConfiguration</a> </p> </li> </ul>', 'ListBucketMetricsConfigurations' => '<p>Lists the metrics configurations for the bucket. The metrics configurations are only for the request metrics of the bucket and do not provide information on daily storage metrics. You can have up to 1,000 configurations per bucket.</p> <p>This operation supports list pagination and does not return more than 100 configurations at a time. Always check the <code>IsTruncated</code> element in the response. If there are no more configurations to list, <code>IsTruncated</code> is set to false. If there are more configurations to list, <code>IsTruncated</code> is set to true, and there is a value in <code>NextContinuationToken</code>. You use the <code>NextContinuationToken</code> value to continue the pagination of the list by passing the value in <code>continuation-token</code> in the request to <code>GET</code> the next page.</p> <p>To use this operation, you must have permissions to perform the <code>s3:GetMetricsConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <p>For more information about metrics configurations and CloudWatch request metrics, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with Amazon CloudWatch</a>.</p> <p>The following operations are related to <code>ListBucketMetricsConfigurations</code>:</p> <ul> <li> <p> <a>PutBucketMetricsConfiguration</a> </p> </li> <li> <p> <a>GetBucketMetricsConfiguration</a> </p> </li> <li> <p> <a>DeleteBucketMetricsConfiguration</a> </p> </li> </ul>', 'ListBuckets' => '<p>Returns a list of all buckets owned by the authenticated sender of the request.</p>', 'ListMultipartUploads' => '<p>This operation lists in-progress multipart uploads. An in-progress multipart upload is a multipart upload that has been initiated using the Initiate Multipart Upload request, but has not yet been completed or aborted.</p> <p>This operation returns at most 1,000 multipart uploads in the response. 1,000 multipart uploads is the maximum number of uploads a response can include, which is also the default value. You can further limit the number of uploads in a response by specifying the <code>max-uploads</code> parameter in the response. If additional multipart uploads satisfy the list criteria, the response will contain an <code>IsTruncated</code> element with the value true. To list the additional multipart uploads, use the <code>key-marker</code> and <code>upload-id-marker</code> request parameters.</p> <p>In the response, the uploads are sorted by key. If your application has initiated more than one multipart upload using the same object key, then uploads in the response are first sorted by key. Additionally, uploads are sorted in ascending order within each key by the upload initiation time.</p> <p>For more information on multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html">Uploading Objects Using Multipart Upload</a>.</p> <p>For information on permissions required to use the multipart upload API, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html">Multipart Upload API and Permissions</a>.</p> <p>The following operations are related to <code>ListMultipartUploads</code>:</p> <ul> <li> <p> <a>CreateMultipartUpload</a> </p> </li> <li> <p> <a>UploadPart</a> </p> </li> <li> <p> <a>CompleteMultipartUpload</a> </p> </li> <li> <p> <a>ListParts</a> </p> </li> <li> <p> <a>AbortMultipartUpload</a> </p> </li> </ul>', 'ListObjectVersions' => '<p>Returns metadata about all of the versions of objects in a bucket. You can also use request parameters as selection criteria to return metadata about a subset of all the object versions. </p> <note> <p> A 200 OK response can contain valid or invalid XML. Make sure to design your application to parse the contents of the response and handle it appropriately.</p> </note> <p>To use this operation, you must have READ access to the bucket.</p> <p>The following operations are related to <code>ListObjectVersions</code>:</p> <ul> <li> <p> <a>ListObjectsV2</a> </p> </li> <li> <p> <a>GetObject</a> </p> </li> <li> <p> <a>PutObject</a> </p> </li> <li> <p> <a>DeleteObject</a> </p> </li> </ul>', 'ListObjects' => '<p>Returns some or all (up to 1,000) of the objects in a bucket. You can use the request parameters as selection criteria to return a subset of the objects in a bucket. A 200 OK response can contain valid or invalid XML. Be sure to design your application to parse the contents of the response and handle it appropriately.</p> <important> <p>This API has been revised. We recommend that you use the newer version, <a>ListObjectsV2</a>, when developing applications. For backward compatibility, Amazon S3 continues to support <code>ListObjects</code>.</p> </important> <p>The following operations are related to <code>ListObjects</code>:</p> <ul> <li> <p> <a>ListObjectsV2</a> </p> </li> <li> <p> <a>GetObject</a> </p> </li> <li> <p> <a>PutObject</a> </p> </li> <li> <p> <a>CreateBucket</a> </p> </li> <li> <p> <a>ListBuckets</a> </p> </li> </ul>', 'ListObjectsV2' => '<p>Returns some or all (up to 1,000) of the objects in a bucket. You can use the request parameters as selection criteria to return a subset of the objects in a bucket. A <code>200 OK</code> response can contain valid or invalid XML. Make sure to design your application to parse the contents of the response and handle it appropriately.</p> <p>To use this operation, you must have READ access to the bucket.</p> <p>To use this operation in an AWS Identity and Access Management (IAM) policy, you must have permissions to perform the <code>s3:ListBucket</code> action. The bucket owner has this permission by default and can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <important> <p>This section describes the latest revision of the API. We recommend that you use this revised API for application development. For backward compatibility, Amazon S3 continues to support the prior version of this API, <a>ListObjects</a>.</p> </important> <p>To get a list of your buckets, see <a>ListBuckets</a>.</p> <p>The following operations are related to <code>ListObjectsV2</code>:</p> <ul> <li> <p> <a>GetObject</a> </p> </li> <li> <p> <a>PutObject</a> </p> </li> <li> <p> <a>CreateBucket</a> </p> </li> </ul>', 'ListParts' => '<p>Lists the parts that have been uploaded for a specific multipart upload. This operation must include the upload ID, which you obtain by sending the initiate multipart upload request (see <a>CreateMultipartUpload</a>). This request returns a maximum of 1,000 uploaded parts. The default number of parts returned is 1,000 parts. You can restrict the number of parts returned by specifying the <code>max-parts</code> request parameter. If your multipart upload consists of more than 1,000 parts, the response returns an <code>IsTruncated</code> field with the value of true, and a <code>NextPartNumberMarker</code> element. In subsequent <code>ListParts</code> requests you can include the part-number-marker query string parameter and set its value to the <code>NextPartNumberMarker</code> field value from the previous response.</p> <p>For more information on multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html">Uploading Objects Using Multipart Upload</a>.</p> <p>For information on permissions required to use the multipart upload API, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html">Multipart Upload API and Permissions</a>.</p> <p>The following operations are related to <code>ListParts</code>:</p> <ul> <li> <p> <a>CreateMultipartUpload</a> </p> </li> <li> <p> <a>UploadPart</a> </p> </li> <li> <p> <a>CompleteMultipartUpload</a> </p> </li> <li> <p> <a>AbortMultipartUpload</a> </p> </li> <li> <p> <a>ListMultipartUploads</a> </p> </li> </ul>', 'PutBucketAccelerateConfiguration' => '<p>Sets the accelerate configuration of an existing bucket. Amazon S3 Transfer Acceleration is a bucket-level feature that enables you to perform faster data transfers to Amazon S3.</p> <p> To use this operation, you must have permission to perform the s3:PutAccelerateConfiguration action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <p> The Transfer Acceleration state of a bucket can be set to one of the following two values:</p> <ul> <li> <p> Enabled – Enables accelerated data transfers to the bucket.</p> </li> <li> <p> Suspended – Disables accelerated data transfers to the bucket.</p> </li> </ul> <p>The <a>GetBucketAccelerateConfiguration</a> operation returns the transfer acceleration state of a bucket.</p> <p>After setting the Transfer Acceleration state of a bucket to Enabled, it might take up to thirty minutes before the data transfer rates to the bucket increase.</p> <p> The name of the bucket used for Transfer Acceleration must be DNS-compliant and must not contain periods (".").</p> <p> For more information about transfer acceleration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Transfer Acceleration</a>.</p> <p>The following operations are related to <code>PutBucketAccelerateConfiguration</code>:</p> <ul> <li> <p> <a>GetBucketAccelerateConfiguration</a> </p> </li> <li> <p> <a>CreateBucket</a> </p> </li> </ul>', 'PutBucketAcl' => '<p>Sets the permissions on an existing bucket using access control lists (ACL). For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html">Using ACLs</a>. To set the ACL of a bucket, you must have <code>WRITE_ACP</code> permission.</p> <p>You can use one of the following two ways to set a bucket\'s permissions:</p> <ul> <li> <p>Specify the ACL in the request body</p> </li> <li> <p>Specify permissions using request headers</p> </li> </ul> <note> <p>You cannot specify access permission using both the body and the request headers.</p> </note> <p>Depending on your application needs, you may choose to set the ACL on a bucket using either the request body or the headers. For example, if you have an existing application that updates a bucket ACL using the request body, then you can continue to use that approach.</p> <p> <b>Access Permissions</b> </p> <p>You can set access permissions using one of the following methods:</p> <ul> <li> <p>Specify a canned ACL with the <code>x-amz-acl</code> request header. Amazon S3 supports a set of predefined ACLs, known as <i>canned ACLs</i>. Each canned ACL has a predefined set of grantees and permissions. Specify the canned ACL name as the value of <code>x-amz-acl</code>. If you use this header, you cannot use other access control-specific headers in your request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.</p> </li> <li> <p>Specify access permissions explicitly with the <code>x-amz-grant-read</code>, <code>x-amz-grant-read-acp</code>, <code>x-amz-grant-write-acp</code>, and <code>x-amz-grant-full-control</code> headers. When using these headers, you specify explicit access permissions and grantees (AWS accounts or Amazon S3 groups) who will receive the permission. If you use these ACL-specific headers, you cannot use the <code>x-amz-acl</code> header to set a canned ACL. These parameters map to the set of permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a>.</p> <p>You specify each grantee as a type=value pair, where the type is one of the following:</p> <ul> <li> <p> <code>id</code> – if the value specified is the canonical user ID of an AWS account</p> </li> <li> <p> <code>uri</code> – if you are granting permissions to a predefined group</p> </li> <li> <p> <code>emailAddress</code> – if the value specified is the email address of an AWS account</p> <note> <p>Using email addresses to specify a grantee is only supported in the following AWS Regions: </p> <ul> <li> <p>US East (N. Virginia)</p> </li> <li> <p>US West (N. California)</p> </li> <li> <p> US West (Oregon)</p> </li> <li> <p> Asia Pacific (Singapore)</p> </li> <li> <p>Asia Pacific (Sydney)</p> </li> <li> <p>Asia Pacific (Tokyo)</p> </li> <li> <p>Europe (Ireland)</p> </li> <li> <p>South America (São Paulo)</p> </li> </ul> <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the AWS General Reference.</p> </note> </li> </ul> <p>For example, the following <code>x-amz-grant-write</code> header grants create, overwrite, and delete objects permission to LogDelivery group predefined by Amazon S3 and two AWS accounts identified by their email addresses.</p> <p> <code>x-amz-grant-write: uri="http://acs.amazonaws.com/groups/s3/LogDelivery", id="111122223333", id="555566667777" </code> </p> </li> </ul> <p>You can use either a canned ACL or specify access permissions explicitly. You cannot do both.</p> <p> <b>Grantee Values</b> </p> <p>You can specify the person (grantee) to whom you\'re assigning access rights (using request elements) in the following ways:</p> <ul> <li> <p>By the person\'s ID:</p> <p> <code>&lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="CanonicalUser"&gt;&lt;ID&gt;&lt;&gt;ID&lt;&gt;&lt;/ID&gt;&lt;DisplayName&gt;&lt;&gt;GranteesEmail&lt;&gt;&lt;/DisplayName&gt; &lt;/Grantee&gt;</code> </p> <p>DisplayName is optional and ignored in the request</p> </li> <li> <p>By URI:</p> <p> <code>&lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="Group"&gt;&lt;URI&gt;&lt;&gt;http://acs.amazonaws.com/groups/global/AuthenticatedUsers&lt;&gt;&lt;/URI&gt;&lt;/Grantee&gt;</code> </p> </li> <li> <p>By Email address:</p> <p> <code>&lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="AmazonCustomerByEmail"&gt;&lt;EmailAddress&gt;&lt;&gt;Grantees@email.com&lt;&gt;&lt;/EmailAddress&gt;lt;/Grantee&gt;</code> </p> <p>The grantee is resolved to the CanonicalUser and, in a response to a GET Object acl request, appears as the CanonicalUser. </p> <note> <p>Using email addresses to specify a grantee is only supported in the following AWS Regions: </p> <ul> <li> <p>US East (N. Virginia)</p> </li> <li> <p>US West (N. California)</p> </li> <li> <p> US West (Oregon)</p> </li> <li> <p> Asia Pacific (Singapore)</p> </li> <li> <p>Asia Pacific (Sydney)</p> </li> <li> <p>Asia Pacific (Tokyo)</p> </li> <li> <p>Europe (Ireland)</p> </li> <li> <p>South America (São Paulo)</p> </li> </ul> <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the AWS General Reference.</p> </note> </li> </ul> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> <a>CreateBucket</a> </p> </li> <li> <p> <a>DeleteBucket</a> </p> </li> <li> <p> <a>GetObjectAcl</a> </p> </li> </ul>', 'PutBucketAnalyticsConfiguration' => '<p>Sets an analytics configuration for the bucket (specified by the analytics configuration ID). You can have up to 1,000 analytics configurations per bucket.</p> <p>You can choose to have storage class analysis export analysis reports sent to a comma-separated values (CSV) flat file. See the <code>DataExport</code> request element. Reports are updated daily and are based on the object filters that you configure. When selecting data export, you specify a destination bucket and an optional destination prefix where the file is written. You can export the data to a destination bucket in a different account. However, the destination bucket must be in the same Region as the bucket that you are making the PUT analytics configuration to. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html">Amazon S3 Analytics – Storage Class Analysis</a>. </p> <important> <p>You must create a bucket policy on the destination bucket where the exported file is written to grant permissions to Amazon S3 to write objects to the bucket. For an example policy, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html#example-bucket-policies-use-case-9">Granting Permissions for Amazon S3 Inventory and Storage Class Analysis</a>.</p> </important> <p>To use this operation, you must have permissions to perform the <code>s3:PutAnalyticsConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <p class="title"> <b>Special Errors</b> </p> <ul> <li> <ul> <li> <p> <i>HTTP Error: HTTP 400 Bad Request</i> </p> </li> <li> <p> <i>Code: InvalidArgument</i> </p> </li> <li> <p> <i>Cause: Invalid argument.</i> </p> </li> </ul> </li> <li> <ul> <li> <p> <i>HTTP Error: HTTP 400 Bad Request</i> </p> </li> <li> <p> <i>Code: TooManyConfigurations</i> </p> </li> <li> <p> <i>Cause: You are attempting to create a new configuration but have already reached the 1,000-configuration limit.</i> </p> </li> </ul> </li> <li> <ul> <li> <p> <i>HTTP Error: HTTP 403 Forbidden</i> </p> </li> <li> <p> <i>Code: AccessDenied</i> </p> </li> <li> <p> <i>Cause: You are not the owner of the specified bucket, or you do not have the s3:PutAnalyticsConfiguration bucket permission to set the configuration on the bucket.</i> </p> </li> </ul> </li> </ul> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> </p> </li> <li> <p> </p> </li> <li> <p> </p> </li> </ul>', 'PutBucketCors' => '<p>Sets the <code>cors</code> configuration for your bucket. If the configuration exists, Amazon S3 replaces it.</p> <p>To use this operation, you must be allowed to perform the <code>s3:PutBucketCORS</code> action. By default, the bucket owner has this permission and can grant it to others.</p> <p>You set this configuration on a bucket so that the bucket can service cross-origin requests. For example, you might want to enable a request whose origin is <code>http://www.example.com</code> to access your Amazon S3 bucket at <code>my.example.bucket.com</code> by using the browser\'s <code>XMLHttpRequest</code> capability.</p> <p>To enable cross-origin resource sharing (CORS) on a bucket, you add the <code>cors</code> subresource to the bucket. The <code>cors</code> subresource is an XML document in which you configure rules that identify origins and the HTTP methods that can be executed on your bucket. The document is limited to 64 KB in size. </p> <p>When Amazon S3 receives a cross-origin request (or a pre-flight OPTIONS request) against a bucket, it evaluates the <code>cors</code> configuration on the bucket and uses the first <code>CORSRule</code> rule that matches the incoming browser request to enable a cross-origin request. For a rule to match, the following conditions must be met:</p> <ul> <li> <p>The request\'s <code>Origin</code> header must match <code>AllowedOrigin</code> elements.</p> </li> <li> <p>The request method (for example, GET, PUT, HEAD, and so on) or the <code>Access-Control-Request-Method</code> header in case of a pre-flight <code>OPTIONS</code> request must be one of the <code>AllowedMethod</code> elements. </p> </li> <li> <p>Every header specified in the <code>Access-Control-Request-Headers</code> request header of a pre-flight request must match an <code>AllowedHeader</code> element. </p> </li> </ul> <p> For more information about CORS, go to <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> <a>GetBucketCors</a> </p> </li> <li> <p> <a>DeleteBucketCors</a> </p> </li> <li> <p> <a>RESTOPTIONSobject</a> </p> </li> </ul>', 'PutBucketEncryption' => '<p>This implementation of the <code>PUT</code> operation uses the <code>encryption</code> subresource to set the default encryption state of an existing bucket.</p> <p>This implementation of the <code>PUT</code> operation sets default encryption for a bucket using server-side encryption with Amazon S3-managed keys SSE-S3 or AWS KMS customer master keys (CMKs) (SSE-KMS). For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Bucket Encryption</a>.</p> <important> <p>This operation requires AWS Signature Version 4. For more information, see <a href="sig-v4-authenticating-requests.html"> Authenticating Requests (AWS Signature Version 4)</a>. </p> </important> <p>To use this operation, you must have permissions to perform the <code>s3:PutEncryptionConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a> in the Amazon Simple Storage Service Developer Guide. </p> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> <a>GetBucketEncryption</a> </p> </li> <li> <p> <a>DeleteBucketEncryption</a> </p> </li> </ul>', 'PutBucketInventoryConfiguration' => '<p>This implementation of the <code>PUT</code> operation adds an inventory configuration (identified by the inventory ID) to the bucket. You can have up to 1,000 inventory configurations per bucket. </p> <p>Amazon S3 inventory generates inventories of the objects in the bucket on a daily or weekly basis, and the results are published to a flat file. The bucket that is inventoried is called the <i>source</i> bucket, and the bucket where the inventory flat file is stored is called the <i>destination</i> bucket. The <i>destination</i> bucket must be in the same AWS Region as the <i>source</i> bucket. </p> <p>When you configure an inventory for a <i>source</i> bucket, you specify the <i>destination</i> bucket where you want the inventory to be stored, and whether to generate the inventory daily or weekly. You can also configure what object metadata to include and whether to inventory all object versions or only current versions. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html">Amazon S3 Inventory</a> in the Amazon Simple Storage Service Developer Guide.</p> <important> <p>You must create a bucket policy on the <i>destination</i> bucket to grant permissions to Amazon S3 to write objects to the bucket in the defined location. For an example policy, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html#example-bucket-policies-use-case-9"> Granting Permissions for Amazon S3 Inventory and Storage Class Analysis</a>.</p> </important> <p>To use this operation, you must have permissions to perform the <code>s3:PutInventoryConfiguration</code> action. The bucket owner has this permission by default and can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a> in the Amazon Simple Storage Service Developer Guide.</p> <p class="title"> <b>Special Errors</b> </p> <ul> <li> <p class="title"> <b>HTTP 400 Bad Request Error</b> </p> <ul> <li> <p> <i>Code:</i> InvalidArgument</p> </li> <li> <p> <i>Cause:</i> Invalid Argument</p> </li> </ul> </li> <li> <p class="title"> <b>HTTP 400 Bad Request Error</b> </p> <ul> <li> <p> <i>Code:</i> TooManyConfigurations</p> </li> <li> <p> <i>Cause:</i> You are attempting to create a new configuration but have already reached the 1,000-configuration limit. </p> </li> </ul> </li> <li> <p class="title"> <b>HTTP 403 Forbidden Error</b> </p> <ul> <li> <p> <i>Code:</i> AccessDenied</p> </li> <li> <p> <i>Cause:</i> You are not the owner of the specified bucket, or you do not have the <code>s3:PutInventoryConfiguration</code> bucket permission to set the configuration on the bucket. </p> </li> </ul> </li> </ul> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> <a>GetBucketInventoryConfiguration</a> </p> </li> <li> <p> <a>DeleteBucketInventoryConfiguration</a> </p> </li> <li> <p> <a>ListBucketInventoryConfigurations</a> </p> </li> </ul>', 'PutBucketLifecycle' => '<important> <p>For an updated version of this API, see <a>PutBucketLifecycleConfiguration</a>. This version has been deprecated. Existing lifecycle configurations will work. For new lifecycle configurations, use the updated API. </p> </important> <p>Creates a new lifecycle configuration for the bucket or replaces an existing lifecycle configuration. For information about lifecycle configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle Management</a> in the <i>Amazon Simple Storage Service Developer Guide</i>. </p> <p>By default, all Amazon S3 resources, including buckets, objects, and related subresources (for example, lifecycle configuration and website configuration) are private. Only the resource owner, the AWS account that created the resource, can access it. The resource owner can optionally grant access permissions to others by writing an access policy. For this operation, users must get the <code>s3:PutLifecycleConfiguration</code> permission.</p> <p>You can also explicitly deny permissions. Explicit denial also supersedes any other permissions. If you want to prevent users or accounts from removing or deleting objects from your bucket, you must deny them permissions for the following actions: </p> <ul> <li> <p> <code>s3:DeleteObject</code> </p> </li> <li> <p> <code>s3:DeleteObjectVersion</code> </p> </li> <li> <p> <code>s3:PutLifecycleConfiguration</code> </p> </li> </ul> <p>For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to your Amazon S3 Resources</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> <p>For more examples of transitioning objects to storage classes such as STANDARD_IA or ONEZONE_IA, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#lifecycle-configuration-examples">Examples of Lifecycle Configuration</a>.</p> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> <a>GetBucketLifecycle</a>(Deprecated)</p> </li> <li> <p> <a>GetBucketLifecycleConfiguration</a> </p> </li> <li> <p> </p> </li> <li> <p>By default, a resource owner—in this case, a bucket owner, which is the AWS account that created the bucket—can perform any of the operations. A resource owner can also grant others permission to perform the operation. For more information, see the following topics in the Amazon Simple Storage Service Developer Guide: </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a Policy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to your Amazon S3 Resources</a> </p> </li> </ul> </li> </ul>', 'PutBucketLifecycleConfiguration' => '<p>Creates a new lifecycle configuration for the bucket or replaces an existing lifecycle configuration. For information about lifecycle configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <note> <p>Bucket lifecycle configuration now supports specifying a lifecycle rule using an object key name prefix, one or more object tags, or a combination of both. Accordingly, this section describes the latest API. The previous version of the API supported filtering based only on an object key name prefix, which is supported for backward compatibility. For the related API description, see <a>PutBucketLifecycle</a>.</p> </note> <p> <b>Rules</b> </p> <p>You specify the lifecycle configuration in your request body. The lifecycle configuration is specified as XML consisting of one or more rules. Each rule consists of the following:</p> <ul> <li> <p>Filter identifying a subset of objects to which the rule applies. The filter can be based on a key name prefix, object tags, or a combination of both.</p> </li> <li> <p>Status whether the rule is in effect.</p> </li> <li> <p>One or more lifecycle transition and expiration actions that you want Amazon S3 to perform on the objects identified by the filter. If the state of your bucket is versioning-enabled or versioning-suspended, you can have many versions of the same object (one current version and zero or more noncurrent versions). Amazon S3 provides predefined actions that you can specify for current and noncurrent object versions.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle Management</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html">Lifecycle Configuration Elements</a>.</p> <p> <b>Permissions</b> </p> <p>By default, all Amazon S3 resources are private, including buckets, objects, and related subresources (for example, lifecycle configuration and website configuration). Only the resource owner (that is, the AWS account that created it) can access the resource. The resource owner can optionally grant access permissions to others by writing an access policy. For this operation, a user must get the s3:PutLifecycleConfiguration permission.</p> <p>You can also explicitly deny permissions. Explicit deny also supersedes any other permissions. If you want to block users or accounts from removing or deleting objects from your bucket, you must deny them permissions for the following actions:</p> <ul> <li> <p>s3:DeleteObject</p> </li> <li> <p>s3:DeleteObjectVersion</p> </li> <li> <p>s3:PutLifecycleConfiguration</p> </li> </ul> <p>For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <p>The following are related to <code>PutBucketLifecycleConfiguration</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-configuration-examples.html">Examples of Lifecycle Configuration</a> </p> </li> <li> <p> <a>GetBucketLifecycleConfiguration</a> </p> </li> <li> <p> <a>DeleteBucketLifecycle</a> </p> </li> </ul>', 'PutBucketLogging' => '<p>Set the logging parameters for a bucket and to specify permissions for who can view and modify the logging parameters. All logs are saved to buckets in the same AWS Region as the source bucket. To set the logging status of a bucket, you must be the bucket owner.</p> <p>The bucket owner is automatically granted FULL_CONTROL to all logs. You use the <code>Grantee</code> request element to grant access to other people. The <code>Permissions</code> request element specifies the kind of access the grantee has to the logs.</p> <p> <b>Grantee Values</b> </p> <p>You can specify the person (grantee) to whom you\'re assigning access rights (using request elements) in the following ways:</p> <ul> <li> <p>By the person\'s ID:</p> <p> <code>&lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="CanonicalUser"&gt;&lt;ID&gt;&lt;&gt;ID&lt;&gt;&lt;/ID&gt;&lt;DisplayName&gt;&lt;&gt;GranteesEmail&lt;&gt;&lt;/DisplayName&gt; &lt;/Grantee&gt;</code> </p> <p>DisplayName is optional and ignored in the request.</p> </li> <li> <p>By Email address:</p> <p> <code> &lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="AmazonCustomerByEmail"&gt;&lt;EmailAddress&gt;&lt;&gt;Grantees@email.com&lt;&gt;&lt;/EmailAddress&gt;&lt;/Grantee&gt;</code> </p> <p>The grantee is resolved to the CanonicalUser and, in a response to a GET Object acl request, appears as the CanonicalUser.</p> </li> <li> <p>By URI:</p> <p> <code>&lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="Group"&gt;&lt;URI&gt;&lt;&gt;http://acs.amazonaws.com/groups/global/AuthenticatedUsers&lt;&gt;&lt;/URI&gt;&lt;/Grantee&gt;</code> </p> </li> </ul> <p>To enable logging, you use LoggingEnabled and its children request elements. To disable logging, you use an empty BucketLoggingStatus request element:</p> <p> <code>&lt;BucketLoggingStatus xmlns="http://doc.s3.amazonaws.com/2006-03-01" /&gt;</code> </p> <p>For more information about server access logging, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerLogs.html">Server Access Logging</a>. </p> <p>For more information about creating a bucket, see <a>CreateBucket</a>. For more information about returning the logging status of a bucket, see <a>GetBucketLogging</a>.</p> <p>The following operations are related to <code>PutBucketLogging</code>:</p> <ul> <li> <p> <a>PutObject</a> </p> </li> <li> <p> <a>DeleteBucket</a> </p> </li> <li> <p> <a>CreateBucket</a> </p> </li> <li> <p> <a>GetBucketLogging</a> </p> </li> </ul>', 'PutBucketMetricsConfiguration' => '<p>Sets a metrics configuration (specified by the metrics configuration ID) for the bucket. You can have up to 1,000 metrics configurations per bucket. If you\'re updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don\'t include the elements you want to keep, they are erased.</p> <p>To use this operation, you must have permissions to perform the <code>s3:PutMetricsConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <p>For information about CloudWatch request metrics for Amazon S3, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with Amazon CloudWatch</a>.</p> <p>The following operations are related to <code>PutBucketMetricsConfiguration</code>:</p> <ul> <li> <p> <a>DeleteBucketMetricsConfiguration</a> </p> </li> <li> <p> <a>PutBucketMetricsConfiguration</a> </p> </li> <li> <p> <a>ListBucketMetricsConfigurations</a> </p> </li> </ul> <p> <code>GetBucketLifecycle</code> has the following special error:</p> <ul> <li> <p>Error code: <code>TooManyConfigurations</code> </p> <ul> <li> <p>Description: You are attempting to create a new configuration but have already reached the 1,000-configuration limit.</p> </li> <li> <p>HTTP Status Code: HTTP 400 Bad Request</p> </li> </ul> </li> </ul>', 'PutBucketNotification' => '<p> No longer used, see the <a>PutBucketNotificationConfiguration</a> operation.</p>', 'PutBucketNotificationConfiguration' => '<p>Enables notifications of specified events for a bucket. For more information about event notifications, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a>.</p> <p>Using this API, you can replace an existing notification configuration. The configuration is an XML file that defines the event types that you want Amazon S3 to publish and the destination where you want Amazon S3 to publish an event notification when it detects an event of the specified type.</p> <p>By default, your bucket has no event notifications configured. That is, the notification configuration will be an empty <code>NotificationConfiguration</code>.</p> <p> <code>&lt;NotificationConfiguration&gt;</code> </p> <p> <code>&lt;/NotificationConfiguration&gt;</code> </p> <p>This operation replaces the existing notification configuration with the configuration you include in the request body.</p> <p>After Amazon S3 receives this request, it first verifies that any Amazon Simple Notification Service (Amazon SNS) or Amazon Simple Queue Service (Amazon SQS) destination exists, and that the bucket owner has permission to publish to it by sending a test notification. In the case of AWS Lambda destinations, Amazon S3 verifies that the Lambda function permissions grant Amazon S3 permission to invoke the function from the Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Notifications for Amazon S3 Events</a>.</p> <p>You can disable notifications by adding the empty NotificationConfiguration element.</p> <p>By default, only the bucket owner can configure notifications on a bucket. However, bucket owners can use a bucket policy to grant permission to other users to set this configuration with <code>s3:PutBucketNotification</code> permission.</p> <note> <p>The PUT notification is an atomic operation. For example, suppose your notification configuration includes SNS topic, SQS queue, and Lambda function configurations. When you send a PUT request with this configuration, Amazon S3 sends test messages to your SNS topic. If the message fails, the entire PUT operation will fail, and Amazon S3 will not add the configuration to your bucket.</p> </note> <p> <b>Responses</b> </p> <p>If the configuration in the request body includes only one <code>TopicConfiguration</code> specifying only the <code>s3:ReducedRedundancyLostObject</code> event type, the response will also include the <code>x-amz-sns-test-message-id</code> header containing the message ID of the test notification sent to the topic.</p> <p>The following operation is related to <code>PutBucketNotificationConfiguration</code>:</p> <ul> <li> <p> <a>GetBucketNotificationConfiguration</a> </p> </li> </ul>', 'PutBucketPolicy' => '<p>Applies an Amazon S3 bucket policy to an Amazon S3 bucket. If you are using an identity other than the root user of the AWS account that owns the bucket, the calling identity must have the <code>PutBucketPolicy</code> permissions on the specified bucket and belong to the bucket owner\'s account in order to use this operation.</p> <p>If you don\'t have <code>PutBucketPolicy</code> permissions, Amazon S3 returns a <code>403 Access Denied</code> error. If you have the correct permissions, but you\'re not using an identity that belongs to the bucket owner\'s account, Amazon S3 returns a <code>405 Method Not Allowed</code> error.</p> <important> <p> As a security precaution, the root user of the AWS account that owns a bucket can always use this operation, even if the policy explicitly denies the root user the ability to perform this action. </p> </important> <p>For more information about bucket policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User Policies</a>.</p> <p>The following operations are related to <code>PutBucketPolicy</code>:</p> <ul> <li> <p> <a>CreateBucket</a> </p> </li> <li> <p> <a>DeleteBucket</a> </p> </li> </ul>', 'PutBucketReplication' => '<p> Creates a replication configuration or replaces an existing one. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html">Replication</a> in the <i>Amazon S3 Developer Guide</i>. </p> <note> <p>To perform this operation, the user or role performing the operation must have the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">iam:PassRole</a> permission.</p> </note> <p>Specify the replication configuration in the request body. In the replication configuration, you provide the name of the destination bucket where you want Amazon S3 to replicate objects, the IAM role that Amazon S3 can assume to replicate objects on your behalf, and other relevant information.</p> <p>A replication configuration must include at least one rule, and can contain a maximum of 1,000. Each rule identifies a subset of objects to replicate by filtering the objects in the source bucket. To choose additional subsets of objects to replicate, add a rule for each subset. All rules must specify the same destination bucket.</p> <p>To specify a subset of the objects in the source bucket to apply a replication rule to, add the Filter element as a child of the Rule element. You can filter objects based on an object key prefix, one or more object tags, or both. When you add the Filter element in the configuration, you must also add the following elements: <code>DeleteMarkerReplication</code>, <code>Status</code>, and <code>Priority</code>.</p> <note> <p>The latest version of the replication configuration XML is V2. XML V2 replication configurations are those that contain the <code>Filter</code> element for rules, and rules that specify S3 Replication Time Control (S3 RTC). In XML V2 replication configurations, Amazon S3 doesn\'t replicate delete markers. Therefore, you must set the <code>DeleteMarkerReplication</code> element to <code>Disabled</code>. For backward compatibility, Amazon S3 continues to support the XML V1 replication configuration.</p> </note> <p>For information about enabling versioning on a bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html">Using Versioning</a>.</p> <p>By default, a resource owner, in this case the AWS account that created the bucket, can perform this operation. The resource owner can also grant others permissions to perform the operation. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a Policy</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <p> <b>Handling Replication of Encrypted Objects</b> </p> <p>By default, Amazon S3 doesn\'t replicate objects that are stored at rest using server-side encryption with CMKs stored in AWS KMS. To replicate AWS KMS-encrypted objects, add the following: <code>SourceSelectionCriteria</code>, <code>SseKmsEncryptedObjects</code>, <code>Status</code>, <code>EncryptionConfiguration</code>, and <code>ReplicaKmsKeyID</code>. For information about replication configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-config-for-kms-objects.html">Replicating Objects Created with SSE Using CMKs stored in AWS KMS</a>.</p> <p>For information on <code>PutBucketReplication</code> errors, see <a>ReplicationErrorCodeList</a> </p> <p>The following operations are related to <code>PutBucketReplication</code>:</p> <ul> <li> <p> <a>GetBucketReplication</a> </p> </li> <li> <p> <a>DeleteBucketReplication</a> </p> </li> </ul>', 'PutBucketRequestPayment' => '<p>Sets the request payment configuration for a bucket. By default, the bucket owner pays for downloads from the bucket. This configuration parameter enables the bucket owner (only) to specify that the person requesting the download will be charged for the download. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a>.</p> <p>The following operations are related to <code>PutBucketRequestPayment</code>:</p> <ul> <li> <p> <a>CreateBucket</a> </p> </li> <li> <p> <a>GetBucketRequestPayment</a> </p> </li> </ul>', 'PutBucketTagging' => '<p>Sets the tags for a bucket.</p> <p>Use tags to organize your AWS bill to reflect your own cost structure. To do this, sign up to get your AWS account bill with tag key values included. Then, to see the cost of combined resources, organize your billing information according to resources with the same tag key values. For example, you can tag several resources with a specific application name, and then organize your billing information to see the total cost of that application across several services. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Cost Allocation and Tagging</a>.</p> <note> <p>Within a bucket, if you add a tag that has the same key as an existing tag, the new value overwrites the old value. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/CostAllocTagging.html">Using Cost Allocation in Amazon S3 Bucket Tags</a>.</p> </note> <p>To use this operation, you must have permissions to perform the <code>s3:PutBucketTagging</code> action. The bucket owner has this permission by default and can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <p> <code>PutBucketTagging</code> has the following special errors:</p> <ul> <li> <p>Error code: <code>InvalidTagError</code> </p> <ul> <li> <p>Description: The tag provided was not a valid tag. This error can occur if the tag did not pass input validation. For information about tag restrictions, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">User-Defined Tag Restrictions</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/aws-tag-restrictions.html">AWS-Generated Cost Allocation Tag Restrictions</a>.</p> </li> </ul> </li> <li> <p>Error code: <code>MalformedXMLError</code> </p> <ul> <li> <p>Description: The XML provided does not match the schema.</p> </li> </ul> </li> <li> <p>Error code: <code>OperationAbortedError </code> </p> <ul> <li> <p>Description: A conflicting conditional operation is currently in progress against this resource. Please try again.</p> </li> </ul> </li> <li> <p>Error code: <code>InternalError</code> </p> <ul> <li> <p>Description: The service was unable to apply the provided tag to the bucket.</p> </li> </ul> </li> </ul> <p>The following operations are related to <code>PutBucketTagging</code>:</p> <ul> <li> <p> <a>GetBucketTagging</a> </p> </li> <li> <p> <a>DeleteBucketTagging</a> </p> </li> </ul>', 'PutBucketVersioning' => '<p>Sets the versioning state of an existing bucket. To set the versioning state, you must be the bucket owner.</p> <p>You can set the versioning state with one of the following values:</p> <p> <b>Enabled</b>—Enables versioning for the objects in the bucket. All objects added to the bucket receive a unique version ID.</p> <p> <b>Suspended</b>—Disables versioning for the objects in the bucket. All objects added to the bucket receive the version ID null.</p> <p>If the versioning state has never been set on a bucket, it has no versioning state; a <a>GetBucketVersioning</a> request does not return a versioning state value.</p> <p>If the bucket owner enables MFA Delete in the bucket versioning configuration, the bucket owner must include the <code>x-amz-mfa request</code> header and the <code>Status</code> and the <code>MfaDelete</code> request elements in a request to set the versioning state of the bucket.</p> <important> <p>If you have an object expiration lifecycle policy in your non-versioned bucket and you want to maintain the same permanent delete behavior when you enable versioning, you must add a noncurrent expiration policy. The noncurrent expiration lifecycle policy will manage the deletes of the noncurrent object versions in the version-enabled bucket. (A version-enabled bucket maintains one current and zero or more noncurrent object versions.) For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html#lifecycle-and-other-bucket-config">Lifecycle and Versioning</a>.</p> </important> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> <a>CreateBucket</a> </p> </li> <li> <p> <a>DeleteBucket</a> </p> </li> <li> <p> <a>GetBucketVersioning</a> </p> </li> </ul>', 'PutBucketWebsite' => '<p>Sets the configuration of the website that is specified in the <code>website</code> subresource. To configure a bucket as a website, you can add this subresource on the bucket with website configuration information such as the file name of the index document and any redirect rules. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a>.</p> <p>This PUT operation requires the <code>S3:PutBucketWebsite</code> permission. By default, only the bucket owner can configure the website attached to a bucket; however, bucket owners can allow other users to set the website configuration by writing a bucket policy that grants them the <code>S3:PutBucketWebsite</code> permission.</p> <p>To redirect all website requests sent to the bucket\'s website endpoint, you add a website configuration with the following elements. Because all requests are sent to another website, you don\'t need to provide index document name for the bucket.</p> <ul> <li> <p> <code>WebsiteConfiguration</code> </p> </li> <li> <p> <code>RedirectAllRequestsTo</code> </p> </li> <li> <p> <code>HostName</code> </p> </li> <li> <p> <code>Protocol</code> </p> </li> </ul> <p>If you want granular control over redirects, you can use the following elements to add routing rules that describe conditions for redirecting requests and information about the redirect destination. In this case, the website configuration must provide an index document for the bucket, because some requests might not be redirected. </p> <ul> <li> <p> <code>WebsiteConfiguration</code> </p> </li> <li> <p> <code>IndexDocument</code> </p> </li> <li> <p> <code>Suffix</code> </p> </li> <li> <p> <code>ErrorDocument</code> </p> </li> <li> <p> <code>Key</code> </p> </li> <li> <p> <code>RoutingRules</code> </p> </li> <li> <p> <code>RoutingRule</code> </p> </li> <li> <p> <code>Condition</code> </p> </li> <li> <p> <code>HttpErrorCodeReturnedEquals</code> </p> </li> <li> <p> <code>KeyPrefixEquals</code> </p> </li> <li> <p> <code>Redirect</code> </p> </li> <li> <p> <code>Protocol</code> </p> </li> <li> <p> <code>HostName</code> </p> </li> <li> <p> <code>ReplaceKeyPrefixWith</code> </p> </li> <li> <p> <code>ReplaceKeyWith</code> </p> </li> <li> <p> <code>HttpRedirectCode</code> </p> </li> </ul> <p>Amazon S3 has a limitation of 50 routing rules per website configuration. If you require more than 50 routing rules, you can use object redirect. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html">Configuring an Object Redirect</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'PutObject' => '<p>Adds an object to a bucket. You must have WRITE permissions on a bucket to add an object to it.</p> <p>Amazon S3 never adds partial objects; if you receive a success response, Amazon S3 added the entire object to the bucket.</p> <p>Amazon S3 is a distributed system. If it receives multiple write requests for the same object simultaneously, it overwrites all but the last object written. Amazon S3 does not provide object locking; if you need this, make sure to build it into your application layer or use versioning instead.</p> <p>To ensure that data is not corrupted traversing the network, use the <code>Content-MD5</code> header. When you use this header, Amazon S3 checks the object against the provided MD5 value and, if they do not match, returns an error. Additionally, you can calculate the MD5 while putting an object to Amazon S3 and compare the returned ETag to the calculated MD5 value.</p> <note> <p> The <code>Content-MD5</code> header is required for any request to upload an object with a retention period configured using Amazon S3 Object Lock. For more information about Amazon S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html">Amazon S3 Object Lock Overview</a> in the <i>Amazon Simple Storage Service Developer Guide</i>. </p> </note> <p> <b>Server-side Encryption</b> </p> <p>You can optionally request server-side encryption. With server-side encryption, Amazon S3 encrypts your data as it writes it to disks in its data centers and decrypts the data when you access it. You have the option to provide your own encryption key or use AWS managed encryption keys. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html">Using Server-Side Encryption</a>.</p> <p> <b>Access Control List (ACL)-Specific Request Headers</b> </p> <p>You can use headers to grant ACL- based permissions. By default, all objects are private. Only the owner has full access control. When adding a new object, you can grant permissions to individual AWS accounts or to predefined groups defined by Amazon S3. These permissions are then added to the ACL on the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-using-rest-api.html">Managing ACLs Using the REST API</a>. </p> <p> <b>Storage Class Options</b> </p> <p>By default, Amazon S3 uses the STANDARD storage class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different storage class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 Service Developer Guide</i>.</p> <p> <b>Versioning</b> </p> <p>If you enable versioning for a bucket, Amazon S3 automatically generates a unique version ID for the object being stored. Amazon S3 returns this ID in the response. When you enable versioning for a bucket, if Amazon S3 receives multiple write requests for the same object simultaneously, it stores all of the objects.</p> <p>For more information about versioning, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/AddingObjectstoVersioningEnabledBuckets.html">Adding Objects to Versioning Enabled Buckets</a>. For information about returning the versioning state of a bucket, see <a>GetBucketVersioning</a>. </p> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> <a>CopyObject</a> </p> </li> <li> <p> <a>DeleteObject</a> </p> </li> </ul>', 'PutObjectAcl' => '<p>Uses the <code>acl</code> subresource to set the access control list (ACL) permissions for an object that already exists in a bucket. You must have <code>WRITE_ACP</code> permission to set the ACL of an object.</p> <p>Depending on your application needs, you can choose to set the ACL on an object using either the request body or the headers. For example, if you have an existing application that updates a bucket ACL using the request body, you can continue to use that approach. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 Developer Guide</i>.</p> <p> <b>Access Permissions</b> </p> <p>You can set access permissions using one of the following methods:</p> <ul> <li> <p>Specify a canned ACL with the <code>x-amz-acl</code> request header. Amazon S3 supports a set of predefined ACLs, known as canned ACLs. Each canned ACL has a predefined set of grantees and permissions. Specify the canned ACL name as the value of <code>x-amz-ac</code>l. If you use this header, you cannot use other access control-specific headers in your request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.</p> </li> <li> <p>Specify access permissions explicitly with the <code>x-amz-grant-read</code>, <code>x-amz-grant-read-acp</code>, <code>x-amz-grant-write-acp</code>, and <code>x-amz-grant-full-control</code> headers. When using these headers, you specify explicit access permissions and grantees (AWS accounts or Amazon S3 groups) who will receive the permission. If you use these ACL-specific headers, you cannot use <code>x-amz-acl</code> header to set a canned ACL. These parameters map to the set of permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a>.</p> <p>You specify each grantee as a type=value pair, where the type is one of the following:</p> <ul> <li> <p> <code>id</code> – if the value specified is the canonical user ID of an AWS account</p> </li> <li> <p> <code>uri</code> – if you are granting permissions to a predefined group</p> </li> <li> <p> <code>emailAddress</code> – if the value specified is the email address of an AWS account</p> <note> <p>Using email addresses to specify a grantee is only supported in the following AWS Regions: </p> <ul> <li> <p>US East (N. Virginia)</p> </li> <li> <p>US West (N. California)</p> </li> <li> <p> US West (Oregon)</p> </li> <li> <p> Asia Pacific (Singapore)</p> </li> <li> <p>Asia Pacific (Sydney)</p> </li> <li> <p>Asia Pacific (Tokyo)</p> </li> <li> <p>Europe (Ireland)</p> </li> <li> <p>South America (São Paulo)</p> </li> </ul> <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the AWS General Reference.</p> </note> </li> </ul> <p>For example, the following <code>x-amz-grant-read</code> header grants list objects permission to the two AWS accounts identified by their email addresses.</p> <p> <code>x-amz-grant-read: emailAddress="xyz@amazon.com", emailAddress="abc@amazon.com" </code> </p> </li> </ul> <p>You can use either a canned ACL or specify access permissions explicitly. You cannot do both.</p> <p> <b>Grantee Values</b> </p> <p>You can specify the person (grantee) to whom you\'re assigning access rights (using request elements) in the following ways:</p> <ul> <li> <p>By the person\'s ID:</p> <p> <code>&lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="CanonicalUser"&gt;&lt;ID&gt;&lt;&gt;ID&lt;&gt;&lt;/ID&gt;&lt;DisplayName&gt;&lt;&gt;GranteesEmail&lt;&gt;&lt;/DisplayName&gt; &lt;/Grantee&gt;</code> </p> <p>DisplayName is optional and ignored in the request.</p> </li> <li> <p>By URI:</p> <p> <code>&lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="Group"&gt;&lt;URI&gt;&lt;&gt;http://acs.amazonaws.com/groups/global/AuthenticatedUsers&lt;&gt;&lt;/URI&gt;&lt;/Grantee&gt;</code> </p> </li> <li> <p>By Email address:</p> <p> <code>&lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="AmazonCustomerByEmail"&gt;&lt;EmailAddress&gt;&lt;&gt;Grantees@email.com&lt;&gt;&lt;/EmailAddress&gt;lt;/Grantee&gt;</code> </p> <p>The grantee is resolved to the CanonicalUser and, in a response to a GET Object acl request, appears as the CanonicalUser.</p> <note> <p>Using email addresses to specify a grantee is only supported in the following AWS Regions: </p> <ul> <li> <p>US East (N. Virginia)</p> </li> <li> <p>US West (N. California)</p> </li> <li> <p> US West (Oregon)</p> </li> <li> <p> Asia Pacific (Singapore)</p> </li> <li> <p>Asia Pacific (Sydney)</p> </li> <li> <p>Asia Pacific (Tokyo)</p> </li> <li> <p>Europe (Ireland)</p> </li> <li> <p>South America (São Paulo)</p> </li> </ul> <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the AWS General Reference.</p> </note> </li> </ul> <p> <b>Versioning</b> </p> <p>The ACL of an object is set at the object version level. By default, PUT sets the ACL of the current version of an object. To set the ACL of a different version, use the <code>versionId</code> subresource.</p> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> <a>CopyObject</a> </p> </li> <li> <p> <a>GetObject</a> </p> </li> </ul>', 'PutObjectLegalHold' => '<p>Applies a Legal Hold configuration to the specified object.</p> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a> </p> </li> </ul>', 'PutObjectLockConfiguration' => '<p>Places an Object Lock configuration on the specified bucket. The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket.</p> <note> <p> <code>DefaultRetention</code> requires either Days or Years. You can\'t specify both at the same time.</p> </note> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a> </p> </li> </ul>', 'PutObjectRetention' => '<p>Places an Object Retention configuration on an object.</p> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a> </p> </li> </ul>', 'PutObjectTagging' => '<p>Sets the supplied tag-set to an object that already exists in a bucket.</p> <p>A tag is a key-value pair. You can associate tags with an object by sending a PUT request against the tagging subresource that is associated with the object. You can retrieve tags by sending a GET request. For more information, see <a>GetObjectTagging</a>.</p> <p>For tagging-related restrictions related to characters and encodings, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">Tag Restrictions</a>. Note that Amazon S3 limits the maximum number of tags to 10 tags per object.</p> <p>To use this operation, you must have permission to perform the <code>s3:PutObjectTagging</code> action. By default, the bucket owner has this permission and can grant this permission to others.</p> <p>To put tags of any other version, use the <code>versionId</code> query parameter. You also need permission for the <code>s3:PutObjectVersionTagging</code> action.</p> <p>For information about the Amazon S3 object tagging feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html">Object Tagging</a>.</p> <p class="title"> <b>Special Errors</b> </p> <ul> <li> <p class="title"> <b/> </p> <ul> <li> <p> <i>Code: InvalidTagError </i> </p> </li> <li> <p> <i>Cause: The tag provided was not a valid tag. This error can occur if the tag did not pass input validation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html">Object Tagging</a>.</i> </p> </li> </ul> </li> <li> <p class="title"> <b/> </p> <ul> <li> <p> <i>Code: MalformedXMLError </i> </p> </li> <li> <p> <i>Cause: The XML provided does not match the schema.</i> </p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code: OperationAbortedError </i> </p> </li> <li> <p> <i>Cause: A conflicting conditional operation is currently in progress against this resource. Please try again.</i> </p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code: InternalError</i> </p> </li> <li> <p> <i>Cause: The service was unable to apply the provided tag to the object.</i> </p> </li> </ul> </li> </ul> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> <a>GetObjectTagging</a> </p> </li> </ul>', 'PutPublicAccessBlock' => '<p>Creates or modifies the <code>PublicAccessBlock</code> configuration for an Amazon S3 bucket. To use this operation, you must have the <code>s3:PutBucketPublicAccessBlock</code> permission. For more information about Amazon S3 permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a Policy</a>.</p> <important> <p>When Amazon S3 evaluates the <code>PublicAccessBlock</code> configuration for a bucket or an object, it checks the <code>PublicAccessBlock</code> configuration for both the bucket (or the bucket that contains the object) and the bucket owner\'s account. If the <code>PublicAccessBlock</code> configurations are different between the bucket and the account, Amazon S3 uses the most restrictive combination of the bucket-level and account-level settings.</p> </important> <p>For more information about when Amazon S3 considers a bucket or an object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a>.</p> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> <a>GetPublicAccessBlock</a> </p> </li> <li> <p> <a>DeletePublicAccessBlock</a> </p> </li> <li> <p> <a>GetBucketPolicyStatus</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html">Using Amazon S3 Block Public Access</a> </p> </li> </ul>', 'RestoreObject' => '<p>Restores an archived copy of an object back into Amazon S3</p> <p>This operation performs the following types of requests: </p> <ul> <li> <p> <code>select</code> - Perform a select query on an archived object</p> </li> <li> <p> <code>restore an archive</code> - Restore an archived object</p> </li> </ul> <p>To use this operation, you must have permissions to perform the <code>s3:RestoreObject</code> action. The bucket owner has this permission by default and can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> <p> <b>Querying Archives with Select Requests</b> </p> <p>You use a select type of request to perform SQL queries on archived objects. The archived objects that are being queried by the select request must be formatted as uncompressed comma-separated values (CSV) files. You can run queries and custom analytics on your archived data without having to restore your data to a hotter Amazon S3 tier. For an overview about select requests, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/querying-glacier-archives.html">Querying Archived Objects</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> <p>When making a select request, do the following:</p> <ul> <li> <p>Define an output location for the select query\'s output. This must be an Amazon S3 bucket in the same AWS Region as the bucket that contains the archive object that is being queried. The AWS account that initiates the job must have permissions to write to the S3 bucket. You can specify the storage class and encryption for the output objects stored in the bucket. For more information about output, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/querying-glacier-archives.html">Querying Archived Objects</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> <p>For more information about the <code>S3</code> structure in the request body, see the following:</p> <ul> <li> <p> <a>PutObject</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html">Managing Access with ACLs</a> in the <i>Amazon Simple Storage Service Developer Guide</i> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html">Protecting Data Using Server-Side Encryption</a> in the <i>Amazon Simple Storage Service Developer Guide</i> </p> </li> </ul> </li> <li> <p>Define the SQL expression for the <code>SELECT</code> type of restoration for your query in the request body\'s <code>SelectParameters</code> structure. You can use expressions like the following examples.</p> <ul> <li> <p>The following expression returns all records from the specified object.</p> <p> <code>SELECT * FROM Object</code> </p> </li> <li> <p>Assuming that you are not using any headers for data stored in the object, you can specify columns with positional headers.</p> <p> <code>SELECT s._1, s._2 FROM Object s WHERE s._3 &gt; 100</code> </p> </li> <li> <p>If you have headers and you set the <code>fileHeaderInfo</code> in the <code>CSV</code> structure in the request body to <code>USE</code>, you can specify headers in the query. (If you set the <code>fileHeaderInfo</code> field to <code>IGNORE</code>, the first row is skipped for the query.) You cannot mix ordinal positions with header column names. </p> <p> <code>SELECT s.Id, s.FirstName, s.SSN FROM S3Object s</code> </p> </li> </ul> </li> </ul> <p>For more information about using SQL with S3 Glacier Select restore, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-glacier-select-sql-reference.html">SQL Reference for Amazon S3 Select and S3 Glacier Select</a> in the <i>Amazon Simple Storage Service Developer Guide</i>. </p> <p>When making a select request, you can also do the following:</p> <ul> <li> <p>To expedite your queries, specify the <code>Expedited</code> tier. For more information about tiers, see "Restoring Archives," later in this topic.</p> </li> <li> <p>Specify details about the data serialization format of both the input object that is being queried and the serialization of the CSV-encoded query results.</p> </li> </ul> <p>The following are additional important facts about the select feature:</p> <ul> <li> <p>The output results are new Amazon S3 objects. Unlike archive retrievals, they are stored until explicitly deleted-manually or through a lifecycle policy.</p> </li> <li> <p>You can issue more than one select request on the same Amazon S3 object. Amazon S3 doesn\'t deduplicate requests, so avoid issuing duplicate requests.</p> </li> <li> <p> Amazon S3 accepts a select request even if the object has already been restored. A select request doesn’t return error response <code>409</code>.</p> </li> </ul> <p> <b>Restoring Archives</b> </p> <p>Objects in the GLACIER and DEEP_ARCHIVE storage classes are archived. To access an archived object, you must first initiate a restore request. This restores a temporary copy of the archived object. In a restore request, you specify the number of days that you want the restored copy to exist. After the specified period, Amazon S3 deletes the temporary copy but the object remains archived in the GLACIER or DEEP_ARCHIVE storage class that object was restored from. </p> <p>To restore a specific object version, you can provide a version ID. If you don\'t provide a version ID, Amazon S3 restores the current version.</p> <p>The time it takes restore jobs to finish depends on which storage class the object is being restored from and which data access tier you specify. </p> <p>When restoring an archived object (or using a select request), you can specify one of the following data access tier options in the <code>Tier</code> element of the request body: </p> <ul> <li> <p> <b> <code>Expedited</code> </b> - Expedited retrievals allow you to quickly access your data stored in the GLACIER storage class when occasional urgent requests for a subset of archives are required. For all but the largest archived objects (250 MB+), data accessed using Expedited retrievals are typically made available within 1–5 minutes. Provisioned capacity ensures that retrieval capacity for Expedited retrievals is available when you need it. Expedited retrievals and provisioned capacity are not available for the DEEP_ARCHIVE storage class.</p> </li> <li> <p> <b> <code>Standard</code> </b> - S3 Standard retrievals allow you to access any of your archived objects within several hours. This is the default option for the GLACIER and DEEP_ARCHIVE retrieval requests that do not specify the retrieval option. S3 Standard retrievals typically complete within 3-5 hours from the GLACIER storage class and typically complete within 12 hours from the DEEP_ARCHIVE storage class. </p> </li> <li> <p> <b> <code>Bulk</code> </b> - Bulk retrievals are Amazon S3 Glacier’s lowest-cost retrieval option, enabling you to retrieve large amounts, even petabytes, of data inexpensively in a day. Bulk retrievals typically complete within 5-12 hours from the GLACIER storage class and typically complete within 48 hours from the DEEP_ARCHIVE storage class.</p> </li> </ul> <p>For more information about archive retrieval options and provisioned capacity for <code>Expedited</code> data access, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html">Restoring Archived Objects</a> in the <i>Amazon Simple Storage Service Developer Guide</i>. </p> <p>You can use Amazon S3 restore speed upgrade to change the restore speed to a faster speed while it is in progress. You upgrade the speed of an in-progress restoration by issuing another restore request to the same object, setting a new <code>Tier</code> request element. When issuing a request to upgrade the restore tier, you must choose a tier that is faster than the tier that the in-progress restore is using. You must not change any other parameters, such as the <code>Days</code> request element. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html#restoring-objects-upgrade-tier.title.html"> Upgrading the Speed of an In-Progress Restore</a> in the <i>Amazon Simple Storage Service Developer Guide</i>. </p> <p>To get the status of object restoration, you can send a <code>HEAD</code> request. Operations return the <code>x-amz-restore</code> header, which provides information about the restoration status, in the response. You can use Amazon S3 event notifications to notify you when a restore is initiated or completed. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Amazon S3 Event Notifications</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> <p>After restoring an archived object, you can update the restoration period by reissuing the request with a new period. Amazon S3 updates the restoration period relative to the current time and charges only for the request-there are no data transfer charges. You cannot update the restoration period when Amazon S3 is actively processing your current restore request for the object.</p> <p>If your bucket has a lifecycle configuration with a rule that includes an expiration action, the object expiration overrides the life span that you specify in a restore request. For example, if you restore an object copy for 10 days, but the object is scheduled to expire in 3 days, Amazon S3 deletes the object in 3 days. For more information about lifecycle configuration, see <a>PutBucketLifecycleConfiguration</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle Management</a> in <i>Amazon Simple Storage Service Developer Guide</i>.</p> <p> <b>Responses</b> </p> <p>A successful operation returns either the <code>200 OK</code> or <code>202 Accepted</code> status code. </p> <ul> <li> <p>If the object copy is not previously restored, then Amazon S3 returns <code>202 Accepted</code> in the response. </p> </li> <li> <p>If the object copy is previously restored, Amazon S3 returns <code>200 OK</code> in the response. </p> </li> </ul> <p class="title"> <b>Special Errors</b> </p> <ul> <li> <p class="title"> <b/> </p> <ul> <li> <p> <i>Code: RestoreAlreadyInProgress</i> </p> </li> <li> <p> <i>Cause: Object restore is already in progress. (This error does not apply to SELECT type requests.)</i> </p> </li> <li> <p> <i>HTTP Status Code: 409 Conflict</i> </p> </li> <li> <p> <i>SOAP Fault Code Prefix: Client</i> </p> </li> </ul> </li> <li> <p class="title"> <b/> </p> <ul> <li> <p> <i>Code: GlacierExpeditedRetrievalNotAvailable</i> </p> </li> <li> <p> <i>Cause: S3 Glacier expedited retrievals are currently not available. Try again later. (Returned if there is insufficient capacity to process the Expedited request. This error applies only to Expedited retrievals and not to S3 Standard or Bulk retrievals.)</i> </p> </li> <li> <p> <i>HTTP Status Code: 503</i> </p> </li> <li> <p> <i>SOAP Fault Code Prefix: N/A</i> </p> </li> </ul> </li> </ul> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> <a>PutBucketLifecycleConfiguration</a> </p> </li> <li> <p> <a>GetBucketNotificationConfiguration</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-glacier-select-sql-reference.html">SQL Reference for Amazon S3 Select and S3 Glacier Select </a> in the <i>Amazon Simple Storage Service Developer Guide</i> </p> </li> </ul>', 'SelectObjectContent' => '<p>This operation filters the contents of an Amazon S3 object based on a simple structured query language (SQL) statement. In the request, along with the SQL expression, you must also specify a data serialization format (JSON, CSV, or Apache Parquet) of the object. Amazon S3 uses this format to parse object data into records, and returns only records that match the specified SQL expression. You must also specify the data serialization format for the response.</p> <p>For more information about Amazon S3 Select, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/selecting-content-from-objects.html">Selecting Content from Objects</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> <p>For more information about using SQL with Amazon S3 Select, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-glacier-select-sql-reference.html"> SQL Reference for Amazon S3 Select and S3 Glacier Select</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> <p/> <p> <b>Permissions</b> </p> <p>You must have <code>s3:GetObject</code> permission for this operation. Amazon S3 Select does not support anonymous access. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a Policy</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> <p/> <p> <i>Object Data Formats</i> </p> <p>You can use Amazon S3 Select to query objects that have the following format properties:</p> <ul> <li> <p> <i>CSV, JSON, and Parquet</i> - Objects must be in CSV, JSON, or Parquet format.</p> </li> <li> <p> <i>UTF-8</i> - UTF-8 is the only encoding type Amazon S3 Select supports.</p> </li> <li> <p> <i>GZIP or BZIP2</i> - CSV and JSON files can be compressed using GZIP or BZIP2. GZIP and BZIP2 are the only compression formats that Amazon S3 Select supports for CSV and JSON files. Amazon S3 Select supports columnar compression for Parquet using GZIP or Snappy. Amazon S3 Select does not support whole-object compression for Parquet objects.</p> </li> <li> <p> <i>Server-side encryption</i> - Amazon S3 Select supports querying objects that are protected with server-side encryption.</p> <p>For objects that are encrypted with customer-provided encryption keys (SSE-C), you must use HTTPS, and you must use the headers that are documented in the <a>GetObject</a>. For more information about SSE-C, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Server-Side Encryption (Using Customer-Provided Encryption Keys)</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> <p>For objects that are encrypted with Amazon S3 managed encryption keys (SSE-S3) and customer master keys (CMKs) stored in AWS Key Management Service (SSE-KMS), server-side encryption is handled transparently, so you don\'t need to specify anything. For more information about server-side encryption, including SSE-S3 and SSE-KMS, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html">Protecting Data Using Server-Side Encryption</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> </li> </ul> <p> <b>Working with the Response Body</b> </p> <p>Given the response size is unknown, Amazon S3 Select streams the response as a series of messages and includes a <code>Transfer-Encoding</code> header with <code>chunked</code> as its value in the response. For more information, see <a>RESTSelectObjectAppendix</a> .</p> <p/> <p> <b>GetObject Support</b> </p> <p>The <code>SelectObjectContent</code> operation does not support the following <code>GetObject</code> functionality. For more information, see <a>GetObject</a>.</p> <ul> <li> <p> <code>Range</code>: Although you can specify a scan range for an Amazon S3 Select request (see <a>SelectObjectContentRequest$ScanRange</a> in the request parameters), you cannot specify the range of bytes of an object to return. </p> </li> <li> <p>GLACIER, DEEP_ARCHIVE and REDUCED_REDUNDANCY storage classes: You cannot specify the GLACIER, DEEP_ARCHIVE, or <code>REDUCED_REDUNDANCY</code> storage classes. For more information, about storage classes see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#storage-class-intro">Storage Classes</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> </li> </ul> <p/> <p> <b>Special Errors</b> </p> <p>For a list of special errors for this operation, see <a>SelectObjectContentErrorCodeList</a> </p> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> <a>GetObject</a> </p> </li> <li> <p> <a>GetBucketLifecycleConfiguration</a> </p> </li> <li> <p> <a>PutBucketLifecycleConfiguration</a> </p> </li> </ul>', 'UploadPart' => '<p>Uploads a part in a multipart upload.</p> <note> <p>In this operation, you provide part data in your request. However, you have an option to specify your existing Amazon S3 object as a data source for the part you are uploading. To upload a part from an existing object, you use the <a>UploadPartCopy</a> operation. </p> </note> <p>You must initiate a multipart upload (see <a>CreateMultipartUpload</a>) before you can upload any part. In response to your initiate request, Amazon S3 returns an upload ID, a unique identifier, that you must include in your upload part request.</p> <p>Part numbers can be any number from 1 to 10,000, inclusive. A part number uniquely identifies a part and also defines its position within the object being created. If you upload a new part using the same part number that was used with a previous part, the previously uploaded part is overwritten. Each part must be at least 5 MB in size, except the last part. There is no size limit on the last part of your multipart upload.</p> <p>To ensure that data is not corrupted when traversing the network, specify the <code>Content-MD5</code> header in the upload part request. Amazon S3 checks the part data against the provided MD5 value. If they do not match, Amazon S3 returns an error. </p> <p> <b>Note:</b> After you initiate multipart upload and upload one or more parts, you must either complete or abort multipart upload in order to stop getting charged for storage of the uploaded parts. Only after you either complete or abort multipart upload, Amazon S3 frees up the parts storage and stops charging you for the parts storage.</p> <p>For more information on multipart uploads, go to <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html">Multipart Upload Overview</a> in the <i>Amazon Simple Storage Service Developer Guide </i>.</p> <p>For information on the permissions required to use the multipart upload API, go to <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html">Multipart Upload API and Permissions</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> <p>You can optionally request server-side encryption where Amazon S3 encrypts your data as it writes it to disks in its data centers and decrypts it for you when you access it. You have the option of providing your own encryption key, or you can use the AWS managed encryption keys. If you choose to provide your own encryption key, the request headers you provide in the request must match the headers you used in the request to initiate the upload by using <a>CreateMultipartUpload</a>. For more information, go to <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html">Using Server-Side Encryption</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> <p>Server-side encryption is supported by the S3 Multipart Upload actions. Unless you are using a customer-provided encryption key, you don\'t need to specify the encryption parameters in each UploadPart request. Instead, you only need to specify the server-side encryption parameters in the initial Initiate Multipart request. For more information, see <a>CreateMultipartUpload</a>.</p> <p>If you requested server-side encryption using a customer-provided encryption key in your initiate multipart upload request, you must provide identical encryption information in each part upload using the following headers.</p> <ul> <li> <p>x-amz-server-side​-encryption​-customer-algorithm</p> </li> <li> <p>x-amz-server-side​-encryption​-customer-key</p> </li> <li> <p>x-amz-server-side​-encryption​-customer-key-MD5</p> </li> </ul> <p class="title"> <b>Special Errors</b> </p> <ul> <li> <p class="title"> <b/> </p> <ul> <li> <p> <i>Code: NoSuchUpload</i> </p> </li> <li> <p> <i>Cause: The specified multipart upload does not exist. The upload ID might be invalid, or the multipart upload might have been aborted or completed.</i> </p> </li> <li> <p> <i> HTTP Status Code: 404 Not Found </i> </p> </li> <li> <p> <i>SOAP Fault Code Prefix: Client</i> </p> </li> </ul> </li> </ul> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> <a>CreateMultipartUpload</a> </p> </li> <li> <p> <a>CompleteMultipartUpload</a> </p> </li> <li> <p> <a>AbortMultipartUpload</a> </p> </li> <li> <p> <a>ListParts</a> </p> </li> <li> <p> <a>ListMultipartUploads</a> </p> </li> </ul>', 'UploadPartCopy' => '<p>Uploads a part by copying data from an existing object as data source. You specify the data source by adding the request header <code>x-amz-copy-source</code> in your request and a byte range by adding the request header <code>x-amz-copy-source-range</code> in your request. </p> <p>The minimum allowable part size for a multipart upload is 5 MB. For more information about multipart upload limits, go to <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/qfacts.html">Quick Facts</a> in the <i>Amazon Simple Storage Service Developer Guide</i>. </p> <note> <p>Instead of using an existing object as part data, you might use the <a>UploadPart</a> operation and provide data in your request.</p> </note> <p>You must initiate a multipart upload before you can upload any part. In response to your initiate request. Amazon S3 returns a unique identifier, the upload ID, that you must include in your upload part request.</p> <p>For more information about using the <code>UploadPartCopy</code> operation, see the following:</p> <ul> <li> <p>For conceptual information about multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html">Uploading Objects Using Multipart Upload</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> </li> <li> <p>For information about permissions required to use the multipart upload API, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html">Multipart Upload API and Permissions</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> </li> <li> <p>For information about copying objects using a single atomic operation vs. the multipart upload, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectOperations.html">Operations on Objects</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> </li> <li> <p>For information about using server-side encryption with customer-provided encryption keys with the UploadPartCopy operation, see <a>CopyObject</a> and <a>UploadPart</a>.</p> </li> </ul> <p>Note the following additional considerations about the request headers <code>x-amz-copy-source-if-match</code>, <code>x-amz-copy-source-if-none-match</code>, <code>x-amz-copy-source-if-unmodified-since</code>, and <code>x-amz-copy-source-if-modified-since</code>:</p> <p> </p> <ul> <li> <p> <b>Consideration 1</b> - If both of the <code>x-amz-copy-source-if-match</code> and <code>x-amz-copy-source-if-unmodified-since</code> headers are present in the request as follows:</p> <p> <code>x-amz-copy-source-if-match</code> condition evaluates to <code>true</code>, and;</p> <p> <code>x-amz-copy-source-if-unmodified-since</code> condition evaluates to <code>false</code>;</p> <p>Amazon S3 returns <code>200 OK</code> and copies the data. </p> </li> <li> <p> <b>Consideration 2</b> - If both of the <code>x-amz-copy-source-if-none-match</code> and <code>x-amz-copy-source-if-modified-since</code> headers are present in the request as follows:</p> <p> <code>x-amz-copy-source-if-none-match</code> condition evaluates to <code>false</code>, and;</p> <p> <code>x-amz-copy-source-if-modified-since</code> condition evaluates to <code>true</code>;</p> <p>Amazon S3 returns <code>412 Precondition Failed</code> response code. </p> </li> </ul> <p> <b>Versioning</b> </p> <p>If your bucket has versioning enabled, you could have multiple versions of the same object. By default, <code>x-amz-copy-source</code> identifies the current version of the object to copy. If the current version is a delete marker and you don\'t specify a versionId in the <code>x-amz-copy-source</code>, Amazon S3 returns a 404 error, because the object does not exist. If you specify versionId in the <code>x-amz-copy-source</code> and the versionId is a delete marker, Amazon S3 returns an HTTP 400 error, because you are not allowed to specify a delete marker as a version for the <code>x-amz-copy-source</code>. </p> <p>You can optionally specify a specific version of the source object to copy by adding the <code>versionId</code> subresource as shown in the following example:</p> <p> <code>x-amz-copy-source: /bucket/object?versionId=version id</code> </p> <p class="title"> <b>Special Errors</b> </p> <ul> <li> <p class="title"> <b/> </p> <ul> <li> <p> <i>Code: NoSuchUpload</i> </p> </li> <li> <p> <i>Cause: The specified multipart upload does not exist. The upload ID might be invalid, or the multipart upload might have been aborted or completed.</i> </p> </li> <li> <p> <i>HTTP Status Code: 404 Not Found</i> </p> </li> </ul> </li> <li> <p class="title"> <b/> </p> <ul> <li> <p> <i>Code: InvalidRequest</i> </p> </li> <li> <p> <i>Cause: The specified copy source is not supported as a byte-range copy source.</i> </p> </li> <li> <p> <i>HTTP Status Code: 400 Bad Request</i> </p> </li> </ul> </li> </ul> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> <a>CreateMultipartUpload</a> </p> </li> <li> <p> <a>UploadPart</a> </p> </li> <li> <p> <a>CompleteMultipartUpload</a> </p> </li> <li> <p> <a>AbortMultipartUpload</a> </p> </li> <li> <p> <a>ListParts</a> </p> </li> <li> <p> <a>ListMultipartUploads</a> </p> </li> </ul>', ], 'shapes' => [ 'AbortDate' => [ 'base' => NULL, 'refs' => [ 'CreateMultipartUploadOutput$AbortDate' => '<p>If the bucket has a lifecycle rule configured with an action to abort incomplete multipart uploads and the prefix in the lifecycle rule matches the object name in the request, the response includes this header. The header indicates when the initiated multipart upload becomes eligible for an abort operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config"> Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a>.</p> <p>The response also includes the <code>x-amz-abort-rule-id</code> header that provides the ID of the lifecycle configuration rule that defines this action.</p>', 'ListPartsOutput$AbortDate' => '<p>If the bucket has a lifecycle rule configured with an action to abort incomplete multipart uploads and the prefix in the lifecycle rule matches the object name in the request, then the response includes this header indicating when the initiated multipart upload will become eligible for abort operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config">Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a>.</p> <p>The response will also include the <code>x-amz-abort-rule-id</code> header that will provide the ID of the lifecycle configuration rule that defines this action.</p>', ], ], 'AbortIncompleteMultipartUpload' => [ 'base' => '<p>Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config"> Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'refs' => [ 'LifecycleRule$AbortIncompleteMultipartUpload' => NULL, 'Rule$AbortIncompleteMultipartUpload' => NULL, ], ], 'AbortMultipartUploadOutput' => [ 'base' => NULL, 'refs' => [], ], 'AbortMultipartUploadRequest' => [ 'base' => NULL, 'refs' => [], ], 'AbortRuleId' => [ 'base' => NULL, 'refs' => [ 'CreateMultipartUploadOutput$AbortRuleId' => '<p>This header is returned along with the <code>x-amz-abort-date</code> header. It identifies the applicable lifecycle configuration rule that defines the action to abort incomplete multipart uploads.</p>', 'ListPartsOutput$AbortRuleId' => '<p>This header is returned along with the <code>x-amz-abort-date</code> header. It identifies applicable lifecycle configuration rule that defines the action to abort incomplete multipart uploads.</p>', ], ], 'AccelerateConfiguration' => [ 'base' => '<p>Configures the transfer acceleration state for an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Amazon S3 Transfer Acceleration</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'refs' => [ 'PutBucketAccelerateConfigurationRequest$AccelerateConfiguration' => '<p>Container for setting the transfer acceleration state.</p>', ], ], 'AcceptRanges' => [ 'base' => NULL, 'refs' => [ 'GetObjectOutput$AcceptRanges' => '<p>Indicates that a range of bytes was specified.</p>', 'HeadObjectOutput$AcceptRanges' => '<p>Indicates that a range of bytes was specified.</p>', ], ], 'AccessControlPolicy' => [ 'base' => '<p>Contains the elements that set the ACL permissions for an object per grantee.</p>', 'refs' => [ 'PutBucketAclRequest$AccessControlPolicy' => '<p>Contains the elements that set the ACL permissions for an object per grantee.</p>', 'PutObjectAclRequest$AccessControlPolicy' => '<p>Contains the elements that set the ACL permissions for an object per grantee.</p>', ], ], 'AccessControlTranslation' => [ 'base' => '<p>A container for information about access control for replicas.</p>', 'refs' => [ 'Destination$AccessControlTranslation' => '<p>Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the AWS account that owns the destination bucket. If this is not specified in the replication configuration, the replicas are owned by same AWS account that owns the source object.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'AnalyticsS3BucketDestination$BucketAccountId' => '<p>The account ID that owns the destination S3 bucket. If no account ID is provided, the owner is not validated before exporting data.</p> <note> <p> Although this value is optional, we strongly recommend that you set it to help prevent problems if the destination bucket ownership changes. </p> </note>', 'Destination$Account' => '<p>Destination bucket owner account ID. In a cross-account scenario, if you direct Amazon S3 to change replica ownership to the AWS account that owns the destination bucket by specifying the <code>AccessControlTranslation</code> property, this is the account ID of the destination bucket owner. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-change-owner.html">Replication Additional Configuration: Changing the Replica Owner</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'InventoryS3BucketDestination$AccountId' => '<p>The account ID that owns the destination S3 bucket. If no account ID is provided, the owner is not validated before exporting data. </p> <note> <p> Although this value is optional, we strongly recommend that you set it to help prevent problems if the destination bucket ownership changes. </p> </note>', ], ], 'AllowQuotedRecordDelimiter' => [ 'base' => NULL, 'refs' => [ 'CSVInput$AllowQuotedRecordDelimiter' => '<p>Specifies that CSV field values may contain quoted record delimiters and such records should be allowed. Default value is FALSE. Setting this value to TRUE may lower performance.</p>', ], ], 'AllowedHeader' => [ 'base' => NULL, 'refs' => [ 'AllowedHeaders$member' => NULL, ], ], 'AllowedHeaders' => [ 'base' => NULL, 'refs' => [ 'CORSRule$AllowedHeaders' => '<p>Headers that are specified in the <code>Access-Control-Request-Headers</code> header. These headers are allowed in a preflight OPTIONS request. In response to any preflight OPTIONS request, Amazon S3 returns any requested headers that are allowed.</p>', ], ], 'AllowedMethod' => [ 'base' => NULL, 'refs' => [ 'AllowedMethods$member' => NULL, ], ], 'AllowedMethods' => [ 'base' => NULL, 'refs' => [ 'CORSRule$AllowedMethods' => '<p>An HTTP method that you allow the origin to execute. Valid values are <code>GET</code>, <code>PUT</code>, <code>HEAD</code>, <code>POST</code>, and <code>DELETE</code>.</p>', ], ], 'AllowedOrigin' => [ 'base' => NULL, 'refs' => [ 'AllowedOrigins$member' => NULL, ], ], 'AllowedOrigins' => [ 'base' => NULL, 'refs' => [ 'CORSRule$AllowedOrigins' => '<p>One or more origins you want customers to be able to access the bucket from.</p>', ], ], 'AnalyticsAndOperator' => [ 'base' => '<p>A conjunction (logical AND) of predicates, which is used in evaluating a metrics filter. The operator must have at least two predicates in any combination, and an object must match all of the predicates for the filter to apply.</p>', 'refs' => [ 'AnalyticsFilter$And' => '<p>A conjunction (logical AND) of predicates, which is used in evaluating an analytics filter. The operator must have at least two predicates.</p>', ], ], 'AnalyticsConfiguration' => [ 'base' => '<p> Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket.</p>', 'refs' => [ 'AnalyticsConfigurationList$member' => NULL, 'GetBucketAnalyticsConfigurationOutput$AnalyticsConfiguration' => '<p>The configuration and any analyses for the analytics filter.</p>', 'PutBucketAnalyticsConfigurationRequest$AnalyticsConfiguration' => '<p>The configuration and any analyses for the analytics filter.</p>', ], ], 'AnalyticsConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ListBucketAnalyticsConfigurationsOutput$AnalyticsConfigurationList' => '<p>The list of analytics configurations for a bucket.</p>', ], ], 'AnalyticsExportDestination' => [ 'base' => '<p>Where to publish the analytics results.</p>', 'refs' => [ 'StorageClassAnalysisDataExport$Destination' => '<p>The place to store the data for an analysis.</p>', ], ], 'AnalyticsFilter' => [ 'base' => '<p>The filter used to describe a set of objects for analyses. A filter must have exactly one prefix, one tag, or one conjunction (AnalyticsAndOperator). If no filter is provided, all objects will be considered in any analysis.</p>', 'refs' => [ 'AnalyticsConfiguration$Filter' => '<p>The filter used to describe a set of objects for analyses. A filter must have exactly one prefix, one tag, or one conjunction (AnalyticsAndOperator). If no filter is provided, all objects will be considered in any analysis.</p>', ], ], 'AnalyticsId' => [ 'base' => NULL, 'refs' => [ 'AnalyticsConfiguration$Id' => '<p>The ID that identifies the analytics configuration.</p>', 'DeleteBucketAnalyticsConfigurationRequest$Id' => '<p>The ID that identifies the analytics configuration.</p>', 'GetBucketAnalyticsConfigurationRequest$Id' => '<p>The ID that identifies the analytics configuration.</p>', 'PutBucketAnalyticsConfigurationRequest$Id' => '<p>The ID that identifies the analytics configuration.</p>', ], ], 'AnalyticsS3BucketDestination' => [ 'base' => '<p>Contains information about where to publish the analytics results.</p>', 'refs' => [ 'AnalyticsExportDestination$S3BucketDestination' => '<p>A destination signifying output to an S3 bucket.</p>', ], ], 'AnalyticsS3ExportFileFormat' => [ 'base' => NULL, 'refs' => [ 'AnalyticsS3BucketDestination$Format' => '<p>Specifies the file format used when exporting data to Amazon S3.</p>', ], ], 'Body' => [ 'base' => NULL, 'refs' => [ 'GetObjectOutput$Body' => '<p>Object data.</p>', 'GetObjectTorrentOutput$Body' => '<p>A Bencoded dictionary as defined by the BitTorrent specification</p>', 'PutObjectRequest$Body' => '<p>Object data.</p>', 'RecordsEvent$Payload' => '<p>The byte array of partial, one or more result records.</p>', 'UploadPartRequest$Body' => '<p>Object data.</p>', ], ], 'Bucket' => [ 'base' => '<p> In terms of implementation, a Bucket is a resource. An Amazon S3 bucket name is globally unique, and the namespace is shared by all AWS accounts. </p>', 'refs' => [ 'Buckets$member' => NULL, ], ], 'BucketAccelerateStatus' => [ 'base' => NULL, 'refs' => [ 'AccelerateConfiguration$Status' => '<p>Specifies the transfer acceleration status of the bucket.</p>', 'GetBucketAccelerateConfigurationOutput$Status' => '<p>The accelerate configuration of the bucket.</p>', ], ], 'BucketAlreadyExists' => [ 'base' => '<p>The requested bucket name is not available. The bucket namespace is shared by all users of the system. Please select a different name and try again.</p>', 'refs' => [], ], 'BucketAlreadyOwnedByYou' => [ 'base' => '<p>The bucket you tried to create already exists, and you own it. Amazon S3 returns this error in all AWS Regions except in the North Virginia Region. For legacy compatibility, if you re-create an existing bucket that you already own in the North Virginia Region, Amazon S3 returns 200 OK and resets the bucket access control lists (ACLs).</p>', 'refs' => [], ], 'BucketCannedACL' => [ 'base' => NULL, 'refs' => [ 'CreateBucketRequest$ACL' => '<p>The canned ACL to apply to the bucket.</p>', 'PutBucketAclRequest$ACL' => '<p>The canned ACL to apply to the bucket.</p>', ], ], 'BucketLifecycleConfiguration' => [ 'base' => '<p>Specifies the lifecycle configuration for objects in an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle Management</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'refs' => [ 'PutBucketLifecycleConfigurationRequest$LifecycleConfiguration' => '<p>Container for lifecycle rules. You can add as many as 1,000 rules.</p>', ], ], 'BucketLocationConstraint' => [ 'base' => NULL, 'refs' => [ 'CreateBucketConfiguration$LocationConstraint' => '<p>Specifies the Region where the bucket will be created. If you don\'t specify a Region, the bucket is created in the US East (N. Virginia) Region (us-east-1).</p>', 'GetBucketLocationOutput$LocationConstraint' => '<p>Specifies the Region where the bucket resides. For a list of all the Amazon S3 supported location constraints by Region, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a>. Buckets in Region <code>us-east-1</code> have a LocationConstraint of <code>null</code>.</p>', ], ], 'BucketLoggingStatus' => [ 'base' => '<p>Container for logging status information.</p>', 'refs' => [ 'PutBucketLoggingRequest$BucketLoggingStatus' => '<p>Container for logging status information.</p>', ], ], 'BucketLogsPermission' => [ 'base' => NULL, 'refs' => [ 'TargetGrant$Permission' => '<p>Logging permissions assigned to the Grantee for the bucket.</p>', ], ], 'BucketName' => [ 'base' => NULL, 'refs' => [ 'AbortMultipartUploadRequest$Bucket' => '<p>The bucket name to which the upload was taking place. </p> <p>When using this API with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'AnalyticsS3BucketDestination$Bucket' => '<p>The Amazon Resource Name (ARN) of the bucket to which data is exported.</p>', 'Bucket$Name' => '<p>The name of the bucket.</p>', 'CompleteMultipartUploadOutput$Bucket' => '<p>The name of the bucket that contains the newly created object.</p>', 'CompleteMultipartUploadRequest$Bucket' => '<p>Name of the bucket to which the multipart upload was initiated.</p>', 'CopyObjectRequest$Bucket' => '<p>The name of the destination bucket.</p>', 'CreateBucketRequest$Bucket' => '<p>The name of the bucket to create.</p>', 'CreateMultipartUploadOutput$Bucket' => '<p>Name of the bucket to which the multipart upload was initiated. </p> <p>When using this API with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'CreateMultipartUploadRequest$Bucket' => '<p>The name of the bucket to which to initiate the upload</p>', 'DeleteBucketAnalyticsConfigurationRequest$Bucket' => '<p>The name of the bucket from which an analytics configuration is deleted.</p>', 'DeleteBucketCorsRequest$Bucket' => '<p>Specifies the bucket whose <code>cors</code> configuration is being deleted.</p>', 'DeleteBucketEncryptionRequest$Bucket' => '<p>The name of the bucket containing the server-side encryption configuration to delete.</p>', 'DeleteBucketInventoryConfigurationRequest$Bucket' => '<p>The name of the bucket containing the inventory configuration to delete.</p>', 'DeleteBucketLifecycleRequest$Bucket' => '<p>The bucket name of the lifecycle to delete.</p>', 'DeleteBucketMetricsConfigurationRequest$Bucket' => '<p>The name of the bucket containing the metrics configuration to delete.</p>', 'DeleteBucketPolicyRequest$Bucket' => '<p>The bucket name.</p>', 'DeleteBucketReplicationRequest$Bucket' => '<p> The bucket name. </p>', 'DeleteBucketRequest$Bucket' => '<p>Specifies the bucket being deleted.</p>', 'DeleteBucketTaggingRequest$Bucket' => '<p>The bucket that has the tag set to be removed.</p>', 'DeleteBucketWebsiteRequest$Bucket' => '<p>The bucket name for which you want to remove the website configuration. </p>', 'DeleteObjectRequest$Bucket' => '<p>The bucket name of the bucket containing the object. </p> <p>When using this API with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'DeleteObjectTaggingRequest$Bucket' => '<p>The bucket name containing the objects from which to remove the tags. </p> <p>When using this API with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'DeleteObjectsRequest$Bucket' => '<p>The bucket name containing the objects to delete. </p> <p>When using this API with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'DeletePublicAccessBlockRequest$Bucket' => '<p>The Amazon S3 bucket whose <code>PublicAccessBlock</code> configuration you want to delete. </p>', 'Destination$Bucket' => '<p> The Amazon Resource Name (ARN) of the bucket where you want Amazon S3 to store the results.</p>', 'GetBucketAccelerateConfigurationRequest$Bucket' => '<p>Name of the bucket for which the accelerate configuration is retrieved.</p>', 'GetBucketAclRequest$Bucket' => '<p>Specifies the S3 bucket whose ACL is being requested.</p>', 'GetBucketAnalyticsConfigurationRequest$Bucket' => '<p>The name of the bucket from which an analytics configuration is retrieved.</p>', 'GetBucketCorsRequest$Bucket' => '<p>The bucket name for which to get the cors configuration.</p>', 'GetBucketEncryptionRequest$Bucket' => '<p>The name of the bucket from which the server-side encryption configuration is retrieved.</p>', 'GetBucketInventoryConfigurationRequest$Bucket' => '<p>The name of the bucket containing the inventory configuration to retrieve.</p>', 'GetBucketLifecycleConfigurationRequest$Bucket' => '<p>The name of the bucket for which to get the lifecycle information.</p>', 'GetBucketLifecycleRequest$Bucket' => '<p>The name of the bucket for which to get the lifecycle information.</p>', 'GetBucketLocationRequest$Bucket' => '<p>The name of the bucket for which to get the location.</p>', 'GetBucketLoggingRequest$Bucket' => '<p>The bucket name for which to get the logging information.</p>', 'GetBucketMetricsConfigurationRequest$Bucket' => '<p>The name of the bucket containing the metrics configuration to retrieve.</p>', 'GetBucketNotificationConfigurationRequest$Bucket' => '<p>Name of the bucket for which to get the notification configuration.</p>', 'GetBucketPolicyRequest$Bucket' => '<p>The bucket name for which to get the bucket policy.</p>', 'GetBucketPolicyStatusRequest$Bucket' => '<p>The name of the Amazon S3 bucket whose policy status you want to retrieve.</p>', 'GetBucketReplicationRequest$Bucket' => '<p>The bucket name for which to get the replication information.</p>', 'GetBucketRequestPaymentRequest$Bucket' => '<p>The name of the bucket for which to get the payment request configuration</p>', 'GetBucketTaggingRequest$Bucket' => '<p>The name of the bucket for which to get the tagging information.</p>', 'GetBucketVersioningRequest$Bucket' => '<p>The name of the bucket for which to get the versioning information.</p>', 'GetBucketWebsiteRequest$Bucket' => '<p>The bucket name for which to get the website configuration.</p>', 'GetObjectAclRequest$Bucket' => '<p>The bucket name that contains the object for which to get the ACL information. </p> <p>When using this API with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'GetObjectLegalHoldRequest$Bucket' => '<p>The bucket name containing the object whose Legal Hold status you want to retrieve. </p> <p>When using this API with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'GetObjectLockConfigurationRequest$Bucket' => '<p>The bucket whose Object Lock configuration you want to retrieve.</p>', 'GetObjectRequest$Bucket' => '<p>The bucket name containing the object. </p> <p>When using this API with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'GetObjectRetentionRequest$Bucket' => '<p>The bucket name containing the object whose retention settings you want to retrieve. </p> <p>When using this API with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'GetObjectTaggingRequest$Bucket' => '<p>The bucket name containing the object for which to get the tagging information. </p> <p>When using this API with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'GetObjectTorrentRequest$Bucket' => '<p>The name of the bucket containing the object for which to get the torrent files.</p>', 'GetPublicAccessBlockRequest$Bucket' => '<p>The name of the Amazon S3 bucket whose <code>PublicAccessBlock</code> configuration you want to retrieve. </p>', 'HeadBucketRequest$Bucket' => '<p>The bucket name.</p>', 'HeadObjectRequest$Bucket' => '<p>The name of the bucket containing the object.</p>', 'InventoryS3BucketDestination$Bucket' => '<p>The Amazon Resource Name (ARN) of the bucket where inventory results will be published.</p>', 'ListBucketAnalyticsConfigurationsRequest$Bucket' => '<p>The name of the bucket from which analytics configurations are retrieved.</p>', 'ListBucketInventoryConfigurationsRequest$Bucket' => '<p>The name of the bucket containing the inventory configurations to retrieve.</p>', 'ListBucketMetricsConfigurationsRequest$Bucket' => '<p>The name of the bucket containing the metrics configurations to retrieve.</p>', 'ListMultipartUploadsOutput$Bucket' => '<p>Name of the bucket to which the multipart upload was initiated.</p>', 'ListMultipartUploadsRequest$Bucket' => '<p>Name of the bucket to which the multipart upload was initiated. </p> <p>When using this API with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'ListObjectVersionsOutput$Name' => '<p>Bucket name.</p>', 'ListObjectVersionsRequest$Bucket' => '<p>The bucket name that contains the objects. </p> <p>When using this API with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'ListObjectsOutput$Name' => '<p>Bucket name.</p>', 'ListObjectsRequest$Bucket' => '<p>The name of the bucket containing the objects.</p>', 'ListObjectsV2Output$Name' => '<p>Bucket name. </p> <p>When using this API with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'ListObjectsV2Request$Bucket' => '<p>Bucket name to list. </p> <p>When using this API with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'ListPartsOutput$Bucket' => '<p>Name of the bucket to which the multipart upload was initiated.</p>', 'ListPartsRequest$Bucket' => '<p>Name of the bucket to which the parts are being uploaded. </p> <p>When using this API with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'PutBucketAccelerateConfigurationRequest$Bucket' => '<p>Name of the bucket for which the accelerate configuration is set.</p>', 'PutBucketAclRequest$Bucket' => '<p>The bucket to which to apply the ACL.</p>', 'PutBucketAnalyticsConfigurationRequest$Bucket' => '<p>The name of the bucket to which an analytics configuration is stored.</p>', 'PutBucketCorsRequest$Bucket' => '<p>Specifies the bucket impacted by the <code>cors</code>configuration.</p>', 'PutBucketEncryptionRequest$Bucket' => '<p>Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3) or customer master keys stored in AWS KMS (SSE-KMS). For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Bucket Encryption</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'PutBucketInventoryConfigurationRequest$Bucket' => '<p>The name of the bucket where the inventory configuration will be stored.</p>', 'PutBucketLifecycleConfigurationRequest$Bucket' => '<p>The name of the bucket for which to set the configuration.</p>', 'PutBucketLifecycleRequest$Bucket' => '<p/>', 'PutBucketLoggingRequest$Bucket' => '<p>The name of the bucket for which to set the logging parameters.</p>', 'PutBucketMetricsConfigurationRequest$Bucket' => '<p>The name of the bucket for which the metrics configuration is set.</p>', 'PutBucketNotificationConfigurationRequest$Bucket' => '<p>The name of the bucket.</p>', 'PutBucketNotificationRequest$Bucket' => '<p>The name of the bucket.</p>', 'PutBucketPolicyRequest$Bucket' => '<p>The name of the bucket.</p>', 'PutBucketReplicationRequest$Bucket' => '<p>The name of the bucket</p>', 'PutBucketRequestPaymentRequest$Bucket' => '<p>The bucket name.</p>', 'PutBucketTaggingRequest$Bucket' => '<p>The bucket name.</p>', 'PutBucketVersioningRequest$Bucket' => '<p>The bucket name.</p>', 'PutBucketWebsiteRequest$Bucket' => '<p>The bucket name.</p>', 'PutObjectAclRequest$Bucket' => '<p>The bucket name that contains the object to which you want to attach the ACL. </p> <p>When using this API with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'PutObjectLegalHoldRequest$Bucket' => '<p>The bucket name containing the object that you want to place a Legal Hold on. </p> <p>When using this API with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'PutObjectLockConfigurationRequest$Bucket' => '<p>The bucket whose Object Lock configuration you want to create or replace.</p>', 'PutObjectRequest$Bucket' => '<p>Bucket name to which the PUT operation was initiated. </p> <p>When using this API with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'PutObjectRetentionRequest$Bucket' => '<p>The bucket name that contains the object you want to apply this Object Retention configuration to. </p> <p>When using this API with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'PutObjectTaggingRequest$Bucket' => '<p>The bucket name containing the object. </p> <p>When using this API with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'PutPublicAccessBlockRequest$Bucket' => '<p>The name of the Amazon S3 bucket whose <code>PublicAccessBlock</code> configuration you want to set.</p>', 'RestoreObjectRequest$Bucket' => '<p>The bucket name or containing the object to restore. </p> <p>When using this API with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'S3Location$BucketName' => '<p>The name of the bucket where the restore results will be placed.</p>', 'SelectObjectContentRequest$Bucket' => '<p>The S3 bucket.</p>', 'UploadPartCopyRequest$Bucket' => '<p>The bucket name.</p>', 'UploadPartRequest$Bucket' => '<p>Name of the bucket to which the multipart upload was initiated.</p>', ], ], 'BucketVersioningStatus' => [ 'base' => NULL, 'refs' => [ 'GetBucketVersioningOutput$Status' => '<p>The versioning state of the bucket.</p>', 'VersioningConfiguration$Status' => '<p>The versioning state of the bucket.</p>', ], ], 'Buckets' => [ 'base' => NULL, 'refs' => [ 'ListBucketsOutput$Buckets' => '<p>The list of buckets owned by the requestor.</p>', ], ], 'BypassGovernanceRetention' => [ 'base' => NULL, 'refs' => [ 'DeleteObjectRequest$BypassGovernanceRetention' => '<p>Indicates whether S3 Object Lock should bypass Governance-mode restrictions to process this operation.</p>', 'DeleteObjectsRequest$BypassGovernanceRetention' => '<p>Specifies whether you want to delete this object even if it has a Governance-type Object Lock in place. You must have sufficient permissions to perform this operation.</p>', 'PutObjectRetentionRequest$BypassGovernanceRetention' => '<p>Indicates whether this operation should bypass Governance-mode restrictions.</p>', ], ], 'BytesProcessed' => [ 'base' => NULL, 'refs' => [ 'Progress$BytesProcessed' => '<p>The current number of uncompressed object bytes processed.</p>', 'Stats$BytesProcessed' => '<p>The total number of uncompressed object bytes processed.</p>', ], ], 'BytesReturned' => [ 'base' => NULL, 'refs' => [ 'Progress$BytesReturned' => '<p>The current number of bytes of records payload data returned.</p>', 'Stats$BytesReturned' => '<p>The total number of bytes of records payload data returned.</p>', ], ], 'BytesScanned' => [ 'base' => NULL, 'refs' => [ 'Progress$BytesScanned' => '<p>The current number of object bytes scanned.</p>', 'Stats$BytesScanned' => '<p>The total number of object bytes scanned.</p>', ], ], 'CORSConfiguration' => [ 'base' => '<p>Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'refs' => [ 'PutBucketCorsRequest$CORSConfiguration' => '<p>Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', ], ], 'CORSRule' => [ 'base' => '<p>Specifies a cross-origin access rule for an Amazon S3 bucket.</p>', 'refs' => [ 'CORSRules$member' => NULL, ], ], 'CORSRules' => [ 'base' => NULL, 'refs' => [ 'CORSConfiguration$CORSRules' => '<p>A set of origins and methods (cross-origin access that you want to allow). You can add up to 100 rules to the configuration.</p>', 'GetBucketCorsOutput$CORSRules' => '<p>A set of origins and methods (cross-origin access that you want to allow). You can add up to 100 rules to the configuration.</p>', ], ], 'CSVInput' => [ 'base' => '<p>Describes how an uncompressed comma-separated values (CSV)-formatted input object is formatted.</p>', 'refs' => [ 'InputSerialization$CSV' => '<p>Describes the serialization of a CSV-encoded object.</p>', ], ], 'CSVOutput' => [ 'base' => '<p>Describes how uncompressed comma-separated values (CSV)-formatted results are formatted.</p>', 'refs' => [ 'OutputSerialization$CSV' => '<p>Describes the serialization of CSV-encoded Select results.</p>', ], ], 'CacheControl' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$CacheControl' => '<p>Specifies caching behavior along the request/reply chain.</p>', 'CreateMultipartUploadRequest$CacheControl' => '<p>Specifies caching behavior along the request/reply chain.</p>', 'GetObjectOutput$CacheControl' => '<p>Specifies caching behavior along the request/reply chain.</p>', 'HeadObjectOutput$CacheControl' => '<p>Specifies caching behavior along the request/reply chain.</p>', 'PutObjectRequest$CacheControl' => '<p> Can be used to specify caching behavior along the request/reply chain. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.</p>', ], ], 'CloudFunction' => [ 'base' => NULL, 'refs' => [ 'CloudFunctionConfiguration$CloudFunction' => '<p>Lambda cloud function ARN that Amazon S3 can invoke when it detects events of the specified type.</p>', ], ], 'CloudFunctionConfiguration' => [ 'base' => '<p>Container for specifying the AWS Lambda notification configuration.</p>', 'refs' => [ 'NotificationConfigurationDeprecated$CloudFunctionConfiguration' => '<p>Container for specifying the AWS Lambda notification configuration.</p>', ], ], 'CloudFunctionInvocationRole' => [ 'base' => NULL, 'refs' => [ 'CloudFunctionConfiguration$InvocationRole' => '<p>The role supporting the invocation of the Lambda function</p>', ], ], 'Code' => [ 'base' => NULL, 'refs' => [ 'Error$Code' => '<p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p> <p class="title"> <b>Amazon S3 error codes</b> </p> <ul> <li> <ul> <li> <p> <i>Code:</i> AccessDenied </p> </li> <li> <p> <i>Description:</i> Access Denied</p> </li> <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> AccountProblem</p> </li> <li> <p> <i>Description:</i> There is a problem with your AWS account that prevents the operation from completing successfully. Contact AWS Support for further assistance.</p> </li> <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> AllAccessDisabled</p> </li> <li> <p> <i>Description:</i> All access to this Amazon S3 resource has been disabled. Contact AWS Support for further assistance.</p> </li> <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> AmbiguousGrantByEmailAddress</p> </li> <li> <p> <i>Description:</i> The email address you provided is associated with more than one account.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> AuthorizationHeaderMalformed</p> </li> <li> <p> <i>Description:</i> The authorization header you provided is invalid.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>HTTP Status Code:</i> N/A</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> BadDigest</p> </li> <li> <p> <i>Description:</i> The Content-MD5 you specified did not match what we received.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> BucketAlreadyExists</p> </li> <li> <p> <i>Description:</i> The requested bucket name is not available. The bucket namespace is shared by all users of the system. Please select a different name and try again.</p> </li> <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> BucketAlreadyOwnedByYou</p> </li> <li> <p> <i>Description:</i> The bucket you tried to create already exists, and you own it. Amazon S3 returns this error in all AWS Regions except in the North Virginia Region. For legacy compatibility, if you re-create an existing bucket that you already own in the North Virginia Region, Amazon S3 returns 200 OK and resets the bucket access control lists (ACLs).</p> </li> <li> <p> <i>Code:</i> 409 Conflict (in all Regions except the North Virginia Region) </p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> BucketNotEmpty</p> </li> <li> <p> <i>Description:</i> The bucket you tried to delete is not empty.</p> </li> <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> CredentialsNotSupported</p> </li> <li> <p> <i>Description:</i> This request does not support credentials.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> CrossLocationLoggingProhibited</p> </li> <li> <p> <i>Description:</i> Cross-location logging not allowed. Buckets in one geographic location cannot log information to a bucket in another location.</p> </li> <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> EntityTooSmall</p> </li> <li> <p> <i>Description:</i> Your proposed upload is smaller than the minimum allowed object size.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> EntityTooLarge</p> </li> <li> <p> <i>Description:</i> Your proposed upload exceeds the maximum allowed object size.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> ExpiredToken</p> </li> <li> <p> <i>Description:</i> The provided token has expired.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> IllegalVersioningConfigurationException </p> </li> <li> <p> <i>Description:</i> Indicates that the versioning configuration specified in the request is invalid.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> IncompleteBody</p> </li> <li> <p> <i>Description:</i> You did not provide the number of bytes specified by the Content-Length HTTP header</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> IncorrectNumberOfFilesInPostRequest</p> </li> <li> <p> <i>Description:</i> POST requires exactly one file upload per request.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InlineDataTooLarge</p> </li> <li> <p> <i>Description:</i> Inline data exceeds the maximum allowed size.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InternalError</p> </li> <li> <p> <i>Description:</i> We encountered an internal error. Please try again.</p> </li> <li> <p> <i>HTTP Status Code:</i> 500 Internal Server Error</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Server</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidAccessKeyId</p> </li> <li> <p> <i>Description:</i> The AWS access key ID you provided does not exist in our records.</p> </li> <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidAddressingHeader</p> </li> <li> <p> <i>Description:</i> You must specify the Anonymous role.</p> </li> <li> <p> <i>HTTP Status Code:</i> N/A</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidArgument</p> </li> <li> <p> <i>Description:</i> Invalid Argument</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidBucketName</p> </li> <li> <p> <i>Description:</i> The specified bucket is not valid.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidBucketState</p> </li> <li> <p> <i>Description:</i> The request is not valid with the current state of the bucket.</p> </li> <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidDigest</p> </li> <li> <p> <i>Description:</i> The Content-MD5 you specified is not valid.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidEncryptionAlgorithmError</p> </li> <li> <p> <i>Description:</i> The encryption request you specified is not valid. The valid value is AES256.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidLocationConstraint</p> </li> <li> <p> <i>Description:</i> The specified location constraint is not valid. For more information about Regions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingBucket.html#access-bucket-intro">How to Select a Region for Your Buckets</a>. </p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidObjectState</p> </li> <li> <p> <i>Description:</i> The operation is not valid for the current state of the object.</p> </li> <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidPart</p> </li> <li> <p> <i>Description:</i> One or more of the specified parts could not be found. The part might not have been uploaded, or the specified entity tag might not have matched the part\'s entity tag.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidPartOrder</p> </li> <li> <p> <i>Description:</i> The list of parts was not in ascending order. Parts list must be specified in order by part number.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidPayer</p> </li> <li> <p> <i>Description:</i> All access to this object has been disabled. Please contact AWS Support for further assistance.</p> </li> <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidPolicyDocument</p> </li> <li> <p> <i>Description:</i> The content of the form does not meet the conditions specified in the policy document.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidRange</p> </li> <li> <p> <i>Description:</i> The requested range cannot be satisfied.</p> </li> <li> <p> <i>HTTP Status Code:</i> 416 Requested Range Not Satisfiable</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidRequest</p> </li> <li> <p> <i>Description:</i> Please use AWS4-HMAC-SHA256.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>Code:</i> N/A</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidRequest</p> </li> <li> <p> <i>Description:</i> SOAP requests must be made over an HTTPS connection.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidRequest</p> </li> <li> <p> <i>Description:</i> Amazon S3 Transfer Acceleration is not supported for buckets with non-DNS compliant names.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>Code:</i> N/A</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidRequest</p> </li> <li> <p> <i>Description:</i> Amazon S3 Transfer Acceleration is not supported for buckets with periods (.) in their names.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>Code:</i> N/A</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidRequest</p> </li> <li> <p> <i>Description:</i> Amazon S3 Transfer Accelerate endpoint only supports virtual style requests.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>Code:</i> N/A</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidRequest</p> </li> <li> <p> <i>Description:</i> Amazon S3 Transfer Accelerate is not configured on this bucket.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>Code:</i> N/A</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidRequest</p> </li> <li> <p> <i>Description:</i> Amazon S3 Transfer Accelerate is disabled on this bucket.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>Code:</i> N/A</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidRequest</p> </li> <li> <p> <i>Description:</i> Amazon S3 Transfer Acceleration is not supported on this bucket. Contact AWS Support for more information.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>Code:</i> N/A</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidRequest</p> </li> <li> <p> <i>Description:</i> Amazon S3 Transfer Acceleration cannot be enabled on this bucket. Contact AWS Support for more information.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>Code:</i> N/A</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidSecurity</p> </li> <li> <p> <i>Description:</i> The provided security credentials are not valid.</p> </li> <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidSOAPRequest</p> </li> <li> <p> <i>Description:</i> The SOAP request body is invalid.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidStorageClass</p> </li> <li> <p> <i>Description:</i> The storage class you specified is not valid.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidTargetBucketForLogging</p> </li> <li> <p> <i>Description:</i> The target bucket for logging does not exist, is not owned by you, or does not have the appropriate grants for the log-delivery group. </p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidToken</p> </li> <li> <p> <i>Description:</i> The provided token is malformed or otherwise invalid.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> InvalidURI</p> </li> <li> <p> <i>Description:</i> Couldn\'t parse the specified URI.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> KeyTooLongError</p> </li> <li> <p> <i>Description:</i> Your key is too long.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> MalformedACLError</p> </li> <li> <p> <i>Description:</i> The XML you provided was not well-formed or did not validate against our published schema.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> MalformedPOSTRequest </p> </li> <li> <p> <i>Description:</i> The body of your POST request is not well-formed multipart/form-data.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> MalformedXML</p> </li> <li> <p> <i>Description:</i> This happens when the user sends malformed XML (XML that doesn\'t conform to the published XSD) for the configuration. The error message is, "The XML you provided was not well-formed or did not validate against our published schema." </p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> MaxMessageLengthExceeded</p> </li> <li> <p> <i>Description:</i> Your request was too big.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> MaxPostPreDataLengthExceededError</p> </li> <li> <p> <i>Description:</i> Your POST request fields preceding the upload file were too large.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> MetadataTooLarge</p> </li> <li> <p> <i>Description:</i> Your metadata headers exceed the maximum allowed metadata size.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> MethodNotAllowed</p> </li> <li> <p> <i>Description:</i> The specified method is not allowed against this resource.</p> </li> <li> <p> <i>HTTP Status Code:</i> 405 Method Not Allowed</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> MissingAttachment</p> </li> <li> <p> <i>Description:</i> A SOAP attachment was expected, but none were found.</p> </li> <li> <p> <i>HTTP Status Code:</i> N/A</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> MissingContentLength</p> </li> <li> <p> <i>Description:</i> You must provide the Content-Length HTTP header.</p> </li> <li> <p> <i>HTTP Status Code:</i> 411 Length Required</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> MissingRequestBodyError</p> </li> <li> <p> <i>Description:</i> This happens when the user sends an empty XML document as a request. The error message is, "Request body is empty." </p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> MissingSecurityElement</p> </li> <li> <p> <i>Description:</i> The SOAP 1.1 request is missing a security element.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> MissingSecurityHeader</p> </li> <li> <p> <i>Description:</i> Your request is missing a required header.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> NoLoggingStatusForKey</p> </li> <li> <p> <i>Description:</i> There is no such thing as a logging status subresource for a key.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> NoSuchBucket</p> </li> <li> <p> <i>Description:</i> The specified bucket does not exist.</p> </li> <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> NoSuchBucketPolicy</p> </li> <li> <p> <i>Description:</i> The specified bucket does not have a bucket policy.</p> </li> <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> NoSuchKey</p> </li> <li> <p> <i>Description:</i> The specified key does not exist.</p> </li> <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> NoSuchLifecycleConfiguration</p> </li> <li> <p> <i>Description:</i> The lifecycle configuration does not exist. </p> </li> <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> NoSuchUpload</p> </li> <li> <p> <i>Description:</i> The specified multipart upload does not exist. The upload ID might be invalid, or the multipart upload might have been aborted or completed.</p> </li> <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> NoSuchVersion </p> </li> <li> <p> <i>Description:</i> Indicates that the version ID specified in the request does not match an existing version.</p> </li> <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> NotImplemented</p> </li> <li> <p> <i>Description:</i> A header you provided implies functionality that is not implemented.</p> </li> <li> <p> <i>HTTP Status Code:</i> 501 Not Implemented</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Server</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> NotSignedUp</p> </li> <li> <p> <i>Description:</i> Your account is not signed up for the Amazon S3 service. You must sign up before you can use Amazon S3. You can sign up at the following URL: https://aws.amazon.com/s3</p> </li> <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> OperationAborted</p> </li> <li> <p> <i>Description:</i> A conflicting conditional operation is currently in progress against this resource. Try again.</p> </li> <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> PermanentRedirect</p> </li> <li> <p> <i>Description:</i> The bucket you are attempting to access must be addressed using the specified endpoint. Send all future requests to this endpoint.</p> </li> <li> <p> <i>HTTP Status Code:</i> 301 Moved Permanently</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> PreconditionFailed</p> </li> <li> <p> <i>Description:</i> At least one of the preconditions you specified did not hold.</p> </li> <li> <p> <i>HTTP Status Code:</i> 412 Precondition Failed</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> Redirect</p> </li> <li> <p> <i>Description:</i> Temporary redirect.</p> </li> <li> <p> <i>HTTP Status Code:</i> 307 Moved Temporarily</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> RestoreAlreadyInProgress</p> </li> <li> <p> <i>Description:</i> Object restore is already in progress.</p> </li> <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> RequestIsNotMultiPartContent</p> </li> <li> <p> <i>Description:</i> Bucket POST must be of the enclosure-type multipart/form-data.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> RequestTimeout</p> </li> <li> <p> <i>Description:</i> Your socket connection to the server was not read from or written to within the timeout period.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> RequestTimeTooSkewed</p> </li> <li> <p> <i>Description:</i> The difference between the request time and the server\'s time is too large.</p> </li> <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> RequestTorrentOfBucketError</p> </li> <li> <p> <i>Description:</i> Requesting the torrent file of a bucket is not permitted.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> SignatureDoesNotMatch</p> </li> <li> <p> <i>Description:</i> The request signature we calculated does not match the signature you provided. Check your AWS secret access key and signing method. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">REST Authentication</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/SOAPAuthentication.html">SOAP Authentication</a> for details.</p> </li> <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> ServiceUnavailable</p> </li> <li> <p> <i>Description:</i> Reduce your request rate.</p> </li> <li> <p> <i>HTTP Status Code:</i> 503 Service Unavailable</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Server</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> SlowDown</p> </li> <li> <p> <i>Description:</i> Reduce your request rate.</p> </li> <li> <p> <i>HTTP Status Code:</i> 503 Slow Down</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Server</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> TemporaryRedirect</p> </li> <li> <p> <i>Description:</i> You are being redirected to the bucket while DNS updates.</p> </li> <li> <p> <i>HTTP Status Code:</i> 307 Moved Temporarily</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> TokenRefreshRequired</p> </li> <li> <p> <i>Description:</i> The provided token must be refreshed.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> TooManyBuckets</p> </li> <li> <p> <i>Description:</i> You have attempted to create more buckets than allowed.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> UnexpectedContent</p> </li> <li> <p> <i>Description:</i> This request does not support content.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> UnresolvableGrantByEmailAddress</p> </li> <li> <p> <i>Description:</i> The email address you provided does not match any account on record.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> <li> <ul> <li> <p> <i>Code:</i> UserKeyMustBeSpecified</p> </li> <li> <p> <i>Description:</i> The bucket POST must contain the specified field name. If it is specified, check the order of the fields.</p> </li> <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li> <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li> </ul> </li> </ul> <p/>', ], ], 'Comments' => [ 'base' => NULL, 'refs' => [ 'CSVInput$Comments' => '<p>A single character used to indicate that a row should be ignored when the character is present at the start of that row. You can specify any character to indicate a comment line.</p>', ], ], 'CommonPrefix' => [ 'base' => '<p>Container for all (if there are any) keys between Prefix and the next occurrence of the string specified by a delimiter. CommonPrefixes lists keys that act like subdirectories in the directory specified by Prefix. For example, if the prefix is notes/ and the delimiter is a slash (/) as in notes/summer/july, the common prefix is notes/summer/. </p>', 'refs' => [ 'CommonPrefixList$member' => NULL, ], ], 'CommonPrefixList' => [ 'base' => NULL, 'refs' => [ 'ListMultipartUploadsOutput$CommonPrefixes' => '<p>If you specify a delimiter in the request, then the result returns each distinct key prefix containing the delimiter in a <code>CommonPrefixes</code> element. The distinct key prefixes are returned in the <code>Prefix</code> child element.</p>', 'ListObjectVersionsOutput$CommonPrefixes' => '<p>All of the keys rolled up into a common prefix count as a single return when calculating the number of returns.</p>', 'ListObjectsOutput$CommonPrefixes' => '<p>All of the keys rolled up in a common prefix count as a single return when calculating the number of returns. </p> <p>A response can contain CommonPrefixes only if you specify a delimiter.</p> <p>CommonPrefixes contains all (if there are any) keys between Prefix and the next occurrence of the string specified by the delimiter.</p> <p> CommonPrefixes lists keys that act like subdirectories in the directory specified by Prefix.</p> <p>For example, if the prefix is notes/ and the delimiter is a slash (/) as in notes/summer/july, the common prefix is notes/summer/. All of the keys that roll up into a common prefix count as a single return when calculating the number of returns.</p>', 'ListObjectsV2Output$CommonPrefixes' => '<p>All of the keys rolled up into a common prefix count as a single return when calculating the number of returns.</p> <p>A response can contain <code>CommonPrefixes</code> only if you specify a delimiter.</p> <p> <code>CommonPrefixes</code> contains all (if there are any) keys between <code>Prefix</code> and the next occurrence of the string specified by a delimiter.</p> <p> <code>CommonPrefixes</code> lists keys that act like subdirectories in the directory specified by <code>Prefix</code>.</p> <p>For example, if the prefix is <code>notes/</code> and the delimiter is a slash (<code>/</code>) as in <code>notes/summer/july</code>, the common prefix is <code>notes/summer/</code>. All of the keys that roll up into a common prefix count as a single return when calculating the number of returns. </p>', ], ], 'CompleteMultipartUploadOutput' => [ 'base' => NULL, 'refs' => [], ], 'CompleteMultipartUploadRequest' => [ 'base' => NULL, 'refs' => [], ], 'CompletedMultipartUpload' => [ 'base' => '<p>The container for the completed multipart upload details.</p>', 'refs' => [ 'CompleteMultipartUploadRequest$MultipartUpload' => '<p>The container for the multipart upload request information.</p>', ], ], 'CompletedPart' => [ 'base' => '<p>Details of the parts that were uploaded.</p>', 'refs' => [ 'CompletedPartList$member' => NULL, ], ], 'CompletedPartList' => [ 'base' => NULL, 'refs' => [ 'CompletedMultipartUpload$Parts' => '<p>Array of CompletedPart data types.</p>', ], ], 'CompressionType' => [ 'base' => NULL, 'refs' => [ 'InputSerialization$CompressionType' => '<p>Specifies object\'s compression format. Valid values: NONE, GZIP, BZIP2. Default Value: NONE.</p>', ], ], 'Condition' => [ 'base' => '<p>A container for describing a condition that must be met for the specified redirect to apply. For example, 1. If request is for pages in the <code>/docs</code> folder, redirect to the <code>/documents</code> folder. 2. If request results in HTTP error 4xx, redirect request to another host where you might process the error.</p>', 'refs' => [ 'RoutingRule$Condition' => '<p>A container for describing a condition that must be met for the specified redirect to apply. For example, 1. If request is for pages in the <code>/docs</code> folder, redirect to the <code>/documents</code> folder. 2. If request results in HTTP error 4xx, redirect request to another host where you might process the error.</p>', ], ], 'ConfirmRemoveSelfBucketAccess' => [ 'base' => NULL, 'refs' => [ 'PutBucketPolicyRequest$ConfirmRemoveSelfBucketAccess' => '<p>Set this parameter to true to confirm that you want to remove your permissions to change this bucket policy in the future.</p>', ], ], 'ContentDisposition' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$ContentDisposition' => '<p>Specifies presentational information for the object.</p>', 'CreateMultipartUploadRequest$ContentDisposition' => '<p>Specifies presentational information for the object.</p>', 'GetObjectOutput$ContentDisposition' => '<p>Specifies presentational information for the object.</p>', 'HeadObjectOutput$ContentDisposition' => '<p>Specifies presentational information for the object.</p>', 'PutObjectRequest$ContentDisposition' => '<p>Specifies presentational information for the object. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1">http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1</a>.</p>', ], ], 'ContentEncoding' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$ContentEncoding' => '<p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>', 'CreateMultipartUploadRequest$ContentEncoding' => '<p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>', 'GetObjectOutput$ContentEncoding' => '<p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>', 'HeadObjectOutput$ContentEncoding' => '<p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>', 'PutObjectRequest$ContentEncoding' => '<p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11</a>.</p>', ], ], 'ContentLanguage' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$ContentLanguage' => '<p>The language the content is in.</p>', 'CreateMultipartUploadRequest$ContentLanguage' => '<p>The language the content is in.</p>', 'GetObjectOutput$ContentLanguage' => '<p>The language the content is in.</p>', 'HeadObjectOutput$ContentLanguage' => '<p>The language the content is in.</p>', 'PutObjectRequest$ContentLanguage' => '<p>The language the content is in.</p>', ], ], 'ContentLength' => [ 'base' => NULL, 'refs' => [ 'GetObjectOutput$ContentLength' => '<p>Size of the body in bytes.</p>', 'HeadObjectOutput$ContentLength' => '<p>Size of the body in bytes.</p>', 'PutObjectRequest$ContentLength' => '<p>Size of the body in bytes. This parameter is useful when the size of the body cannot be determined automatically. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.13">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.13</a>.</p>', 'UploadPartRequest$ContentLength' => '<p>Size of the body in bytes. This parameter is useful when the size of the body cannot be determined automatically.</p>', ], ], 'ContentMD5' => [ 'base' => NULL, 'refs' => [ 'PutBucketAclRequest$ContentMD5' => '<p>The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a> </p>', 'PutBucketCorsRequest$ContentMD5' => '<p>The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a> </p>', 'PutBucketEncryptionRequest$ContentMD5' => '<p>The base64-encoded 128-bit MD5 digest of the server-side encryption configuration. This parameter is auto-populated when using the command from the CLI.</p>', 'PutBucketLifecycleRequest$ContentMD5' => '<p/>', 'PutBucketLoggingRequest$ContentMD5' => '<p>The MD5 hash of the <code>PutBucketLogging</code> request body.</p>', 'PutBucketNotificationRequest$ContentMD5' => '<p>The MD5 hash of the <code>PutPublicAccessBlock</code> request body.</p>', 'PutBucketPolicyRequest$ContentMD5' => '<p>The MD5 hash of the request body.</p>', 'PutBucketReplicationRequest$ContentMD5' => '<p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>', 'PutBucketRequestPaymentRequest$ContentMD5' => '<p>&gt;The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>', 'PutBucketTaggingRequest$ContentMD5' => '<p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>', 'PutBucketVersioningRequest$ContentMD5' => '<p>&gt;The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>', 'PutBucketWebsiteRequest$ContentMD5' => '<p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>', 'PutObjectAclRequest$ContentMD5' => '<p>The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.&gt;</a> </p>', 'PutObjectLegalHoldRequest$ContentMD5' => '<p>The MD5 hash for the request body.</p>', 'PutObjectLockConfigurationRequest$ContentMD5' => '<p>The MD5 hash for the request body.</p>', 'PutObjectRequest$ContentMD5' => '<p>The base64-encoded 128-bit MD5 digest of the message (without the headers) according to RFC 1864. This header can be used as a message integrity check to verify that the data is the same data that was originally sent. Although it is optional, we recommend using the Content-MD5 mechanism as an end-to-end integrity check. For more information about REST request authentication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">REST Authentication</a>.</p>', 'PutObjectRetentionRequest$ContentMD5' => '<p>The MD5 hash for the request body.</p>', 'PutObjectTaggingRequest$ContentMD5' => '<p>The MD5 hash for the request body.</p>', 'PutPublicAccessBlockRequest$ContentMD5' => '<p>The MD5 hash of the <code>PutPublicAccessBlock</code> request body. </p>', 'UploadPartRequest$ContentMD5' => '<p>The base64-encoded 128-bit MD5 digest of the part data. This parameter is auto-populated when using the command from the CLI. This parameter is required if object lock parameters are specified.</p>', ], ], 'ContentRange' => [ 'base' => NULL, 'refs' => [ 'GetObjectOutput$ContentRange' => '<p>The portion of the object returned in the response.</p>', ], ], 'ContentType' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$ContentType' => '<p>A standard MIME type describing the format of the object data.</p>', 'CreateMultipartUploadRequest$ContentType' => '<p>A standard MIME type describing the format of the object data.</p>', 'GetObjectOutput$ContentType' => '<p>A standard MIME type describing the format of the object data.</p>', 'HeadObjectOutput$ContentType' => '<p>A standard MIME type describing the format of the object data.</p>', 'PutObjectRequest$ContentType' => '<p>A standard MIME type describing the format of the contents. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17</a>.</p>', ], ], 'ContinuationEvent' => [ 'base' => '<p/>', 'refs' => [ 'SelectObjectContentEventStream$Cont' => '<p>The Continuation Event.</p>', ], ], 'CopyObjectOutput' => [ 'base' => NULL, 'refs' => [], ], 'CopyObjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'CopyObjectResult' => [ 'base' => '<p>Container for all response elements.</p>', 'refs' => [ 'CopyObjectOutput$CopyObjectResult' => '<p>Container for all response elements.</p>', ], ], 'CopyPartResult' => [ 'base' => '<p>Container for all response elements.</p>', 'refs' => [ 'UploadPartCopyOutput$CopyPartResult' => '<p>Container for all response elements.</p>', ], ], 'CopySource' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$CopySource' => '<p>The name of the source bucket and key name of the source object, separated by a slash (/). Must be URL-encoded.</p>', 'UploadPartCopyRequest$CopySource' => '<p>The name of the source bucket and key name of the source object, separated by a slash (/). Must be URL-encoded.</p>', ], ], 'CopySourceIfMatch' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$CopySourceIfMatch' => '<p>Copies the object if its entity tag (ETag) matches the specified tag.</p>', 'UploadPartCopyRequest$CopySourceIfMatch' => '<p>Copies the object if its entity tag (ETag) matches the specified tag.</p>', ], ], 'CopySourceIfModifiedSince' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$CopySourceIfModifiedSince' => '<p>Copies the object if it has been modified since the specified time.</p>', 'UploadPartCopyRequest$CopySourceIfModifiedSince' => '<p>Copies the object if it has been modified since the specified time.</p>', ], ], 'CopySourceIfNoneMatch' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$CopySourceIfNoneMatch' => '<p>Copies the object if its entity tag (ETag) is different than the specified ETag.</p>', 'UploadPartCopyRequest$CopySourceIfNoneMatch' => '<p>Copies the object if its entity tag (ETag) is different than the specified ETag.</p>', ], ], 'CopySourceIfUnmodifiedSince' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$CopySourceIfUnmodifiedSince' => '<p>Copies the object if it hasn\'t been modified since the specified time.</p>', 'UploadPartCopyRequest$CopySourceIfUnmodifiedSince' => '<p>Copies the object if it hasn\'t been modified since the specified time.</p>', ], ], 'CopySourceRange' => [ 'base' => NULL, 'refs' => [ 'UploadPartCopyRequest$CopySourceRange' => '<p>The range of bytes to copy from the source object. The range value must use the form bytes=first-last, where the first and last are the zero-based byte offsets to copy. For example, bytes=0-9 indicates that you want to copy the first 10 bytes of the source. You can copy a range only if the source object is greater than 5 MB.</p>', ], ], 'CopySourceSSECustomerAlgorithm' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$CopySourceSSECustomerAlgorithm' => '<p>Specifies the algorithm to use when decrypting the source object (for example, AES256).</p>', 'UploadPartCopyRequest$CopySourceSSECustomerAlgorithm' => '<p>Specifies the algorithm to use when decrypting the source object (for example, AES256).</p>', ], ], 'CopySourceSSECustomerKey' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$CopySourceSSECustomerKey' => '<p>Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created.</p>', 'UploadPartCopyRequest$CopySourceSSECustomerKey' => '<p>Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created.</p>', ], ], 'CopySourceSSECustomerKeyMD5' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$CopySourceSSECustomerKeyMD5' => '<p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>', 'UploadPartCopyRequest$CopySourceSSECustomerKeyMD5' => '<p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>', ], ], 'CopySourceVersionId' => [ 'base' => NULL, 'refs' => [ 'CopyObjectOutput$CopySourceVersionId' => '<p>Version of the copied object in the destination bucket.</p>', 'UploadPartCopyOutput$CopySourceVersionId' => '<p>The version of the source object that was copied, if you have enabled versioning on the source bucket.</p>', ], ], 'CreateBucketConfiguration' => [ 'base' => '<p>The configuration information for the bucket.</p>', 'refs' => [ 'CreateBucketRequest$CreateBucketConfiguration' => '<p>The configuration information for the bucket.</p>', ], ], 'CreateBucketOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateBucketRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMultipartUploadOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateMultipartUploadRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreationDate' => [ 'base' => NULL, 'refs' => [ 'Bucket$CreationDate' => '<p>Date the bucket was created.</p>', ], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'LifecycleExpiration$Date' => '<p>Indicates at what date the object is to be moved or deleted. Should be in GMT ISO 8601 Format.</p>', 'ObjectLockRetention$RetainUntilDate' => '<p>The date on which this Object Lock Retention will expire.</p>', 'Transition$Date' => '<p>Indicates when objects are transitioned to the specified storage class. The date value must be in ISO 8601 format. The time is always midnight UTC.</p>', ], ], 'Days' => [ 'base' => NULL, 'refs' => [ 'DefaultRetention$Days' => '<p>The number of days that you want to specify for the default retention period.</p>', 'LifecycleExpiration$Days' => '<p>Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.</p>', 'NoncurrentVersionExpiration$NoncurrentDays' => '<p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations">How Amazon S3 Calculates When an Object Became Noncurrent</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'NoncurrentVersionTransition$NoncurrentDays' => '<p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations">How Amazon S3 Calculates How Long an Object Has Been Noncurrent</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'RestoreRequest$Days' => '<p>Lifetime of the active copy in days. Do not use with restores that specify <code>OutputLocation</code>.</p>', 'Transition$Days' => '<p>Indicates the number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer.</p>', ], ], 'DaysAfterInitiation' => [ 'base' => NULL, 'refs' => [ 'AbortIncompleteMultipartUpload$DaysAfterInitiation' => '<p>Specifies the number of days after which Amazon S3 aborts an incomplete multipart upload.</p>', ], ], 'DefaultRetention' => [ 'base' => '<p>The container element for specifying the default Object Lock retention settings for new objects placed in the specified bucket.</p>', 'refs' => [ 'ObjectLockRule$DefaultRetention' => '<p>The default retention period that you want to apply to new objects placed in the specified bucket.</p>', ], ], 'Delete' => [ 'base' => '<p>Container for the objects to delete.</p>', 'refs' => [ 'DeleteObjectsRequest$Delete' => '<p>Container for the request.</p>', ], ], 'DeleteBucketAnalyticsConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBucketCorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBucketEncryptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBucketInventoryConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBucketLifecycleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBucketMetricsConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBucketPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBucketReplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBucketRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBucketTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBucketWebsiteRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMarker' => [ 'base' => NULL, 'refs' => [ 'DeleteObjectOutput$DeleteMarker' => '<p>Specifies whether the versioned object that was permanently deleted was (true) or was not (false) a delete marker.</p>', 'DeletedObject$DeleteMarker' => '<p>Specifies whether the versioned object that was permanently deleted was (true) or was not (false) a delete marker. In a simple DELETE, this header indicates whether (true) or not (false) a delete marker was created.</p>', 'GetObjectOutput$DeleteMarker' => '<p>Specifies whether the object retrieved was (true) or was not (false) a Delete Marker. If false, this response header does not appear in the response.</p>', 'HeadObjectOutput$DeleteMarker' => '<p>Specifies whether the object retrieved was (true) or was not (false) a Delete Marker. If false, this response header does not appear in the response.</p>', ], ], 'DeleteMarkerEntry' => [ 'base' => '<p>Information about the delete marker.</p>', 'refs' => [ 'DeleteMarkers$member' => NULL, ], ], 'DeleteMarkerReplication' => [ 'base' => '<p>Specifies whether Amazon S3 replicates the delete markers. If you specify a <code>Filter</code>, you must specify this element. However, in the latest version of replication configuration (when <code>Filter</code> is specified), Amazon S3 doesn\'t replicate delete markers. Therefore, the <code>DeleteMarkerReplication</code> element can contain only &lt;Status&gt;Disabled&lt;/Status&gt;. For an example configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config">Basic Rule Configuration</a>. </p> <note> <p> If you don\'t specify the <code>Filter</code> element, Amazon S3 assumes that the replication configuration is the earlier version, V1. In the earlier version, Amazon S3 handled replication of delete markers differently. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations">Backward Compatibility</a>.</p> </note>', 'refs' => [ 'ReplicationRule$DeleteMarkerReplication' => NULL, ], ], 'DeleteMarkerReplicationStatus' => [ 'base' => NULL, 'refs' => [ 'DeleteMarkerReplication$Status' => '<p>Indicates whether to replicate delete markers.</p> <note> <p> In the current implementation, Amazon S3 doesn\'t replicate the delete markers. The status must be <code>Disabled</code>. </p> </note>', ], ], 'DeleteMarkerVersionId' => [ 'base' => NULL, 'refs' => [ 'DeletedObject$DeleteMarkerVersionId' => '<p>The version ID of the delete marker created as a result of the DELETE operation. If you delete a specific object version, the value returned by this header is the version ID of the object version deleted.</p>', ], ], 'DeleteMarkers' => [ 'base' => NULL, 'refs' => [ 'ListObjectVersionsOutput$DeleteMarkers' => '<p>Container for an object that is a delete marker.</p>', ], ], 'DeleteObjectOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteObjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteObjectTaggingOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteObjectTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteObjectsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteObjectsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePublicAccessBlockRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletedObject' => [ 'base' => '<p>Information about the deleted object.</p>', 'refs' => [ 'DeletedObjects$member' => NULL, ], ], 'DeletedObjects' => [ 'base' => NULL, 'refs' => [ 'DeleteObjectsOutput$Deleted' => '<p>Container element for a successful delete. It identifies the object that was successfully deleted.</p>', ], ], 'Delimiter' => [ 'base' => NULL, 'refs' => [ 'ListMultipartUploadsOutput$Delimiter' => '<p>Contains the delimiter you specified in the request. If you don\'t specify a delimiter in your request, this element is absent from the response.</p>', 'ListMultipartUploadsRequest$Delimiter' => '<p>Character you use to group keys.</p> <p>All keys that contain the same string between the prefix, if specified, and the first occurrence of the delimiter after the prefix are grouped under a single result element, <code>CommonPrefixes</code>. If you don\'t specify the prefix parameter, then the substring starts at the beginning of the key. The keys that are grouped under <code>CommonPrefixes</code> result element are not returned elsewhere in the response.</p>', 'ListObjectVersionsOutput$Delimiter' => '<p>The delimiter grouping the included keys. A delimiter is a character that you specify to group keys. All keys that contain the same string between the prefix and the first occurrence of the delimiter are grouped under a single result element in <code>CommonPrefixes</code>. These groups are counted as one result against the max-keys limitation. These keys are not returned elsewhere in the response.</p>', 'ListObjectVersionsRequest$Delimiter' => '<p>A delimiter is a character that you specify to group keys. All keys that contain the same string between the <code>prefix</code> and the first occurrence of the delimiter are grouped under a single result element in CommonPrefixes. These groups are counted as one result against the max-keys limitation. These keys are not returned elsewhere in the response.</p>', 'ListObjectsOutput$Delimiter' => '<p>Causes keys that contain the same string between the prefix and the first occurrence of the delimiter to be rolled up into a single result element in the <code>CommonPrefixes</code> collection. These rolled-up keys are not returned elsewhere in the response. Each rolled-up result counts as only one return against the <code>MaxKeys</code> value.</p>', 'ListObjectsRequest$Delimiter' => '<p>A delimiter is a character you use to group keys.</p>', 'ListObjectsV2Output$Delimiter' => '<p>Causes keys that contain the same string between the prefix and the first occurrence of the delimiter to be rolled up into a single result element in the CommonPrefixes collection. These rolled-up keys are not returned elsewhere in the response. Each rolled-up result counts as only one return against the <code>MaxKeys</code> value.</p>', 'ListObjectsV2Request$Delimiter' => '<p>A delimiter is a character you use to group keys.</p>', ], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'RestoreRequest$Description' => '<p>The optional description for the job.</p>', ], ], 'Destination' => [ 'base' => '<p>Specifies information about where to publish analysis or configuration results for an Amazon S3 bucket and S3 Replication Time Control (S3 RTC).</p>', 'refs' => [ 'ReplicationRule$Destination' => '<p>A container for information about the replication destination and its configurations including enabling the S3 Replication Time Control (S3 RTC).</p>', ], ], 'DisplayName' => [ 'base' => NULL, 'refs' => [ 'Grantee$DisplayName' => '<p>Screen name of the grantee.</p>', 'Initiator$DisplayName' => '<p>Name of the Principal.</p>', 'Owner$DisplayName' => '<p>Container for the display name of the owner.</p>', ], ], 'ETag' => [ 'base' => NULL, 'refs' => [ 'CompleteMultipartUploadOutput$ETag' => '<p>Entity tag that identifies the newly created object\'s data. Objects with different object data will have different entity tags. The entity tag is an opaque string. The entity tag may or may not be an MD5 digest of the object data. If the entity tag is not an MD5 digest of the object data, it will contain one or more nonhexadecimal characters and/or will consist of less than 32 or more than 32 hexadecimal digits.</p>', 'CompletedPart$ETag' => '<p>Entity tag returned when the part was uploaded.</p>', 'CopyObjectResult$ETag' => '<p>Returns the ETag of the new object. The ETag reflects only changes to the contents of an object, not its metadata. The source and destination ETag is identical for a successfully copied object.</p>', 'CopyPartResult$ETag' => '<p>Entity tag of the object.</p>', 'GetObjectOutput$ETag' => '<p>An ETag is an opaque identifier assigned by a web server to a specific version of a resource found at a URL.</p>', 'HeadObjectOutput$ETag' => '<p>An ETag is an opaque identifier assigned by a web server to a specific version of a resource found at a URL.</p>', 'Object$ETag' => '<p>The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not its metadata. The ETag may or may not be an MD5 digest of the object data. Whether or not it is depends on how the object was created and how it is encrypted as described below:</p> <ul> <li> <p>Objects created by the PUT Object, POST Object, or Copy operation, or through the AWS Management Console, and are encrypted by SSE-S3 or plaintext, have ETags that are an MD5 digest of their object data.</p> </li> <li> <p>Objects created by the PUT Object, POST Object, or Copy operation, or through the AWS Management Console, and are encrypted by SSE-C or SSE-KMS, have ETags that are not an MD5 digest of their object data.</p> </li> <li> <p>If an object is created by either the Multipart Upload or Part Copy operation, the ETag is not an MD5 digest, regardless of the method of encryption.</p> </li> </ul>', 'ObjectVersion$ETag' => '<p>The entity tag is an MD5 hash of that version of the object.</p>', 'Part$ETag' => '<p>Entity tag returned when the part was uploaded.</p>', 'PutObjectOutput$ETag' => '<p>Entity tag for the uploaded object.</p>', 'UploadPartOutput$ETag' => '<p>Entity tag for the uploaded object.</p>', ], ], 'EmailAddress' => [ 'base' => NULL, 'refs' => [ 'Grantee$EmailAddress' => '<p>Email address of the grantee.</p> <note> <p>Using email addresses to specify a grantee is only supported in the following AWS Regions: </p> <ul> <li> <p>US East (N. Virginia)</p> </li> <li> <p>US West (N. California)</p> </li> <li> <p> US West (Oregon)</p> </li> <li> <p> Asia Pacific (Singapore)</p> </li> <li> <p>Asia Pacific (Sydney)</p> </li> <li> <p>Asia Pacific (Tokyo)</p> </li> <li> <p>Europe (Ireland)</p> </li> <li> <p>South America (São Paulo)</p> </li> </ul> <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the AWS General Reference.</p> </note>', ], ], 'EnableRequestProgress' => [ 'base' => NULL, 'refs' => [ 'RequestProgress$Enabled' => '<p>Specifies whether periodic QueryProgress frames should be sent. Valid values: TRUE, FALSE. Default value: FALSE.</p>', ], ], 'EncodingType' => [ 'base' => '<p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>', 'refs' => [ 'ListMultipartUploadsOutput$EncodingType' => '<p>Encoding type used by Amazon S3 to encode object keys in the response.</p> <p>If you specify <code>encoding-type</code> request parameter, Amazon S3 includes this element in the response, and returns encoded key name values in the following response elements:</p> <p> <code>Delimiter</code>, <code>KeyMarker</code>, <code>Prefix</code>, <code>NextKeyMarker</code>, <code>Key</code>.</p>', 'ListMultipartUploadsRequest$EncodingType' => NULL, 'ListObjectVersionsOutput$EncodingType' => '<p> Encoding type used by Amazon S3 to encode object key names in the XML response.</p> <p>If you specify encoding-type request parameter, Amazon S3 includes this element in the response, and returns encoded key name values in the following response elements:</p> <p> <code>KeyMarker, NextKeyMarker, Prefix, Key</code>, and <code>Delimiter</code>.</p>', 'ListObjectVersionsRequest$EncodingType' => NULL, 'ListObjectsOutput$EncodingType' => '<p>Encoding type used by Amazon S3 to encode object keys in the response.</p>', 'ListObjectsRequest$EncodingType' => NULL, 'ListObjectsV2Output$EncodingType' => '<p>Encoding type used by Amazon S3 to encode object key names in the XML response.</p> <p>If you specify the encoding-type request parameter, Amazon S3 includes this element in the response, and returns encoded key name values in the following response elements:</p> <p> <code>Delimiter, Prefix, Key,</code> and <code>StartAfter</code>.</p>', 'ListObjectsV2Request$EncodingType' => '<p>Encoding type used by Amazon S3 to encode object keys in the response.</p>', ], ], 'Encryption' => [ 'base' => '<p>Contains the type of server-side encryption used.</p>', 'refs' => [ 'S3Location$Encryption' => NULL, ], ], 'EncryptionConfiguration' => [ 'base' => '<p>Specifies encryption-related information for an Amazon S3 bucket that is a destination for replicated objects.</p>', 'refs' => [ 'Destination$EncryptionConfiguration' => '<p>A container that provides information about encryption. If <code>SourceSelectionCriteria</code> is specified, you must specify this element.</p>', ], ], 'End' => [ 'base' => NULL, 'refs' => [ 'ScanRange$End' => '<p>Specifies the end of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is one less than the size of the object being queried. If only the End parameter is supplied, it is interpreted to mean scan the last N bytes of the file. For example, <code>&lt;scanrange&gt;&lt;end&gt;50&lt;/end&gt;&lt;/scanrange&gt;</code> means scan the last 50 bytes.</p>', ], ], 'EndEvent' => [ 'base' => '<p>A message that indicates the request is complete and no more messages will be sent. You should not assume that the request is complete until the client receives an <code>EndEvent</code>.</p>', 'refs' => [ 'SelectObjectContentEventStream$End' => '<p>The End Event.</p>', ], ], 'Error' => [ 'base' => '<p>Container for all error elements.</p>', 'refs' => [ 'Errors$member' => NULL, ], ], 'ErrorDocument' => [ 'base' => '<p>The error information.</p>', 'refs' => [ 'GetBucketWebsiteOutput$ErrorDocument' => '<p>The object key name of the website error document to use for 4XX class errors.</p>', 'WebsiteConfiguration$ErrorDocument' => '<p>The name of the error document for the website.</p>', ], ], 'Errors' => [ 'base' => NULL, 'refs' => [ 'DeleteObjectsOutput$Errors' => '<p>Container for a failed delete operation that describes the object that Amazon S3 attempted to delete and the error it encountered.</p>', ], ], 'Event' => [ 'base' => '<p>The bucket event for which to send notifications.</p>', 'refs' => [ 'CloudFunctionConfiguration$Event' => NULL, 'EventList$member' => NULL, 'QueueConfigurationDeprecated$Event' => NULL, 'TopicConfigurationDeprecated$Event' => '<p>Bucket event for which to send notifications.</p>', ], ], 'EventList' => [ 'base' => NULL, 'refs' => [ 'CloudFunctionConfiguration$Events' => '<p>Bucket events for which to send notifications.</p>', 'LambdaFunctionConfiguration$Events' => '<p>The Amazon S3 bucket event for which to invoke the AWS Lambda function. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Supported Event Types</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'QueueConfiguration$Events' => '<p>A collection of bucket events for which to send notifications</p>', 'QueueConfigurationDeprecated$Events' => '<p>A collection of bucket events for which to send notifications</p>', 'TopicConfiguration$Events' => '<p>The Amazon S3 bucket event about which to send notifications. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Supported Event Types</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'TopicConfigurationDeprecated$Events' => '<p>A collection of events related to objects</p>', ], ], 'ExistingObjectReplication' => [ 'base' => '<p>Optional configuration to replicate existing source bucket objects. For more information, see <a href=" https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-what-is-isnot-replicated.html#existing-object-replication">Replicating Existing Objects</a> in the <i>Amazon S3 Developer Guide</i>. </p>', 'refs' => [ 'ReplicationRule$ExistingObjectReplication' => '<p/>', ], ], 'ExistingObjectReplicationStatus' => [ 'base' => NULL, 'refs' => [ 'ExistingObjectReplication$Status' => '<p/>', ], ], 'Expiration' => [ 'base' => NULL, 'refs' => [ 'CompleteMultipartUploadOutput$Expiration' => '<p>If the object expiration is configured, this will contain the expiration date (expiry-date) and rule ID (rule-id). The value of rule-id is URL encoded.</p>', 'CopyObjectOutput$Expiration' => '<p>If the object expiration is configured, the response includes this header.</p>', 'GetObjectOutput$Expiration' => '<p>If the object expiration is configured (see PUT Bucket lifecycle), the response includes this header. It includes the expiry-date and rule-id key-value pairs providing object expiration information. The value of the rule-id is URL encoded.</p>', 'HeadObjectOutput$Expiration' => '<p>If the object expiration is configured (see PUT Bucket lifecycle), the response includes this header. It includes the expiry-date and rule-id key-value pairs providing object expiration information. The value of the rule-id is URL encoded.</p>', 'PutObjectOutput$Expiration' => '<p> If the expiration is configured for the object (see <a>PutBucketLifecycleConfiguration</a>), the response includes this header. It includes the expiry-date and rule-id key-value pairs that provide information about object expiration. The value of the rule-id is URL encoded.</p>', ], ], 'ExpirationStatus' => [ 'base' => NULL, 'refs' => [ 'LifecycleRule$Status' => '<p>If \'Enabled\', the rule is currently being applied. If \'Disabled\', the rule is not currently being applied.</p>', 'Rule$Status' => '<p>If <code>Enabled</code>, the rule is currently being applied. If <code>Disabled</code>, the rule is not currently being applied.</p>', ], ], 'ExpiredObjectDeleteMarker' => [ 'base' => NULL, 'refs' => [ 'LifecycleExpiration$ExpiredObjectDeleteMarker' => '<p>Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to true, the delete marker will be expired; if set to false the policy takes no action. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.</p>', ], ], 'Expires' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$Expires' => '<p>The date and time at which the object is no longer cacheable.</p>', 'CreateMultipartUploadRequest$Expires' => '<p>The date and time at which the object is no longer cacheable.</p>', 'GetObjectOutput$Expires' => '<p>The date and time at which the object is no longer cacheable.</p>', 'HeadObjectOutput$Expires' => '<p>The date and time at which the object is no longer cacheable.</p>', 'PutObjectRequest$Expires' => '<p>The date and time at which the object is no longer cacheable. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.21">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.21</a>.</p>', ], ], 'ExposeHeader' => [ 'base' => NULL, 'refs' => [ 'ExposeHeaders$member' => NULL, ], ], 'ExposeHeaders' => [ 'base' => NULL, 'refs' => [ 'CORSRule$ExposeHeaders' => '<p>One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p>', ], ], 'Expression' => [ 'base' => NULL, 'refs' => [ 'SelectObjectContentRequest$Expression' => '<p>The expression that is used to query the object.</p>', 'SelectParameters$Expression' => '<p>The expression that is used to query the object.</p>', ], ], 'ExpressionType' => [ 'base' => NULL, 'refs' => [ 'SelectObjectContentRequest$ExpressionType' => '<p>The type of the provided expression (for example, SQL).</p>', 'SelectParameters$ExpressionType' => '<p>The type of the provided expression (for example, SQL).</p>', ], ], 'FetchOwner' => [ 'base' => NULL, 'refs' => [ 'ListObjectsV2Request$FetchOwner' => '<p>The owner field is not present in listV2 by default, if you want to return owner field with each key in the result then set the fetch owner field to true.</p>', ], ], 'FieldDelimiter' => [ 'base' => NULL, 'refs' => [ 'CSVInput$FieldDelimiter' => '<p>A single character used to separate individual fields in a record. You can specify an arbitrary delimiter.</p>', 'CSVOutput$FieldDelimiter' => '<p>The value used to separate individual fields in a record. You can specify an arbitrary delimiter.</p>', ], ], 'FileHeaderInfo' => [ 'base' => NULL, 'refs' => [ 'CSVInput$FileHeaderInfo' => '<p>Describes the first line of input. Valid values are:</p> <ul> <li> <p> <code>NONE</code>: First line is not a header.</p> </li> <li> <p> <code>IGNORE</code>: First line is a header, but you can\'t use the header values to indicate the column in an expression. You can use column position (such as _1, _2, …) to indicate the column (<code>SELECT s._1 FROM OBJECT s</code>).</p> </li> <li> <p> <code>Use</code>: First line is a header, and you can use the header value to identify a column in an expression (<code>SELECT "name" FROM OBJECT</code>). </p> </li> </ul>', ], ], 'FilterRule' => [ 'base' => '<p>Specifies the Amazon S3 object key name to filter on and whether to filter on the suffix or prefix of the key name.</p>', 'refs' => [ 'FilterRuleList$member' => NULL, ], ], 'FilterRuleList' => [ 'base' => '<p>A list of containers for the key-value pair that defines the criteria for the filter rule.</p>', 'refs' => [ 'S3KeyFilter$FilterRules' => NULL, ], ], 'FilterRuleName' => [ 'base' => NULL, 'refs' => [ 'FilterRule$Name' => '<p>The object key name prefix or suffix identifying one or more objects to which the filtering rule applies. The maximum length is 1,024 characters. Overlapping prefixes and suffixes are not supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', ], ], 'FilterRuleValue' => [ 'base' => NULL, 'refs' => [ 'FilterRule$Value' => '<p>The value that the filter searches for in object key names.</p>', ], ], 'GetBucketAccelerateConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketAccelerateConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketAclOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketAclRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketAnalyticsConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketAnalyticsConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketCorsOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketCorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketEncryptionOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketEncryptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketInventoryConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketInventoryConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketLifecycleConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketLifecycleConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketLifecycleOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketLifecycleRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketLocationOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketLocationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketLoggingOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketLoggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketMetricsConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketMetricsConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketNotificationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketPolicyStatusOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketPolicyStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketReplicationOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketReplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketRequestPaymentOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketRequestPaymentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketTaggingOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketVersioningOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketVersioningRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketWebsiteOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketWebsiteRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetObjectAclOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetObjectAclRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetObjectLegalHoldOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetObjectLegalHoldRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetObjectLockConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetObjectLockConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetObjectOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetObjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetObjectRetentionOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetObjectRetentionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetObjectTaggingOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetObjectTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetObjectTorrentOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetObjectTorrentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPublicAccessBlockOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetPublicAccessBlockRequest' => [ 'base' => NULL, 'refs' => [], ], 'GlacierJobParameters' => [ 'base' => '<p>Container for S3 Glacier job parameters.</p>', 'refs' => [ 'RestoreRequest$GlacierJobParameters' => '<p>S3 Glacier related parameters pertaining to this job. Do not use with restores that specify <code>OutputLocation</code>.</p>', ], ], 'Grant' => [ 'base' => '<p>Container for grant information.</p>', 'refs' => [ 'Grants$member' => NULL, ], ], 'GrantFullControl' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$GrantFullControl' => '<p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>', 'CreateBucketRequest$GrantFullControl' => '<p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>', 'CreateMultipartUploadRequest$GrantFullControl' => '<p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>', 'PutBucketAclRequest$GrantFullControl' => '<p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>', 'PutObjectAclRequest$GrantFullControl' => '<p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>', 'PutObjectRequest$GrantFullControl' => '<p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>', ], ], 'GrantRead' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$GrantRead' => '<p>Allows grantee to read the object data and its metadata.</p>', 'CreateBucketRequest$GrantRead' => '<p>Allows grantee to list the objects in the bucket.</p>', 'CreateMultipartUploadRequest$GrantRead' => '<p>Allows grantee to read the object data and its metadata.</p>', 'PutBucketAclRequest$GrantRead' => '<p>Allows grantee to list the objects in the bucket.</p>', 'PutObjectAclRequest$GrantRead' => '<p>Allows grantee to list the objects in the bucket.</p>', 'PutObjectRequest$GrantRead' => '<p>Allows grantee to read the object data and its metadata.</p>', ], ], 'GrantReadACP' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$GrantReadACP' => '<p>Allows grantee to read the object ACL.</p>', 'CreateBucketRequest$GrantReadACP' => '<p>Allows grantee to read the bucket ACL.</p>', 'CreateMultipartUploadRequest$GrantReadACP' => '<p>Allows grantee to read the object ACL.</p>', 'PutBucketAclRequest$GrantReadACP' => '<p>Allows grantee to read the bucket ACL.</p>', 'PutObjectAclRequest$GrantReadACP' => '<p>Allows grantee to read the bucket ACL.</p>', 'PutObjectRequest$GrantReadACP' => '<p>Allows grantee to read the object ACL.</p>', ], ], 'GrantWrite' => [ 'base' => NULL, 'refs' => [ 'CreateBucketRequest$GrantWrite' => '<p>Allows grantee to create, overwrite, and delete any object in the bucket.</p>', 'PutBucketAclRequest$GrantWrite' => '<p>Allows grantee to create, overwrite, and delete any object in the bucket.</p>', 'PutObjectAclRequest$GrantWrite' => '<p>Allows grantee to create, overwrite, and delete any object in the bucket.</p>', ], ], 'GrantWriteACP' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$GrantWriteACP' => '<p>Allows grantee to write the ACL for the applicable object.</p>', 'CreateBucketRequest$GrantWriteACP' => '<p>Allows grantee to write the ACL for the applicable bucket.</p>', 'CreateMultipartUploadRequest$GrantWriteACP' => '<p>Allows grantee to write the ACL for the applicable object.</p>', 'PutBucketAclRequest$GrantWriteACP' => '<p>Allows grantee to write the ACL for the applicable bucket.</p>', 'PutObjectAclRequest$GrantWriteACP' => '<p>Allows grantee to write the ACL for the applicable bucket.</p>', 'PutObjectRequest$GrantWriteACP' => '<p>Allows grantee to write the ACL for the applicable object.</p>', ], ], 'Grantee' => [ 'base' => '<p>Container for the person being granted permissions.</p>', 'refs' => [ 'Grant$Grantee' => '<p>The person being granted permissions.</p>', 'TargetGrant$Grantee' => '<p>Container for the person being granted permissions.</p>', ], ], 'Grants' => [ 'base' => NULL, 'refs' => [ 'AccessControlPolicy$Grants' => '<p>A list of grants.</p>', 'GetBucketAclOutput$Grants' => '<p>A list of grants.</p>', 'GetObjectAclOutput$Grants' => '<p>A list of grants.</p>', 'S3Location$AccessControlList' => '<p>A list of grants that control access to the staged results.</p>', ], ], 'HeadBucketRequest' => [ 'base' => NULL, 'refs' => [], ], 'HeadObjectOutput' => [ 'base' => NULL, 'refs' => [], ], 'HeadObjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'HostName' => [ 'base' => NULL, 'refs' => [ 'Redirect$HostName' => '<p>The host name to use in the redirect request.</p>', 'RedirectAllRequestsTo$HostName' => '<p>Name of the host where requests are redirected.</p>', ], ], 'HttpErrorCodeReturnedEquals' => [ 'base' => NULL, 'refs' => [ 'Condition$HttpErrorCodeReturnedEquals' => '<p>The HTTP error code when the redirect is applied. In the event of an error, if the error code equals this value, then the specified redirect is applied. Required when parent element <code>Condition</code> is specified and sibling <code>KeyPrefixEquals</code> is not specified. If both are specified, then both must be true for the redirect to be applied.</p>', ], ], 'HttpRedirectCode' => [ 'base' => NULL, 'refs' => [ 'Redirect$HttpRedirectCode' => '<p>The HTTP redirect code to use on the response. Not required if one of the siblings is present.</p>', ], ], 'ID' => [ 'base' => NULL, 'refs' => [ 'Grantee$ID' => '<p>The canonical user ID of the grantee.</p>', 'Initiator$ID' => '<p>If the principal is an AWS account, it provides the Canonical User ID. If the principal is an IAM User, it provides a user ARN value.</p>', 'LifecycleRule$ID' => '<p>Unique identifier for the rule. The value cannot be longer than 255 characters.</p>', 'Owner$ID' => '<p>Container for the ID of the owner.</p>', 'ReplicationRule$ID' => '<p>A unique identifier for the rule. The maximum value is 255 characters.</p>', 'Rule$ID' => '<p>Unique identifier for the rule. The value can\'t be longer than 255 characters.</p>', ], ], 'IfMatch' => [ 'base' => NULL, 'refs' => [ 'GetObjectRequest$IfMatch' => '<p>Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412 (precondition failed).</p>', 'HeadObjectRequest$IfMatch' => '<p>Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412 (precondition failed).</p>', ], ], 'IfModifiedSince' => [ 'base' => NULL, 'refs' => [ 'GetObjectRequest$IfModifiedSince' => '<p>Return the object only if it has been modified since the specified time, otherwise return a 304 (not modified).</p>', 'HeadObjectRequest$IfModifiedSince' => '<p>Return the object only if it has been modified since the specified time, otherwise return a 304 (not modified).</p>', ], ], 'IfNoneMatch' => [ 'base' => NULL, 'refs' => [ 'GetObjectRequest$IfNoneMatch' => '<p>Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304 (not modified).</p>', 'HeadObjectRequest$IfNoneMatch' => '<p>Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304 (not modified).</p>', ], ], 'IfUnmodifiedSince' => [ 'base' => NULL, 'refs' => [ 'GetObjectRequest$IfUnmodifiedSince' => '<p>Return the object only if it has not been modified since the specified time, otherwise return a 412 (precondition failed).</p>', 'HeadObjectRequest$IfUnmodifiedSince' => '<p>Return the object only if it has not been modified since the specified time, otherwise return a 412 (precondition failed).</p>', ], ], 'IndexDocument' => [ 'base' => '<p>Container for the <code>Suffix</code> element.</p>', 'refs' => [ 'GetBucketWebsiteOutput$IndexDocument' => '<p>The name of the index document for the website (for example <code>index.html</code>).</p>', 'WebsiteConfiguration$IndexDocument' => '<p>The name of the index document for the website.</p>', ], ], 'Initiated' => [ 'base' => NULL, 'refs' => [ 'MultipartUpload$Initiated' => '<p>Date and time at which the multipart upload was initiated.</p>', ], ], 'Initiator' => [ 'base' => '<p>Container element that identifies who initiated the multipart upload. </p>', 'refs' => [ 'ListPartsOutput$Initiator' => '<p>Container element that identifies who initiated the multipart upload. If the initiator is an AWS account, this element provides the same information as the <code>Owner</code> element. If the initiator is an IAM User, this element provides the user ARN and display name.</p>', 'MultipartUpload$Initiator' => '<p>Identifies who initiated the multipart upload.</p>', ], ], 'InputSerialization' => [ 'base' => '<p>Describes the serialization format of the object.</p>', 'refs' => [ 'SelectObjectContentRequest$InputSerialization' => '<p>Describes the format of the data in the object that is being queried.</p>', 'SelectParameters$InputSerialization' => '<p>Describes the serialization format of the object.</p>', ], ], 'InventoryConfiguration' => [ 'base' => '<p>Specifies the inventory configuration for an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html">GET Bucket inventory</a> in the <i>Amazon Simple Storage Service API Reference</i>. </p>', 'refs' => [ 'GetBucketInventoryConfigurationOutput$InventoryConfiguration' => '<p>Specifies the inventory configuration.</p>', 'InventoryConfigurationList$member' => NULL, 'PutBucketInventoryConfigurationRequest$InventoryConfiguration' => '<p>Specifies the inventory configuration.</p>', ], ], 'InventoryConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ListBucketInventoryConfigurationsOutput$InventoryConfigurationList' => '<p>The list of inventory configurations for a bucket.</p>', ], ], 'InventoryDestination' => [ 'base' => '<p>Specifies the inventory configuration for an Amazon S3 bucket.</p>', 'refs' => [ 'InventoryConfiguration$Destination' => '<p>Contains information about where to publish the inventory results.</p>', ], ], 'InventoryEncryption' => [ 'base' => '<p>Contains the type of server-side encryption used to encrypt the inventory results.</p>', 'refs' => [ 'InventoryS3BucketDestination$Encryption' => '<p>Contains the type of server-side encryption used to encrypt the inventory results.</p>', ], ], 'InventoryFilter' => [ 'base' => '<p>Specifies an inventory filter. The inventory only includes objects that meet the filter\'s criteria.</p>', 'refs' => [ 'InventoryConfiguration$Filter' => '<p>Specifies an inventory filter. The inventory only includes objects that meet the filter\'s criteria.</p>', ], ], 'InventoryFormat' => [ 'base' => NULL, 'refs' => [ 'InventoryS3BucketDestination$Format' => '<p>Specifies the output format of the inventory results.</p>', ], ], 'InventoryFrequency' => [ 'base' => NULL, 'refs' => [ 'InventorySchedule$Frequency' => '<p>Specifies how frequently inventory results are produced.</p>', ], ], 'InventoryId' => [ 'base' => NULL, 'refs' => [ 'DeleteBucketInventoryConfigurationRequest$Id' => '<p>The ID used to identify the inventory configuration.</p>', 'GetBucketInventoryConfigurationRequest$Id' => '<p>The ID used to identify the inventory configuration.</p>', 'InventoryConfiguration$Id' => '<p>The ID used to identify the inventory configuration.</p>', 'PutBucketInventoryConfigurationRequest$Id' => '<p>The ID used to identify the inventory configuration.</p>', ], ], 'InventoryIncludedObjectVersions' => [ 'base' => NULL, 'refs' => [ 'InventoryConfiguration$IncludedObjectVersions' => '<p>Object versions to include in the inventory list. If set to <code>All</code>, the list includes all the object versions, which adds the version-related fields <code>VersionId</code>, <code>IsLatest</code>, and <code>DeleteMarker</code> to the list. If set to <code>Current</code>, the list does not contain these version-related fields.</p>', ], ], 'InventoryOptionalField' => [ 'base' => NULL, 'refs' => [ 'InventoryOptionalFields$member' => NULL, ], ], 'InventoryOptionalFields' => [ 'base' => NULL, 'refs' => [ 'InventoryConfiguration$OptionalFields' => '<p>Contains the optional fields that are included in the inventory results.</p>', ], ], 'InventoryS3BucketDestination' => [ 'base' => '<p>Contains the bucket name, file format, bucket owner (optional), and prefix (optional) where inventory results are published.</p>', 'refs' => [ 'InventoryDestination$S3BucketDestination' => '<p>Contains the bucket name, file format, bucket owner (optional), and prefix (optional) where inventory results are published.</p>', ], ], 'InventorySchedule' => [ 'base' => '<p>Specifies the schedule for generating inventory results.</p>', 'refs' => [ 'InventoryConfiguration$Schedule' => '<p>Specifies the schedule for generating inventory results.</p>', ], ], 'IsEnabled' => [ 'base' => NULL, 'refs' => [ 'InventoryConfiguration$IsEnabled' => '<p>Specifies whether the inventory is enabled or disabled. If set to <code>True</code>, an inventory list is generated. If set to <code>False</code>, no inventory list is generated.</p>', ], ], 'IsLatest' => [ 'base' => NULL, 'refs' => [ 'DeleteMarkerEntry$IsLatest' => '<p>Specifies whether the object is (true) or is not (false) the latest version of an object.</p>', 'ObjectVersion$IsLatest' => '<p>Specifies whether the object is (true) or is not (false) the latest version of an object.</p>', ], ], 'IsPublic' => [ 'base' => NULL, 'refs' => [ 'PolicyStatus$IsPublic' => '<p>The policy status for this bucket. <code>TRUE</code> indicates that this bucket is public. <code>FALSE</code> indicates that the bucket is not public.</p>', ], ], 'IsTruncated' => [ 'base' => NULL, 'refs' => [ 'ListBucketAnalyticsConfigurationsOutput$IsTruncated' => '<p>Indicates whether the returned list of analytics configurations is complete. A value of true indicates that the list is not complete and the NextContinuationToken will be provided for a subsequent request.</p>', 'ListBucketInventoryConfigurationsOutput$IsTruncated' => '<p>Tells whether the returned list of inventory configurations is complete. A value of true indicates that the list is not complete and the NextContinuationToken is provided for a subsequent request.</p>', 'ListBucketMetricsConfigurationsOutput$IsTruncated' => '<p>Indicates whether the returned list of metrics configurations is complete. A value of true indicates that the list is not complete and the NextContinuationToken will be provided for a subsequent request.</p>', 'ListMultipartUploadsOutput$IsTruncated' => '<p>Indicates whether the returned list of multipart uploads is truncated. A value of true indicates that the list was truncated. The list can be truncated if the number of multipart uploads exceeds the limit allowed or specified by max uploads.</p>', 'ListObjectVersionsOutput$IsTruncated' => '<p>A flag that indicates whether Amazon S3 returned all of the results that satisfied the search criteria. If your results were truncated, you can make a follow-up paginated request using the NextKeyMarker and NextVersionIdMarker response parameters as a starting place in another request to return the rest of the results.</p>', 'ListObjectsOutput$IsTruncated' => '<p>A flag that indicates whether Amazon S3 returned all of the results that satisfied the search criteria.</p>', 'ListObjectsV2Output$IsTruncated' => '<p>Set to false if all of the results were returned. Set to true if more keys are available to return. If the number of results exceeds that specified by MaxKeys, all of the results might not be returned.</p>', 'ListPartsOutput$IsTruncated' => '<p> Indicates whether the returned list of parts is truncated. A true value indicates that the list was truncated. A list can be truncated if the number of parts exceeds the limit returned in the MaxParts element.</p>', ], ], 'JSONInput' => [ 'base' => '<p>Specifies JSON as object\'s input serialization format.</p>', 'refs' => [ 'InputSerialization$JSON' => '<p>Specifies JSON as object\'s input serialization format.</p>', ], ], 'JSONOutput' => [ 'base' => '<p>Specifies JSON as request\'s output serialization format.</p>', 'refs' => [ 'OutputSerialization$JSON' => '<p>Specifies JSON as request\'s output serialization format.</p>', ], ], 'JSONType' => [ 'base' => NULL, 'refs' => [ 'JSONInput$Type' => '<p>The type of JSON. Valid values: Document, Lines.</p>', ], ], 'KMSContext' => [ 'base' => NULL, 'refs' => [ 'Encryption$KMSContext' => '<p>If the encryption type is <code>aws:kms</code>, this optional value can be used to specify the encryption context for the restore results.</p>', ], ], 'KeyCount' => [ 'base' => NULL, 'refs' => [ 'ListObjectsV2Output$KeyCount' => '<p>KeyCount is the number of keys returned with this request. KeyCount will always be less than equals to MaxKeys field. Say you ask for 50 keys, your result will include less than equals 50 keys </p>', ], ], 'KeyMarker' => [ 'base' => NULL, 'refs' => [ 'ListMultipartUploadsOutput$KeyMarker' => '<p>The key at or after which the listing began.</p>', 'ListMultipartUploadsRequest$KeyMarker' => '<p>Together with upload-id-marker, this parameter specifies the multipart upload after which listing should begin.</p> <p>If <code>upload-id-marker</code> is not specified, only the keys lexicographically greater than the specified <code>key-marker</code> will be included in the list.</p> <p>If <code>upload-id-marker</code> is specified, any multipart uploads for a key equal to the <code>key-marker</code> might also be included, provided those multipart uploads have upload IDs lexicographically greater than the specified <code>upload-id-marker</code>.</p>', 'ListObjectVersionsOutput$KeyMarker' => '<p>Marks the last key returned in a truncated response.</p>', 'ListObjectVersionsRequest$KeyMarker' => '<p>Specifies the key to start with when listing objects in a bucket.</p>', ], ], 'KeyPrefixEquals' => [ 'base' => NULL, 'refs' => [ 'Condition$KeyPrefixEquals' => '<p>The object key name prefix when the redirect is applied. For example, to redirect requests for <code>ExamplePage.html</code>, the key prefix will be <code>ExamplePage.html</code>. To redirect request for all pages with the prefix <code>docs/</code>, the key prefix will be <code>/docs</code>, which identifies all objects in the <code>docs/</code> folder. Required when the parent element <code>Condition</code> is specified and sibling <code>HttpErrorCodeReturnedEquals</code> is not specified. If both conditions are specified, both must be true for the redirect to be applied.</p>', ], ], 'LambdaFunctionArn' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionConfiguration$LambdaFunctionArn' => '<p>The Amazon Resource Name (ARN) of the AWS Lambda function that Amazon S3 invokes when the specified event type occurs.</p>', ], ], 'LambdaFunctionConfiguration' => [ 'base' => '<p>A container for specifying the configuration for AWS Lambda notifications.</p>', 'refs' => [ 'LambdaFunctionConfigurationList$member' => NULL, ], ], 'LambdaFunctionConfigurationList' => [ 'base' => NULL, 'refs' => [ 'NotificationConfiguration$LambdaFunctionConfigurations' => '<p>Describes the AWS Lambda functions to invoke and the events for which to invoke them.</p>', ], ], 'LastModified' => [ 'base' => NULL, 'refs' => [ 'CopyObjectResult$LastModified' => '<p>Returns the date that the object was last modified.</p>', 'CopyPartResult$LastModified' => '<p>Date and time at which the object was uploaded.</p>', 'DeleteMarkerEntry$LastModified' => '<p>Date and time the object was last modified.</p>', 'GetObjectOutput$LastModified' => '<p>Last modified date of the object</p>', 'HeadObjectOutput$LastModified' => '<p>Last modified date of the object</p>', 'Object$LastModified' => '<p>The date the Object was Last Modified</p>', 'ObjectVersion$LastModified' => '<p>Date and time the object was last modified.</p>', 'Part$LastModified' => '<p>Date and time at which the part was uploaded.</p>', ], ], 'LifecycleConfiguration' => [ 'base' => '<p>Container for lifecycle rules. You can add as many as 1000 rules.</p>', 'refs' => [ 'PutBucketLifecycleRequest$LifecycleConfiguration' => '<p/>', ], ], 'LifecycleExpiration' => [ 'base' => '<p>Container for the expiration for the lifecycle of the object.</p>', 'refs' => [ 'LifecycleRule$Expiration' => '<p>Specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker.</p>', 'Rule$Expiration' => '<p>Specifies the expiration for the lifecycle of the object.</p>', ], ], 'LifecycleRule' => [ 'base' => '<p>A lifecycle rule for individual objects in an Amazon S3 bucket.</p>', 'refs' => [ 'LifecycleRules$member' => NULL, ], ], 'LifecycleRuleAndOperator' => [ 'base' => '<p>This is used in a Lifecycle Rule Filter to apply a logical AND to two or more predicates. The Lifecycle Rule will apply to any object matching all of the predicates configured inside the And operator.</p>', 'refs' => [ 'LifecycleRuleFilter$And' => NULL, ], ], 'LifecycleRuleFilter' => [ 'base' => '<p>The <code>Filter</code> is used to identify objects that a Lifecycle Rule applies to. A <code>Filter</code> must have exactly one of <code>Prefix</code>, <code>Tag</code>, or <code>And</code> specified.</p>', 'refs' => [ 'LifecycleRule$Filter' => NULL, ], ], 'LifecycleRules' => [ 'base' => NULL, 'refs' => [ 'BucketLifecycleConfiguration$Rules' => '<p>A lifecycle rule for individual objects in an Amazon S3 bucket.</p>', 'GetBucketLifecycleConfigurationOutput$Rules' => '<p>Container for a lifecycle rule.</p>', ], ], 'ListBucketAnalyticsConfigurationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListBucketAnalyticsConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBucketInventoryConfigurationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListBucketInventoryConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBucketMetricsConfigurationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListBucketMetricsConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBucketsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListMultipartUploadsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListMultipartUploadsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListObjectVersionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListObjectVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListObjectsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListObjectsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListObjectsV2Output' => [ 'base' => NULL, 'refs' => [], ], 'ListObjectsV2Request' => [ 'base' => NULL, 'refs' => [], ], 'ListPartsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListPartsRequest' => [ 'base' => NULL, 'refs' => [], ], 'Location' => [ 'base' => NULL, 'refs' => [ 'CompleteMultipartUploadOutput$Location' => '<p>The URI that identifies the newly created object.</p>', 'CreateBucketOutput$Location' => '<p>Specifies the Region where the bucket will be created. If you are creating a bucket on the US East (N. Virginia) Region (us-east-1), you do not need to specify the location.</p>', ], ], 'LocationPrefix' => [ 'base' => NULL, 'refs' => [ 'S3Location$Prefix' => '<p>The prefix that is prepended to the restore results for this request.</p>', ], ], 'LoggingEnabled' => [ 'base' => '<p>Describes where logs are stored and the prefix that Amazon S3 assigns to all log object keys for a bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html">PUT Bucket logging</a> in the <i>Amazon Simple Storage Service API Reference</i>.</p>', 'refs' => [ 'BucketLoggingStatus$LoggingEnabled' => NULL, 'GetBucketLoggingOutput$LoggingEnabled' => NULL, ], ], 'MFA' => [ 'base' => NULL, 'refs' => [ 'DeleteObjectRequest$MFA' => '<p>The concatenation of the authentication device\'s serial number, a space, and the value that is displayed on your authentication device. Required to permanently delete a versioned object if versioning is configured with MFA delete enabled.</p>', 'DeleteObjectsRequest$MFA' => '<p>The concatenation of the authentication device\'s serial number, a space, and the value that is displayed on your authentication device. Required to permanently delete a versioned object if versioning is configured with MFA delete enabled.</p>', 'PutBucketVersioningRequest$MFA' => '<p>The concatenation of the authentication device\'s serial number, a space, and the value that is displayed on your authentication device.</p>', ], ], 'MFADelete' => [ 'base' => NULL, 'refs' => [ 'VersioningConfiguration$MFADelete' => '<p>Specifies whether MFA delete is enabled in the bucket versioning configuration. This element is only returned if the bucket has been configured with MFA delete. If the bucket has never been so configured, this element is not returned.</p>', ], ], 'MFADeleteStatus' => [ 'base' => NULL, 'refs' => [ 'GetBucketVersioningOutput$MFADelete' => '<p>Specifies whether MFA delete is enabled in the bucket versioning configuration. This element is only returned if the bucket has been configured with MFA delete. If the bucket has never been so configured, this element is not returned.</p>', ], ], 'Marker' => [ 'base' => NULL, 'refs' => [ 'ListObjectsOutput$Marker' => '<p>Indicates where in the bucket listing begins. Marker is included in the response if it was sent with the request.</p>', 'ListObjectsRequest$Marker' => '<p>Specifies the key to start with when listing objects in a bucket.</p>', ], ], 'MaxAgeSeconds' => [ 'base' => NULL, 'refs' => [ 'CORSRule$MaxAgeSeconds' => '<p>The time in seconds that your browser is to cache the preflight response for the specified resource.</p>', ], ], 'MaxKeys' => [ 'base' => NULL, 'refs' => [ 'ListObjectVersionsOutput$MaxKeys' => '<p>Specifies the maximum number of objects to return.</p>', 'ListObjectVersionsRequest$MaxKeys' => '<p>Sets the maximum number of keys returned in the response. By default the API returns up to 1,000 key names. The response might contain fewer keys but will never contain more. If additional keys satisfy the search criteria, but were not returned because max-keys was exceeded, the response contains &lt;isTruncated&gt;true&lt;/isTruncated&gt;. To return the additional keys, see key-marker and version-id-marker.</p>', 'ListObjectsOutput$MaxKeys' => '<p>The maximum number of keys returned in the response body.</p>', 'ListObjectsRequest$MaxKeys' => '<p>Sets the maximum number of keys returned in the response. By default the API returns up to 1,000 key names. The response might contain fewer keys but will never contain more. </p>', 'ListObjectsV2Output$MaxKeys' => '<p>Sets the maximum number of keys returned in the response. By default the API returns up to 1,000 key names. The response might contain fewer keys but will never contain more.</p>', 'ListObjectsV2Request$MaxKeys' => '<p>Sets the maximum number of keys returned in the response. By default the API returns up to 1,000 key names. The response might contain fewer keys but will never contain more.</p>', ], ], 'MaxParts' => [ 'base' => NULL, 'refs' => [ 'ListPartsOutput$MaxParts' => '<p>Maximum number of parts that were allowed in the response.</p>', 'ListPartsRequest$MaxParts' => '<p>Sets the maximum number of parts to return.</p>', ], ], 'MaxUploads' => [ 'base' => NULL, 'refs' => [ 'ListMultipartUploadsOutput$MaxUploads' => '<p>Maximum number of multipart uploads that could have been included in the response.</p>', 'ListMultipartUploadsRequest$MaxUploads' => '<p>Sets the maximum number of multipart uploads, from 1 to 1,000, to return in the response body. 1,000 is the maximum number of uploads that can be returned in a response.</p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'Error$Message' => '<p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don\'t know how or don\'t care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>', ], ], 'Metadata' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$Metadata' => '<p>A map of metadata to store with the object in S3.</p>', 'CreateMultipartUploadRequest$Metadata' => '<p>A map of metadata to store with the object in S3.</p>', 'GetObjectOutput$Metadata' => '<p>A map of metadata to store with the object in S3.</p>', 'HeadObjectOutput$Metadata' => '<p>A map of metadata to store with the object in S3.</p>', 'PutObjectRequest$Metadata' => '<p>A map of metadata to store with the object in S3.</p>', ], ], 'MetadataDirective' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$MetadataDirective' => '<p>Specifies whether the metadata is copied from the source object or replaced with metadata provided in the request.</p>', ], ], 'MetadataEntry' => [ 'base' => '<p>A metadata key-value pair to store with an object.</p>', 'refs' => [ 'UserMetadata$member' => NULL, ], ], 'MetadataKey' => [ 'base' => NULL, 'refs' => [ 'Metadata$key' => NULL, 'MetadataEntry$Name' => '<p>Name of the Object.</p>', ], ], 'MetadataValue' => [ 'base' => NULL, 'refs' => [ 'Metadata$value' => NULL, 'MetadataEntry$Value' => '<p>Value of the Object.</p>', ], ], 'Metrics' => [ 'base' => '<p> A container specifying replication metrics-related settings enabling metrics and Amazon S3 events for S3 Replication Time Control (S3 RTC). Must be specified together with a <code>ReplicationTime</code> block. </p>', 'refs' => [ 'Destination$Metrics' => '<p> A container specifying replication metrics-related settings enabling metrics and Amazon S3 events for S3 Replication Time Control (S3 RTC). Must be specified together with a <code>ReplicationTime</code> block. </p>', ], ], 'MetricsAndOperator' => [ 'base' => '<p>A conjunction (logical AND) of predicates, which is used in evaluating a metrics filter. The operator must have at least two predicates, and an object must match all of the predicates in order for the filter to apply.</p>', 'refs' => [ 'MetricsFilter$And' => '<p>A conjunction (logical AND) of predicates, which is used in evaluating a metrics filter. The operator must have at least two predicates, and an object must match all of the predicates in order for the filter to apply.</p>', ], ], 'MetricsConfiguration' => [ 'base' => '<p>Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket. If you\'re updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don\'t include the elements you want to keep, they are erased. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTMetricConfiguration.html"> PUT Bucket metrics</a> in the <i>Amazon Simple Storage Service API Reference</i>.</p>', 'refs' => [ 'GetBucketMetricsConfigurationOutput$MetricsConfiguration' => '<p>Specifies the metrics configuration.</p>', 'MetricsConfigurationList$member' => NULL, 'PutBucketMetricsConfigurationRequest$MetricsConfiguration' => '<p>Specifies the metrics configuration.</p>', ], ], 'MetricsConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ListBucketMetricsConfigurationsOutput$MetricsConfigurationList' => '<p>The list of metrics configurations for a bucket.</p>', ], ], 'MetricsFilter' => [ 'base' => '<p>Specifies a metrics configuration filter. The metrics configuration only includes objects that meet the filter\'s criteria. A filter must be a prefix, a tag, or a conjunction (MetricsAndOperator).</p>', 'refs' => [ 'MetricsConfiguration$Filter' => '<p>Specifies a metrics configuration filter. The metrics configuration will only include objects that meet the filter\'s criteria. A filter must be a prefix, a tag, or a conjunction (MetricsAndOperator).</p>', ], ], 'MetricsId' => [ 'base' => NULL, 'refs' => [ 'DeleteBucketMetricsConfigurationRequest$Id' => '<p>The ID used to identify the metrics configuration.</p>', 'GetBucketMetricsConfigurationRequest$Id' => '<p>The ID used to identify the metrics configuration.</p>', 'MetricsConfiguration$Id' => '<p>The ID used to identify the metrics configuration.</p>', 'PutBucketMetricsConfigurationRequest$Id' => '<p>The ID used to identify the metrics configuration.</p>', ], ], 'MetricsStatus' => [ 'base' => NULL, 'refs' => [ 'Metrics$Status' => '<p> Specifies whether the replication metrics are enabled. </p>', ], ], 'Minutes' => [ 'base' => NULL, 'refs' => [ 'ReplicationTimeValue$Minutes' => '<p> Contains an integer specifying time in minutes. </p> <p> Valid values: 15 minutes. </p>', ], ], 'MissingMeta' => [ 'base' => NULL, 'refs' => [ 'GetObjectOutput$MissingMeta' => '<p>This is set to the number of metadata entries not returned in <code>x-amz-meta</code> headers. This can happen if you create metadata using an API like SOAP that supports more flexible metadata than the REST API. For example, using SOAP, you can create metadata whose values are not legal HTTP headers.</p>', 'HeadObjectOutput$MissingMeta' => '<p>This is set to the number of metadata entries not returned in <code>x-amz-meta</code> headers. This can happen if you create metadata using an API like SOAP that supports more flexible metadata than the REST API. For example, using SOAP, you can create metadata whose values are not legal HTTP headers.</p>', ], ], 'MultipartUpload' => [ 'base' => '<p>Container for the <code>MultipartUpload</code> for the Amazon S3 object.</p>', 'refs' => [ 'MultipartUploadList$member' => NULL, ], ], 'MultipartUploadId' => [ 'base' => NULL, 'refs' => [ 'AbortMultipartUploadRequest$UploadId' => '<p>Upload ID that identifies the multipart upload.</p>', 'CompleteMultipartUploadRequest$UploadId' => '<p>ID for the initiated multipart upload.</p>', 'CreateMultipartUploadOutput$UploadId' => '<p>ID for the initiated multipart upload.</p>', 'ListPartsOutput$UploadId' => '<p>Upload ID identifying the multipart upload whose parts are being listed.</p>', 'ListPartsRequest$UploadId' => '<p>Upload ID identifying the multipart upload whose parts are being listed.</p>', 'MultipartUpload$UploadId' => '<p>Upload ID that identifies the multipart upload.</p>', 'UploadPartCopyRequest$UploadId' => '<p>Upload ID identifying the multipart upload whose part is being copied.</p>', 'UploadPartRequest$UploadId' => '<p>Upload ID identifying the multipart upload whose part is being uploaded.</p>', ], ], 'MultipartUploadList' => [ 'base' => NULL, 'refs' => [ 'ListMultipartUploadsOutput$Uploads' => '<p>Container for elements related to a particular multipart upload. A response can contain zero or more <code>Upload</code> elements.</p>', ], ], 'NextKeyMarker' => [ 'base' => NULL, 'refs' => [ 'ListMultipartUploadsOutput$NextKeyMarker' => '<p>When a list is truncated, this element specifies the value that should be used for the key-marker request parameter in a subsequent request.</p>', 'ListObjectVersionsOutput$NextKeyMarker' => '<p>When the number of responses exceeds the value of <code>MaxKeys</code>, <code>NextKeyMarker</code> specifies the first key not returned that satisfies the search criteria. Use this value for the key-marker request parameter in a subsequent request.</p>', ], ], 'NextMarker' => [ 'base' => NULL, 'refs' => [ 'ListObjectsOutput$NextMarker' => '<p>When response is truncated (the IsTruncated element value in the response is true), you can use the key name in this field as marker in the subsequent request to get next set of objects. Amazon S3 lists objects in alphabetical order Note: This element is returned only if you have delimiter request parameter specified. If response does not include the NextMarker and it is truncated, you can use the value of the last Key in the response as the marker in the subsequent request to get the next set of object keys.</p>', ], ], 'NextPartNumberMarker' => [ 'base' => NULL, 'refs' => [ 'ListPartsOutput$NextPartNumberMarker' => '<p>When a list is truncated, this element specifies the last part in the list, as well as the value to use for the part-number-marker request parameter in a subsequent request.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListBucketAnalyticsConfigurationsOutput$NextContinuationToken' => '<p> <code>NextContinuationToken</code> is sent when <code>isTruncated</code> is true, which indicates that there are more analytics configurations to list. The next request must include this <code>NextContinuationToken</code>. The token is obfuscated and is not a usable value.</p>', 'ListBucketInventoryConfigurationsOutput$NextContinuationToken' => '<p>The marker used to continue this inventory configuration listing. Use the <code>NextContinuationToken</code> from this response to continue the listing in a subsequent request. The continuation token is an opaque value that Amazon S3 understands.</p>', 'ListBucketMetricsConfigurationsOutput$NextContinuationToken' => '<p>The marker used to continue a metrics configuration listing that has been truncated. Use the <code>NextContinuationToken</code> from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.</p>', 'ListObjectsV2Output$NextContinuationToken' => '<p> <code>NextContinuationToken</code> is sent when <code>isTruncated</code> is true, which means there are more keys in the bucket that can be listed. The next list requests to Amazon S3 can be continued with this <code>NextContinuationToken</code>. <code>NextContinuationToken</code> is obfuscated and is not a real key</p>', ], ], 'NextUploadIdMarker' => [ 'base' => NULL, 'refs' => [ 'ListMultipartUploadsOutput$NextUploadIdMarker' => '<p>When a list is truncated, this element specifies the value that should be used for the <code>upload-id-marker</code> request parameter in a subsequent request.</p>', ], ], 'NextVersionIdMarker' => [ 'base' => NULL, 'refs' => [ 'ListObjectVersionsOutput$NextVersionIdMarker' => '<p>When the number of responses exceeds the value of <code>MaxKeys</code>, <code>NextVersionIdMarker</code> specifies the first object version not returned that satisfies the search criteria. Use this value for the version-id-marker request parameter in a subsequent request.</p>', ], ], 'NoSuchBucket' => [ 'base' => '<p>The specified bucket does not exist.</p>', 'refs' => [], ], 'NoSuchKey' => [ 'base' => '<p>The specified key does not exist.</p>', 'refs' => [], ], 'NoSuchUpload' => [ 'base' => '<p>The specified multipart upload does not exist.</p>', 'refs' => [], ], 'NoncurrentVersionExpiration' => [ 'base' => '<p>Specifies when noncurrent object versions expire. Upon expiration, Amazon S3 permanently deletes the noncurrent object versions. You set this lifecycle configuration action on a bucket that has versioning enabled (or suspended) to request that Amazon S3 delete noncurrent object versions at a specific period in the object\'s lifetime.</p>', 'refs' => [ 'LifecycleRule$NoncurrentVersionExpiration' => NULL, 'Rule$NoncurrentVersionExpiration' => NULL, ], ], 'NoncurrentVersionTransition' => [ 'base' => '<p>Container for the transition rule that describes when noncurrent objects transition to the <code>STANDARD_IA</code>, <code>ONEZONE_IA</code>, <code>INTELLIGENT_TIERING</code>, <code>GLACIER</code>, or <code>DEEP_ARCHIVE</code> storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to the <code>STANDARD_IA</code>, <code>ONEZONE_IA</code>, <code>INTELLIGENT_TIERING</code>, <code>GLACIER</code>, or <code>DEEP_ARCHIVE</code> storage class at a specific period in the object\'s lifetime.</p>', 'refs' => [ 'NoncurrentVersionTransitionList$member' => NULL, 'Rule$NoncurrentVersionTransition' => NULL, ], ], 'NoncurrentVersionTransitionList' => [ 'base' => NULL, 'refs' => [ 'LifecycleRule$NoncurrentVersionTransitions' => '<p> Specifies the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to a specific storage class at a set period in the object\'s lifetime. </p>', ], ], 'NotificationConfiguration' => [ 'base' => '<p>A container for specifying the notification configuration of the bucket. If this element is empty, notifications are turned off for the bucket.</p>', 'refs' => [ 'PutBucketNotificationConfigurationRequest$NotificationConfiguration' => NULL, ], ], 'NotificationConfigurationDeprecated' => [ 'base' => NULL, 'refs' => [ 'PutBucketNotificationRequest$NotificationConfiguration' => '<p>The container for the configuration.</p>', ], ], 'NotificationConfigurationFilter' => [ 'base' => '<p>Specifies object key name filtering rules. For information about key name filtering, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'refs' => [ 'LambdaFunctionConfiguration$Filter' => NULL, 'QueueConfiguration$Filter' => NULL, 'TopicConfiguration$Filter' => NULL, ], ], 'NotificationId' => [ 'base' => '<p>An optional unique identifier for configurations in a notification configuration. If you don\'t provide one, Amazon S3 will assign an ID.</p>', 'refs' => [ 'CloudFunctionConfiguration$Id' => NULL, 'LambdaFunctionConfiguration$Id' => NULL, 'QueueConfiguration$Id' => NULL, 'QueueConfigurationDeprecated$Id' => NULL, 'TopicConfiguration$Id' => NULL, 'TopicConfigurationDeprecated$Id' => NULL, ], ], 'Object' => [ 'base' => '<p>An object consists of data and its descriptive metadata.</p>', 'refs' => [ 'ObjectList$member' => NULL, ], ], 'ObjectAlreadyInActiveTierError' => [ 'base' => '<p>This operation is not allowed against this storage tier.</p>', 'refs' => [], ], 'ObjectCannedACL' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$ACL' => '<p>The canned ACL to apply to the object.</p>', 'CreateMultipartUploadRequest$ACL' => '<p>The canned ACL to apply to the object.</p>', 'PutObjectAclRequest$ACL' => '<p>The canned ACL to apply to the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.</p>', 'PutObjectRequest$ACL' => '<p>The canned ACL to apply to the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.</p>', 'S3Location$CannedACL' => '<p>The canned ACL to apply to the restore results.</p>', ], ], 'ObjectIdentifier' => [ 'base' => '<p>Object Identifier is unique value to identify objects.</p>', 'refs' => [ 'ObjectIdentifierList$member' => NULL, ], ], 'ObjectIdentifierList' => [ 'base' => NULL, 'refs' => [ 'Delete$Objects' => '<p>The objects to delete.</p>', ], ], 'ObjectKey' => [ 'base' => NULL, 'refs' => [ 'AbortMultipartUploadRequest$Key' => '<p>Key of the object for which the multipart upload was initiated.</p>', 'CompleteMultipartUploadOutput$Key' => '<p>The object key of the newly created object.</p>', 'CompleteMultipartUploadRequest$Key' => '<p>Object key for which the multipart upload was initiated.</p>', 'CopyObjectRequest$Key' => '<p>The key of the destination object.</p>', 'CreateMultipartUploadOutput$Key' => '<p>Object key for which the multipart upload was initiated.</p>', 'CreateMultipartUploadRequest$Key' => '<p>Object key for which the multipart upload is to be initiated.</p>', 'DeleteMarkerEntry$Key' => '<p>The object key.</p>', 'DeleteObjectRequest$Key' => '<p>Key name of the object to delete.</p>', 'DeleteObjectTaggingRequest$Key' => '<p>Name of the object key.</p>', 'DeletedObject$Key' => '<p>The name of the deleted object.</p>', 'Error$Key' => '<p>The error key.</p>', 'ErrorDocument$Key' => '<p>The object key name to use when a 4XX class error occurs.</p>', 'GetObjectAclRequest$Key' => '<p>The key of the object for which to get the ACL information.</p>', 'GetObjectLegalHoldRequest$Key' => '<p>The key name for the object whose Legal Hold status you want to retrieve.</p>', 'GetObjectRequest$Key' => '<p>Key of the object to get.</p>', 'GetObjectRetentionRequest$Key' => '<p>The key name for the object whose retention settings you want to retrieve.</p>', 'GetObjectTaggingRequest$Key' => '<p>Object key for which to get the tagging information.</p>', 'GetObjectTorrentRequest$Key' => '<p>The object key for which to get the information.</p>', 'HeadObjectRequest$Key' => '<p>The object key.</p>', 'ListPartsOutput$Key' => '<p>Object key for which the multipart upload was initiated.</p>', 'ListPartsRequest$Key' => '<p>Object key for which the multipart upload was initiated.</p>', 'MultipartUpload$Key' => '<p>Key of the object for which the multipart upload was initiated.</p>', 'Object$Key' => '<p>The name that you assign to an object. You use the object key to retrieve the object.</p>', 'ObjectIdentifier$Key' => '<p>Key name of the object to delete.</p>', 'ObjectVersion$Key' => '<p>The object key.</p>', 'PutObjectAclRequest$Key' => '<p>Key for which the PUT operation was initiated.</p>', 'PutObjectLegalHoldRequest$Key' => '<p>The key name for the object that you want to place a Legal Hold on.</p>', 'PutObjectRequest$Key' => '<p>Object key for which the PUT operation was initiated.</p>', 'PutObjectRetentionRequest$Key' => '<p>The key name for the object that you want to apply this Object Retention configuration to.</p>', 'PutObjectTaggingRequest$Key' => '<p>Name of the object key.</p>', 'RestoreObjectRequest$Key' => '<p>Object key for which the operation was initiated.</p>', 'SelectObjectContentRequest$Key' => '<p>The object key.</p>', 'Tag$Key' => '<p>Name of the object key.</p>', 'UploadPartCopyRequest$Key' => '<p>Object key for which the multipart upload was initiated.</p>', 'UploadPartRequest$Key' => '<p>Object key for which the multipart upload was initiated.</p>', ], ], 'ObjectList' => [ 'base' => NULL, 'refs' => [ 'ListObjectsOutput$Contents' => '<p>Metadata about each object returned.</p>', 'ListObjectsV2Output$Contents' => '<p>Metadata about each object returned.</p>', ], ], 'ObjectLockConfiguration' => [ 'base' => '<p>The container element for Object Lock configuration parameters.</p>', 'refs' => [ 'GetObjectLockConfigurationOutput$ObjectLockConfiguration' => '<p>The specified bucket\'s Object Lock configuration.</p>', 'PutObjectLockConfigurationRequest$ObjectLockConfiguration' => '<p>The Object Lock configuration that you want to apply to the specified bucket.</p>', ], ], 'ObjectLockEnabled' => [ 'base' => NULL, 'refs' => [ 'ObjectLockConfiguration$ObjectLockEnabled' => '<p>Indicates whether this bucket has an Object Lock configuration enabled.</p>', ], ], 'ObjectLockEnabledForBucket' => [ 'base' => NULL, 'refs' => [ 'CreateBucketRequest$ObjectLockEnabledForBucket' => '<p>Specifies whether you want S3 Object Lock to be enabled for the new bucket.</p>', ], ], 'ObjectLockLegalHold' => [ 'base' => '<p>A Legal Hold configuration for an object.</p>', 'refs' => [ 'GetObjectLegalHoldOutput$LegalHold' => '<p>The current Legal Hold status for the specified object.</p>', 'PutObjectLegalHoldRequest$LegalHold' => '<p>Container element for the Legal Hold configuration you want to apply to the specified object.</p>', ], ], 'ObjectLockLegalHoldStatus' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$ObjectLockLegalHoldStatus' => '<p>Specifies whether you want to apply a Legal Hold to the copied object.</p>', 'CreateMultipartUploadRequest$ObjectLockLegalHoldStatus' => '<p>Specifies whether you want to apply a Legal Hold to the uploaded object.</p>', 'GetObjectOutput$ObjectLockLegalHoldStatus' => '<p>Indicates whether this object has an active legal hold. This field is only returned if you have permission to view an object\'s legal hold status. </p>', 'HeadObjectOutput$ObjectLockLegalHoldStatus' => '<p>Specifies whether a legal hold is in effect for this object. This header is only returned if the requester has the <code>s3:GetObjectLegalHold</code> permission. This header is not returned if the specified version of this object has never had a legal hold applied. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Object Lock</a>.</p>', 'ObjectLockLegalHold$Status' => '<p>Indicates whether the specified object has a Legal Hold in place.</p>', 'PutObjectRequest$ObjectLockLegalHoldStatus' => '<p>Specifies whether a legal hold will be applied to this object. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Object Lock</a>.</p>', ], ], 'ObjectLockMode' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$ObjectLockMode' => '<p>The Object Lock mode that you want to apply to the copied object.</p>', 'CreateMultipartUploadRequest$ObjectLockMode' => '<p>Specifies the Object Lock mode that you want to apply to the uploaded object.</p>', 'GetObjectOutput$ObjectLockMode' => '<p>The Object Lock mode currently in place for this object.</p>', 'HeadObjectOutput$ObjectLockMode' => '<p>The Object Lock mode, if any, that\'s in effect for this object. This header is only returned if the requester has the <code>s3:GetObjectRetention</code> permission. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Object Lock</a>. </p>', 'PutObjectRequest$ObjectLockMode' => '<p>The Object Lock mode that you want to apply to this object.</p>', ], ], 'ObjectLockRetainUntilDate' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$ObjectLockRetainUntilDate' => '<p>The date and time when you want the copied object\'s Object Lock to expire.</p>', 'CreateMultipartUploadRequest$ObjectLockRetainUntilDate' => '<p>Specifies the date and time when you want the Object Lock to expire.</p>', 'GetObjectOutput$ObjectLockRetainUntilDate' => '<p>The date and time when this object\'s Object Lock will expire.</p>', 'HeadObjectOutput$ObjectLockRetainUntilDate' => '<p>The date and time when the Object Lock retention period expires. This header is only returned if the requester has the <code>s3:GetObjectRetention</code> permission.</p>', 'PutObjectRequest$ObjectLockRetainUntilDate' => '<p>The date and time when you want this object\'s Object Lock to expire.</p>', ], ], 'ObjectLockRetention' => [ 'base' => '<p>A Retention configuration for an object.</p>', 'refs' => [ 'GetObjectRetentionOutput$Retention' => '<p>The container element for an object\'s retention settings.</p>', 'PutObjectRetentionRequest$Retention' => '<p>The container element for the Object Retention configuration.</p>', ], ], 'ObjectLockRetentionMode' => [ 'base' => NULL, 'refs' => [ 'DefaultRetention$Mode' => '<p>The default Object Lock retention mode you want to apply to new objects placed in the specified bucket.</p>', 'ObjectLockRetention$Mode' => '<p>Indicates the Retention mode for the specified object.</p>', ], ], 'ObjectLockRule' => [ 'base' => '<p>The container element for an Object Lock rule.</p>', 'refs' => [ 'ObjectLockConfiguration$Rule' => '<p>The Object Lock rule in place for the specified object.</p>', ], ], 'ObjectLockToken' => [ 'base' => NULL, 'refs' => [ 'PutBucketReplicationRequest$Token' => '<p/>', 'PutObjectLockConfigurationRequest$Token' => '<p>A token to allow Object Lock to be enabled for an existing bucket.</p>', ], ], 'ObjectNotInActiveTierError' => [ 'base' => '<p>The source object of the COPY operation is not in the active tier and is only stored in Amazon S3 Glacier.</p>', 'refs' => [], ], 'ObjectStorageClass' => [ 'base' => NULL, 'refs' => [ 'Object$StorageClass' => '<p>The class of storage used to store the object.</p>', ], ], 'ObjectVersion' => [ 'base' => '<p>The version of an object.</p>', 'refs' => [ 'ObjectVersionList$member' => NULL, ], ], 'ObjectVersionId' => [ 'base' => NULL, 'refs' => [ 'CompleteMultipartUploadOutput$VersionId' => '<p>Version ID of the newly created object, in case the bucket has versioning turned on.</p>', 'CopyObjectOutput$VersionId' => '<p>Version ID of the newly created copy.</p>', 'DeleteMarkerEntry$VersionId' => '<p>Version ID of an object.</p>', 'DeleteObjectOutput$VersionId' => '<p>Returns the version ID of the delete marker created as a result of the DELETE operation.</p>', 'DeleteObjectRequest$VersionId' => '<p>VersionId used to reference a specific version of the object.</p>', 'DeleteObjectTaggingOutput$VersionId' => '<p>The versionId of the object the tag-set was removed from.</p>', 'DeleteObjectTaggingRequest$VersionId' => '<p>The versionId of the object that the tag-set will be removed from.</p>', 'DeletedObject$VersionId' => '<p>The version ID of the deleted object.</p>', 'Error$VersionId' => '<p>The version ID of the error.</p>', 'GetObjectAclRequest$VersionId' => '<p>VersionId used to reference a specific version of the object.</p>', 'GetObjectLegalHoldRequest$VersionId' => '<p>The version ID of the object whose Legal Hold status you want to retrieve.</p>', 'GetObjectOutput$VersionId' => '<p>Version of the object.</p>', 'GetObjectRequest$VersionId' => '<p>VersionId used to reference a specific version of the object.</p>', 'GetObjectRetentionRequest$VersionId' => '<p>The version ID for the object whose retention settings you want to retrieve.</p>', 'GetObjectTaggingOutput$VersionId' => '<p>The versionId of the object for which you got the tagging information.</p>', 'GetObjectTaggingRequest$VersionId' => '<p>The versionId of the object for which to get the tagging information.</p>', 'HeadObjectOutput$VersionId' => '<p>Version of the object.</p>', 'HeadObjectRequest$VersionId' => '<p>VersionId used to reference a specific version of the object.</p>', 'ObjectIdentifier$VersionId' => '<p>VersionId for the specific version of the object to delete.</p>', 'ObjectVersion$VersionId' => '<p>Version ID of an object.</p>', 'PutObjectAclRequest$VersionId' => '<p>VersionId used to reference a specific version of the object.</p>', 'PutObjectLegalHoldRequest$VersionId' => '<p>The version ID of the object that you want to place a Legal Hold on.</p>', 'PutObjectOutput$VersionId' => '<p>Version of the object.</p>', 'PutObjectRetentionRequest$VersionId' => '<p>The version ID for the object that you want to apply this Object Retention configuration to.</p>', 'PutObjectTaggingOutput$VersionId' => '<p>The versionId of the object the tag-set was added to.</p>', 'PutObjectTaggingRequest$VersionId' => '<p>The versionId of the object that the tag-set will be added to.</p>', 'RestoreObjectRequest$VersionId' => '<p>VersionId used to reference a specific version of the object.</p>', ], ], 'ObjectVersionList' => [ 'base' => NULL, 'refs' => [ 'ListObjectVersionsOutput$Versions' => '<p>Container for version information.</p>', ], ], 'ObjectVersionStorageClass' => [ 'base' => NULL, 'refs' => [ 'ObjectVersion$StorageClass' => '<p>The class of storage used to store the object.</p>', ], ], 'OutputLocation' => [ 'base' => '<p>Describes the location where the restore job\'s output is stored.</p>', 'refs' => [ 'RestoreRequest$OutputLocation' => '<p>Describes the location where the restore job\'s output is stored.</p>', ], ], 'OutputSerialization' => [ 'base' => '<p>Describes how results of the Select job are serialized.</p>', 'refs' => [ 'SelectObjectContentRequest$OutputSerialization' => '<p>Describes the format of the data that you want Amazon S3 to return in response.</p>', 'SelectParameters$OutputSerialization' => '<p>Describes how the results of the Select job are serialized.</p>', ], ], 'Owner' => [ 'base' => '<p>Container for the owner\'s display name and ID.</p>', 'refs' => [ 'AccessControlPolicy$Owner' => '<p>Container for the bucket owner\'s display name and ID.</p>', 'DeleteMarkerEntry$Owner' => '<p>The account that created the delete marker.&gt;</p>', 'GetBucketAclOutput$Owner' => '<p>Container for the bucket owner\'s display name and ID.</p>', 'GetObjectAclOutput$Owner' => '<p> Container for the bucket owner\'s display name and ID.</p>', 'ListBucketsOutput$Owner' => '<p>The owner of the buckets listed.</p>', 'ListPartsOutput$Owner' => '<p> Container element that identifies the object owner, after the object is created. If multipart upload is initiated by an IAM user, this element provides the parent account ID and display name.</p>', 'MultipartUpload$Owner' => '<p>Specifies the owner of the object that is part of the multipart upload. </p>', 'Object$Owner' => '<p>The owner of the object</p>', 'ObjectVersion$Owner' => '<p>Specifies the owner of the object.</p>', ], ], 'OwnerOverride' => [ 'base' => NULL, 'refs' => [ 'AccessControlTranslation$Owner' => '<p>Specifies the replica ownership. For default and valid values, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html">PUT bucket replication</a> in the <i>Amazon Simple Storage Service API Reference</i>.</p>', ], ], 'ParquetInput' => [ 'base' => '<p>Container for Parquet.</p>', 'refs' => [ 'InputSerialization$Parquet' => '<p>Specifies Parquet as object\'s input serialization format.</p>', ], ], 'Part' => [ 'base' => '<p>Container for elements related to a part.</p>', 'refs' => [ 'Parts$member' => NULL, ], ], 'PartNumber' => [ 'base' => NULL, 'refs' => [ 'CompletedPart$PartNumber' => '<p>Part number that identifies the part. This is a positive integer between 1 and 10,000.</p>', 'GetObjectRequest$PartNumber' => '<p>Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a \'ranged\' GET request for the part specified. Useful for downloading just a part of an object.</p>', 'HeadObjectRequest$PartNumber' => '<p>Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a \'ranged\' HEAD request for the part specified. Useful querying about the size of the part and the number of parts in this object.</p>', 'Part$PartNumber' => '<p>Part number identifying the part. This is a positive integer between 1 and 10,000.</p>', 'UploadPartCopyRequest$PartNumber' => '<p>Part number of part being copied. This is a positive integer between 1 and 10,000.</p>', 'UploadPartRequest$PartNumber' => '<p>Part number of part being uploaded. This is a positive integer between 1 and 10,000.</p>', ], ], 'PartNumberMarker' => [ 'base' => NULL, 'refs' => [ 'ListPartsOutput$PartNumberMarker' => '<p>When a list is truncated, this element specifies the last part in the list, as well as the value to use for the part-number-marker request parameter in a subsequent request.</p>', 'ListPartsRequest$PartNumberMarker' => '<p>Specifies the part after which listing should begin. Only parts with higher part numbers will be listed.</p>', ], ], 'Parts' => [ 'base' => NULL, 'refs' => [ 'ListPartsOutput$Parts' => '<p> Container for elements related to a particular part. A response can contain zero or more <code>Part</code> elements.</p>', ], ], 'PartsCount' => [ 'base' => NULL, 'refs' => [ 'GetObjectOutput$PartsCount' => '<p>The count of parts this object has.</p>', 'HeadObjectOutput$PartsCount' => '<p>The count of parts this object has.</p>', ], ], 'Payer' => [ 'base' => NULL, 'refs' => [ 'GetBucketRequestPaymentOutput$Payer' => '<p>Specifies who pays for the download and request fees.</p>', 'RequestPaymentConfiguration$Payer' => '<p>Specifies who pays for the download and request fees.</p>', ], ], 'Permission' => [ 'base' => NULL, 'refs' => [ 'Grant$Permission' => '<p>Specifies the permission given to the grantee.</p>', ], ], 'Policy' => [ 'base' => NULL, 'refs' => [ 'GetBucketPolicyOutput$Policy' => '<p>The bucket policy as a JSON document.</p>', 'PutBucketPolicyRequest$Policy' => '<p>The bucket policy as a JSON document.</p>', ], ], 'PolicyStatus' => [ 'base' => '<p>The container element for a bucket\'s policy status.</p>', 'refs' => [ 'GetBucketPolicyStatusOutput$PolicyStatus' => '<p>The policy status for the specified bucket.</p>', ], ], 'Prefix' => [ 'base' => NULL, 'refs' => [ 'AnalyticsAndOperator$Prefix' => '<p>The prefix to use when evaluating an AND predicate: The prefix that an object must have to be included in the metrics results.</p>', 'AnalyticsFilter$Prefix' => '<p>The prefix to use when evaluating an analytics filter.</p>', 'AnalyticsS3BucketDestination$Prefix' => '<p>The prefix to use when exporting data. The prefix is prepended to all results.</p>', 'CommonPrefix$Prefix' => '<p>Container for the specified common prefix.</p>', 'InventoryFilter$Prefix' => '<p>The prefix that an object must have to be included in the inventory results.</p>', 'InventoryS3BucketDestination$Prefix' => '<p>The prefix that is prepended to all inventory results.</p>', 'LifecycleRule$Prefix' => '<p>Prefix identifying one or more objects to which the rule applies. This is No longer used; use <code>Filter</code> instead.</p>', 'LifecycleRuleAndOperator$Prefix' => '<p>Prefix identifying one or more objects to which the rule applies.</p>', 'LifecycleRuleFilter$Prefix' => '<p>Prefix identifying one or more objects to which the rule applies.</p>', 'ListMultipartUploadsOutput$Prefix' => '<p>When a prefix is provided in the request, this field contains the specified prefix. The result contains only keys starting with the specified prefix.</p>', 'ListMultipartUploadsRequest$Prefix' => '<p>Lists in-progress uploads only for those keys that begin with the specified prefix. You can use prefixes to separate a bucket into different grouping of keys. (You can think of using prefix to make groups in the same way you\'d use a folder in a file system.)</p>', 'ListObjectVersionsOutput$Prefix' => '<p>Selects objects that start with the value supplied by this parameter.</p>', 'ListObjectVersionsRequest$Prefix' => '<p>Use this parameter to select only those keys that begin with the specified prefix. You can use prefixes to separate a bucket into different groupings of keys. (You can think of using prefix to make groups in the same way you\'d use a folder in a file system.) You can use prefix with delimiter to roll up numerous objects into a single result under CommonPrefixes. </p>', 'ListObjectsOutput$Prefix' => '<p>Keys that begin with the indicated prefix.</p>', 'ListObjectsRequest$Prefix' => '<p>Limits the response to keys that begin with the specified prefix.</p>', 'ListObjectsV2Output$Prefix' => '<p> Keys that begin with the indicated prefix.</p>', 'ListObjectsV2Request$Prefix' => '<p>Limits the response to keys that begin with the specified prefix.</p>', 'MetricsAndOperator$Prefix' => '<p>The prefix used when evaluating an AND predicate.</p>', 'MetricsFilter$Prefix' => '<p>The prefix used when evaluating a metrics filter.</p>', 'ReplicationRule$Prefix' => '<p>An object key name prefix that identifies the object or objects to which the rule applies. The maximum prefix length is 1,024 characters. To include all objects in a bucket, specify an empty string. </p>', 'ReplicationRuleAndOperator$Prefix' => '<p>An object key name prefix that identifies the subset of objects to which the rule applies.</p>', 'ReplicationRuleFilter$Prefix' => '<p>An object key name prefix that identifies the subset of objects to which the rule applies.</p>', 'Rule$Prefix' => '<p>Object key prefix that identifies one or more objects to which this rule applies.</p>', ], ], 'Priority' => [ 'base' => NULL, 'refs' => [ 'ReplicationRule$Priority' => '<p>The priority associated with the rule. If you specify multiple rules in a replication configuration, Amazon S3 prioritizes the rules to prevent conflicts when filtering. If two or more rules identify the same object based on a specified filter, the rule with higher priority takes precedence. For example:</p> <ul> <li> <p>Same object quality prefix-based filter criteria if prefixes you specified in multiple rules overlap </p> </li> <li> <p>Same object qualify tag-based filter criteria specified in multiple rules</p> </li> </ul> <p>For more information, see <a href=" https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html">Replication</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', ], ], 'Progress' => [ 'base' => '<p>This data type contains information about progress of an operation.</p>', 'refs' => [ 'ProgressEvent$Details' => '<p>The Progress event details.</p>', ], ], 'ProgressEvent' => [ 'base' => '<p>This data type contains information about the progress event of an operation.</p>', 'refs' => [ 'SelectObjectContentEventStream$Progress' => '<p>The Progress Event.</p>', ], ], 'Protocol' => [ 'base' => NULL, 'refs' => [ 'Redirect$Protocol' => '<p>Protocol to use when redirecting requests. The default is the protocol that is used in the original request.</p>', 'RedirectAllRequestsTo$Protocol' => '<p>Protocol to use when redirecting requests. The default is the protocol that is used in the original request.</p>', ], ], 'PublicAccessBlockConfiguration' => [ 'base' => '<p>The PublicAccessBlock configuration that you want to apply to this Amazon S3 bucket. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon Simple Storage Service Developer Guide</i>. </p>', 'refs' => [ 'GetPublicAccessBlockOutput$PublicAccessBlockConfiguration' => '<p>The <code>PublicAccessBlock</code> configuration currently in effect for this Amazon S3 bucket.</p>', 'PutPublicAccessBlockRequest$PublicAccessBlockConfiguration' => '<p>The <code>PublicAccessBlock</code> configuration that you want to apply to this Amazon S3 bucket. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', ], ], 'PutBucketAccelerateConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketAclRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketAnalyticsConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketCorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketEncryptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketInventoryConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketLifecycleConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketLifecycleRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketLoggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketMetricsConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketNotificationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketNotificationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketReplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketRequestPaymentRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketVersioningRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketWebsiteRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutObjectAclOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutObjectAclRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutObjectLegalHoldOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutObjectLegalHoldRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutObjectLockConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutObjectLockConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutObjectOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutObjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutObjectRetentionOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutObjectRetentionRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutObjectTaggingOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutObjectTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutPublicAccessBlockRequest' => [ 'base' => NULL, 'refs' => [], ], 'QueueArn' => [ 'base' => NULL, 'refs' => [ 'QueueConfiguration$QueueArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SQS queue to which Amazon S3 publishes a message when it detects events of the specified type.</p>', 'QueueConfigurationDeprecated$Queue' => '<p>The Amazon Resource Name (ARN) of the Amazon SQS queue to which Amazon S3 publishes a message when it detects events of the specified type. </p>', ], ], 'QueueConfiguration' => [ 'base' => '<p>Specifies the configuration for publishing messages to an Amazon Simple Queue Service (Amazon SQS) queue when Amazon S3 detects specified events.</p>', 'refs' => [ 'QueueConfigurationList$member' => NULL, ], ], 'QueueConfigurationDeprecated' => [ 'base' => '<p>This data type is deprecated. Use <a>QueueConfiguration</a> for the same purposes. This data type specifies the configuration for publishing messages to an Amazon Simple Queue Service (Amazon SQS) queue when Amazon S3 detects specified events. </p>', 'refs' => [ 'NotificationConfigurationDeprecated$QueueConfiguration' => '<p>This data type is deprecated. This data type specifies the configuration for publishing messages to an Amazon Simple Queue Service (Amazon SQS) queue when Amazon S3 detects specified events. </p>', ], ], 'QueueConfigurationList' => [ 'base' => NULL, 'refs' => [ 'NotificationConfiguration$QueueConfigurations' => '<p>The Amazon Simple Queue Service queues to publish messages to and the events for which to publish messages.</p>', ], ], 'Quiet' => [ 'base' => NULL, 'refs' => [ 'Delete$Quiet' => '<p>Element to enable quiet mode for the request. When you add this element, you must set its value to true.</p>', ], ], 'QuoteCharacter' => [ 'base' => NULL, 'refs' => [ 'CSVInput$QuoteCharacter' => '<p>A single character used for escaping when the field delimiter is part of the value. For example, if the value is <code>a, b</code>, Amazon S3 wraps this field value in quotation marks, as follows: <code>" a , b "</code>.</p> <p>Type: String</p> <p>Default: <code>"</code> </p> <p>Ancestors: <code>CSV</code> </p>', 'CSVOutput$QuoteCharacter' => '<p>A single character used for escaping when the field delimiter is part of the value. For example, if the value is <code>a, b</code>, Amazon S3 wraps this field value in quotation marks, as follows: <code>" a , b "</code>.</p>', ], ], 'QuoteEscapeCharacter' => [ 'base' => NULL, 'refs' => [ 'CSVInput$QuoteEscapeCharacter' => '<p>A single character used for escaping the quotation mark character inside an already escaped value. For example, the value """ a , b """ is parsed as " a , b ".</p>', 'CSVOutput$QuoteEscapeCharacter' => '<p>The single character used for escaping the quote character inside an already escaped value.</p>', ], ], 'QuoteFields' => [ 'base' => NULL, 'refs' => [ 'CSVOutput$QuoteFields' => '<p>Indicates whether to use quotation marks around output fields. </p> <ul> <li> <p> <code>ALWAYS</code>: Always use quotation marks for output fields.</p> </li> <li> <p> <code>ASNEEDED</code>: Use quotation marks for output fields when needed.</p> </li> </ul>', ], ], 'Range' => [ 'base' => NULL, 'refs' => [ 'GetObjectRequest$Range' => '<p>Downloads the specified range bytes of an object. For more information about the HTTP Range header, see <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35">https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35</a>.</p> <note> <p>Amazon S3 doesn\'t support retrieving multiple ranges of data per <code>GET</code> request.</p> </note>', 'HeadObjectRequest$Range' => '<p>Downloads the specified range bytes of an object. For more information about the HTTP Range header, see <a href="">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35</a>.</p> <note> <p>Amazon S3 doesn\'t support retrieving multiple ranges of data per <code>GET</code> request.</p> </note>', ], ], 'RecordDelimiter' => [ 'base' => NULL, 'refs' => [ 'CSVInput$RecordDelimiter' => '<p>A single character used to separate individual records in the input. Instead of the default value, you can specify an arbitrary delimiter.</p>', 'CSVOutput$RecordDelimiter' => '<p>A single character used to separate individual records in the output. Instead of the default value, you can specify an arbitrary delimiter.</p>', 'JSONOutput$RecordDelimiter' => '<p>The value used to separate individual records in the output. If no value is specified, Amazon S3 uses a newline character (\'\\n\').</p>', ], ], 'RecordsEvent' => [ 'base' => '<p>The container for the records event.</p>', 'refs' => [ 'SelectObjectContentEventStream$Records' => '<p>The Records Event.</p>', ], ], 'Redirect' => [ 'base' => '<p>Specifies how requests are redirected. In the event of an error, you can specify a different error code to return.</p>', 'refs' => [ 'RoutingRule$Redirect' => '<p>Container for redirect information. You can redirect requests to another host, to another page, or with another protocol. In the event of an error, you can specify a different error code to return.</p>', ], ], 'RedirectAllRequestsTo' => [ 'base' => '<p>Specifies the redirect behavior of all requests to a website endpoint of an Amazon S3 bucket.</p>', 'refs' => [ 'GetBucketWebsiteOutput$RedirectAllRequestsTo' => '<p>Specifies the redirect behavior of all requests to a website endpoint of an Amazon S3 bucket.</p>', 'WebsiteConfiguration$RedirectAllRequestsTo' => '<p>The redirect behavior for every request to this bucket\'s website endpoint.</p> <important> <p>If you specify this property, you can\'t specify any other property.</p> </important>', ], ], 'ReplaceKeyPrefixWith' => [ 'base' => NULL, 'refs' => [ 'Redirect$ReplaceKeyPrefixWith' => '<p>The object key prefix to use in the redirect request. For example, to redirect requests for all pages with prefix <code>docs/</code> (objects in the <code>docs/</code> folder) to <code>documents/</code>, you can set a condition block with <code>KeyPrefixEquals</code> set to <code>docs/</code> and in the Redirect set <code>ReplaceKeyPrefixWith</code> to <code>/documents</code>. Not required if one of the siblings is present. Can be present only if <code>ReplaceKeyWith</code> is not provided.</p>', ], ], 'ReplaceKeyWith' => [ 'base' => NULL, 'refs' => [ 'Redirect$ReplaceKeyWith' => '<p>The specific object key to use in the redirect request. For example, redirect request to <code>error.html</code>. Not required if one of the siblings is present. Can be present only if <code>ReplaceKeyPrefixWith</code> is not provided.</p>', ], ], 'ReplicaKmsKeyID' => [ 'base' => NULL, 'refs' => [ 'EncryptionConfiguration$ReplicaKmsKeyID' => '<p>Specifies the ID (Key ARN or Alias ARN) of the customer managed customer master key (CMK) stored in AWS Key Management Service (KMS) for the destination bucket. Amazon S3 uses this key to encrypt replica objects. Amazon S3 only supports symmetric customer managed CMKs. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and Asymmetric Keys</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', ], ], 'ReplicationConfiguration' => [ 'base' => '<p>A container for replication rules. You can add up to 1,000 rules. The maximum size of a replication configuration is 2 MB.</p>', 'refs' => [ 'GetBucketReplicationOutput$ReplicationConfiguration' => NULL, 'PutBucketReplicationRequest$ReplicationConfiguration' => NULL, ], ], 'ReplicationRule' => [ 'base' => '<p>Specifies which Amazon S3 objects to replicate and where to store the replicas.</p>', 'refs' => [ 'ReplicationRules$member' => NULL, ], ], 'ReplicationRuleAndOperator' => [ 'base' => '<p>A container for specifying rule filters. The filters determine the subset of objects to which the rule applies. This element is required only if you specify more than one filter. </p> <p>For example:</p> <ul> <li> <p>If you specify both a <code>Prefix</code> and a <code>Tag</code> filter, wrap these filters in an <code>And</code> tag. </p> </li> <li> <p>If you specify a filter based on multiple tags, wrap the <code>Tag</code> elements in an <code>And</code> tag</p> </li> </ul>', 'refs' => [ 'ReplicationRuleFilter$And' => '<p>A container for specifying rule filters. The filters determine the subset of objects to which the rule applies. This element is required only if you specify more than one filter. For example: </p> <ul> <li> <p>If you specify both a <code>Prefix</code> and a <code>Tag</code> filter, wrap these filters in an <code>And</code> tag.</p> </li> <li> <p>If you specify a filter based on multiple tags, wrap the <code>Tag</code> elements in an <code>And</code> tag.</p> </li> </ul>', ], ], 'ReplicationRuleFilter' => [ 'base' => '<p>A filter that identifies the subset of objects to which the replication rule applies. A <code>Filter</code> must specify exactly one <code>Prefix</code>, <code>Tag</code>, or an <code>And</code> child element.</p>', 'refs' => [ 'ReplicationRule$Filter' => NULL, ], ], 'ReplicationRuleStatus' => [ 'base' => NULL, 'refs' => [ 'ReplicationRule$Status' => '<p>Specifies whether the rule is enabled.</p>', ], ], 'ReplicationRules' => [ 'base' => NULL, 'refs' => [ 'ReplicationConfiguration$Rules' => '<p>A container for one or more replication rules. A replication configuration must have at least one rule and can contain a maximum of 1,000 rules. </p>', ], ], 'ReplicationStatus' => [ 'base' => NULL, 'refs' => [ 'GetObjectOutput$ReplicationStatus' => '<p>Amazon S3 can return this if your request involves a bucket that is either a source or destination in a replication rule.</p>', 'HeadObjectOutput$ReplicationStatus' => '<p>Amazon S3 can return this header if your request involves a bucket that is either a source or destination in a replication rule.</p> <p>In replication, you have a source bucket on which you configure replication and destination bucket where Amazon S3 stores object replicas. When you request an object (<code>GetObject</code>) or object metadata (<code>HeadObject</code>) from these buckets, Amazon S3 will return the <code>x-amz-replication-status</code> header in the response as follows:</p> <ul> <li> <p>If requesting an object from the source bucket — Amazon S3 will return the <code>x-amz-replication-status</code> header if the object in your request is eligible for replication.</p> <p> For example, suppose that in your replication configuration, you specify object prefix <code>TaxDocs</code> requesting Amazon S3 to replicate objects with key prefix <code>TaxDocs</code>. Any objects you upload with this key name prefix, for example <code>TaxDocs/document1.pdf</code>, are eligible for replication. For any object request with this key name prefix, Amazon S3 will return the <code>x-amz-replication-status</code> header with value PENDING, COMPLETED or FAILED indicating object replication status.</p> </li> <li> <p>If requesting an object from the destination bucket — Amazon S3 will return the <code>x-amz-replication-status</code> header with value REPLICA if the object in your request is a replica that Amazon S3 created.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Replication</a>.</p>', ], ], 'ReplicationTime' => [ 'base' => '<p> A container specifying S3 Replication Time Control (S3 RTC) related information, including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated. Must be specified together with a <code>Metrics</code> block. </p>', 'refs' => [ 'Destination$ReplicationTime' => '<p> A container specifying S3 Replication Time Control (S3 RTC), including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated. Must be specified together with a <code>Metrics</code> block. </p>', ], ], 'ReplicationTimeStatus' => [ 'base' => NULL, 'refs' => [ 'ReplicationTime$Status' => '<p> Specifies whether the replication time is enabled. </p>', ], ], 'ReplicationTimeValue' => [ 'base' => '<p> A container specifying the time value for S3 Replication Time Control (S3 RTC) and replication metrics <code>EventThreshold</code>. </p>', 'refs' => [ 'Metrics$EventThreshold' => '<p> A container specifying the time threshold for emitting the <code>s3:Replication:OperationMissedThreshold</code> event. </p>', 'ReplicationTime$Time' => '<p> A container specifying the time by which replication should be complete for all objects and operations on objects. </p>', ], ], 'RequestCharged' => [ 'base' => '<p>If present, indicates that the requester was successfully charged for the request.</p>', 'refs' => [ 'AbortMultipartUploadOutput$RequestCharged' => NULL, 'CompleteMultipartUploadOutput$RequestCharged' => NULL, 'CopyObjectOutput$RequestCharged' => NULL, 'CreateMultipartUploadOutput$RequestCharged' => NULL, 'DeleteObjectOutput$RequestCharged' => NULL, 'DeleteObjectsOutput$RequestCharged' => NULL, 'GetObjectAclOutput$RequestCharged' => NULL, 'GetObjectOutput$RequestCharged' => NULL, 'GetObjectTorrentOutput$RequestCharged' => NULL, 'HeadObjectOutput$RequestCharged' => NULL, 'ListPartsOutput$RequestCharged' => NULL, 'PutObjectAclOutput$RequestCharged' => NULL, 'PutObjectLegalHoldOutput$RequestCharged' => NULL, 'PutObjectLockConfigurationOutput$RequestCharged' => NULL, 'PutObjectOutput$RequestCharged' => NULL, 'PutObjectRetentionOutput$RequestCharged' => NULL, 'RestoreObjectOutput$RequestCharged' => NULL, 'UploadPartCopyOutput$RequestCharged' => NULL, 'UploadPartOutput$RequestCharged' => NULL, ], ], 'RequestPayer' => [ 'base' => '<p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 Developer Guide</i>.</p>', 'refs' => [ 'AbortMultipartUploadRequest$RequestPayer' => NULL, 'CompleteMultipartUploadRequest$RequestPayer' => NULL, 'CopyObjectRequest$RequestPayer' => NULL, 'CreateMultipartUploadRequest$RequestPayer' => NULL, 'DeleteObjectRequest$RequestPayer' => NULL, 'DeleteObjectsRequest$RequestPayer' => NULL, 'GetObjectAclRequest$RequestPayer' => NULL, 'GetObjectLegalHoldRequest$RequestPayer' => NULL, 'GetObjectRequest$RequestPayer' => NULL, 'GetObjectRetentionRequest$RequestPayer' => NULL, 'GetObjectTorrentRequest$RequestPayer' => NULL, 'HeadObjectRequest$RequestPayer' => NULL, 'ListObjectsRequest$RequestPayer' => '<p>Confirms that the requester knows that she or he will be charged for the list objects request. Bucket owners need not specify this parameter in their requests.</p>', 'ListObjectsV2Request$RequestPayer' => '<p>Confirms that the requester knows that she or he will be charged for the list objects request in V2 style. Bucket owners need not specify this parameter in their requests.</p>', 'ListPartsRequest$RequestPayer' => NULL, 'PutObjectAclRequest$RequestPayer' => NULL, 'PutObjectLegalHoldRequest$RequestPayer' => NULL, 'PutObjectLockConfigurationRequest$RequestPayer' => NULL, 'PutObjectRequest$RequestPayer' => NULL, 'PutObjectRetentionRequest$RequestPayer' => NULL, 'RestoreObjectRequest$RequestPayer' => NULL, 'UploadPartCopyRequest$RequestPayer' => NULL, 'UploadPartRequest$RequestPayer' => NULL, ], ], 'RequestPaymentConfiguration' => [ 'base' => '<p>Container for Payer.</p>', 'refs' => [ 'PutBucketRequestPaymentRequest$RequestPaymentConfiguration' => '<p>Container for Payer.</p>', ], ], 'RequestProgress' => [ 'base' => '<p>Container for specifying if periodic <code>QueryProgress</code> messages should be sent.</p>', 'refs' => [ 'SelectObjectContentRequest$RequestProgress' => '<p>Specifies if periodic request progress information should be enabled.</p>', ], ], 'ResponseCacheControl' => [ 'base' => NULL, 'refs' => [ 'GetObjectRequest$ResponseCacheControl' => '<p>Sets the <code>Cache-Control</code> header of the response.</p>', ], ], 'ResponseContentDisposition' => [ 'base' => NULL, 'refs' => [ 'GetObjectRequest$ResponseContentDisposition' => '<p>Sets the <code>Content-Disposition</code> header of the response</p>', ], ], 'ResponseContentEncoding' => [ 'base' => NULL, 'refs' => [ 'GetObjectRequest$ResponseContentEncoding' => '<p>Sets the <code>Content-Encoding</code> header of the response.</p>', ], ], 'ResponseContentLanguage' => [ 'base' => NULL, 'refs' => [ 'GetObjectRequest$ResponseContentLanguage' => '<p>Sets the <code>Content-Language</code> header of the response.</p>', ], ], 'ResponseContentType' => [ 'base' => NULL, 'refs' => [ 'GetObjectRequest$ResponseContentType' => '<p>Sets the <code>Content-Type</code> header of the response.</p>', ], ], 'ResponseExpires' => [ 'base' => NULL, 'refs' => [ 'GetObjectRequest$ResponseExpires' => '<p>Sets the <code>Expires</code> header of the response.</p>', ], ], 'Restore' => [ 'base' => NULL, 'refs' => [ 'GetObjectOutput$Restore' => '<p>Provides information about object restoration operation and expiration time of the restored object copy.</p>', 'HeadObjectOutput$Restore' => '<p>If the object is an archived object (an object whose storage class is GLACIER), the response includes this header if either the archive restoration is in progress (see <a>RestoreObject</a> or an archive copy is already restored.</p> <p> If an archive copy is already restored, the header value indicates when Amazon S3 is scheduled to delete the object copy. For example:</p> <p> <code>x-amz-restore: ongoing-request="false", expiry-date="Fri, 23 Dec 2012 00:00:00 GMT"</code> </p> <p>If the object restoration is in progress, the header returns the value <code>ongoing-request="true"</code>.</p> <p>For more information about archiving objects, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html#lifecycle-transition-general-considerations">Transitioning Objects: General Considerations</a>.</p>', ], ], 'RestoreObjectOutput' => [ 'base' => NULL, 'refs' => [], ], 'RestoreObjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'RestoreOutputPath' => [ 'base' => NULL, 'refs' => [ 'RestoreObjectOutput$RestoreOutputPath' => '<p>Indicates the path in the provided S3 output location where Select results will be restored to.</p>', ], ], 'RestoreRequest' => [ 'base' => '<p>Container for restore job parameters.</p>', 'refs' => [ 'RestoreObjectRequest$RestoreRequest' => NULL, ], ], 'RestoreRequestType' => [ 'base' => NULL, 'refs' => [ 'RestoreRequest$Type' => '<p>Type of restore request.</p>', ], ], 'Role' => [ 'base' => NULL, 'refs' => [ 'ReplicationConfiguration$Role' => '<p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that Amazon S3 assumes when replicating objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-how-setup.html">How to Set Up Replication</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', ], ], 'RoutingRule' => [ 'base' => '<p>Specifies the redirect behavior and when a redirect is applied.</p>', 'refs' => [ 'RoutingRules$member' => NULL, ], ], 'RoutingRules' => [ 'base' => NULL, 'refs' => [ 'GetBucketWebsiteOutput$RoutingRules' => '<p>Rules that define when a redirect is applied and the redirect behavior.</p>', 'WebsiteConfiguration$RoutingRules' => '<p>Rules that define when a redirect is applied and the redirect behavior.</p>', ], ], 'Rule' => [ 'base' => '<p>Specifies lifecycle rules for an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlifecycle.html">Put Bucket Lifecycle Configuration</a> in the <i>Amazon Simple Storage Service API Reference</i>. For examples, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html#API_PutBucketLifecycleConfiguration_Examples">Put Bucket Lifecycle Configuration Examples</a> </p>', 'refs' => [ 'Rules$member' => NULL, ], ], 'Rules' => [ 'base' => NULL, 'refs' => [ 'GetBucketLifecycleOutput$Rules' => '<p>Container for a lifecycle rule.</p>', 'LifecycleConfiguration$Rules' => '<p>Specifies lifecycle configuration rules for an Amazon S3 bucket. </p>', ], ], 'S3KeyFilter' => [ 'base' => '<p>A container for object key name prefix and suffix filtering rules.</p>', 'refs' => [ 'NotificationConfigurationFilter$Key' => NULL, ], ], 'S3Location' => [ 'base' => '<p>Describes an Amazon S3 location that will receive the results of the restore request.</p>', 'refs' => [ 'OutputLocation$S3' => '<p>Describes an S3 location that will receive the results of the restore request.</p>', ], ], 'SSECustomerAlgorithm' => [ 'base' => NULL, 'refs' => [ 'CopyObjectOutput$SSECustomerAlgorithm' => '<p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header confirming the encryption algorithm used.</p>', 'CopyObjectRequest$SSECustomerAlgorithm' => '<p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>', 'CreateMultipartUploadOutput$SSECustomerAlgorithm' => '<p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header confirming the encryption algorithm used.</p>', 'CreateMultipartUploadRequest$SSECustomerAlgorithm' => '<p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>', 'GetObjectOutput$SSECustomerAlgorithm' => '<p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header confirming the encryption algorithm used.</p>', 'GetObjectRequest$SSECustomerAlgorithm' => '<p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>', 'HeadObjectOutput$SSECustomerAlgorithm' => '<p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header confirming the encryption algorithm used.</p>', 'HeadObjectRequest$SSECustomerAlgorithm' => '<p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>', 'PutObjectOutput$SSECustomerAlgorithm' => '<p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header confirming the encryption algorithm used.</p>', 'PutObjectRequest$SSECustomerAlgorithm' => '<p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>', 'SelectObjectContentRequest$SSECustomerAlgorithm' => '<p>The SSE Algorithm used to encrypt the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Server-Side Encryption (Using Customer-Provided Encryption Keys</a>. </p>', 'UploadPartCopyOutput$SSECustomerAlgorithm' => '<p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header confirming the encryption algorithm used.</p>', 'UploadPartCopyRequest$SSECustomerAlgorithm' => '<p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>', 'UploadPartOutput$SSECustomerAlgorithm' => '<p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header confirming the encryption algorithm used.</p>', 'UploadPartRequest$SSECustomerAlgorithm' => '<p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>', ], ], 'SSECustomerKey' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$SSECustomerKey' => '<p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side​-encryption​-customer-algorithm</code> header.</p>', 'CreateMultipartUploadRequest$SSECustomerKey' => '<p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side​-encryption​-customer-algorithm</code> header.</p>', 'GetObjectRequest$SSECustomerKey' => '<p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side​-encryption​-customer-algorithm</code> header.</p>', 'HeadObjectRequest$SSECustomerKey' => '<p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side​-encryption​-customer-algorithm</code> header.</p>', 'PutObjectRequest$SSECustomerKey' => '<p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side​-encryption​-customer-algorithm</code> header.</p>', 'SelectObjectContentRequest$SSECustomerKey' => '<p>The SSE Customer Key. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Server-Side Encryption (Using Customer-Provided Encryption Keys</a>. </p>', 'UploadPartCopyRequest$SSECustomerKey' => '<p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side​-encryption​-customer-algorithm</code> header. This must be the same encryption key specified in the initiate multipart upload request.</p>', 'UploadPartRequest$SSECustomerKey' => '<p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side​-encryption​-customer-algorithm header</code>. This must be the same encryption key specified in the initiate multipart upload request.</p>', ], ], 'SSECustomerKeyMD5' => [ 'base' => NULL, 'refs' => [ 'CopyObjectOutput$SSECustomerKeyMD5' => '<p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide round-trip message integrity verification of the customer-provided encryption key.</p>', 'CopyObjectRequest$SSECustomerKeyMD5' => '<p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>', 'CreateMultipartUploadOutput$SSECustomerKeyMD5' => '<p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide round-trip message integrity verification of the customer-provided encryption key.</p>', 'CreateMultipartUploadRequest$SSECustomerKeyMD5' => '<p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>', 'GetObjectOutput$SSECustomerKeyMD5' => '<p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide round-trip message integrity verification of the customer-provided encryption key.</p>', 'GetObjectRequest$SSECustomerKeyMD5' => '<p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>', 'HeadObjectOutput$SSECustomerKeyMD5' => '<p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide round-trip message integrity verification of the customer-provided encryption key.</p>', 'HeadObjectRequest$SSECustomerKeyMD5' => '<p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>', 'PutObjectOutput$SSECustomerKeyMD5' => '<p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide round-trip message integrity verification of the customer-provided encryption key.</p>', 'PutObjectRequest$SSECustomerKeyMD5' => '<p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>', 'SelectObjectContentRequest$SSECustomerKeyMD5' => '<p>The SSE Customer Key MD5. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Server-Side Encryption (Using Customer-Provided Encryption Keys</a>. </p>', 'UploadPartCopyOutput$SSECustomerKeyMD5' => '<p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide round-trip message integrity verification of the customer-provided encryption key.</p>', 'UploadPartCopyRequest$SSECustomerKeyMD5' => '<p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>', 'UploadPartOutput$SSECustomerKeyMD5' => '<p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide round-trip message integrity verification of the customer-provided encryption key.</p>', 'UploadPartRequest$SSECustomerKeyMD5' => '<p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>', ], ], 'SSEKMS' => [ 'base' => '<p>Specifies the use of SSE-KMS to encrypt delivered inventory reports.</p>', 'refs' => [ 'InventoryEncryption$SSEKMS' => '<p>Specifies the use of SSE-KMS to encrypt delivered inventory reports.</p>', ], ], 'SSEKMSEncryptionContext' => [ 'base' => NULL, 'refs' => [ 'CopyObjectOutput$SSEKMSEncryptionContext' => '<p>If present, specifies the AWS KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>', 'CopyObjectRequest$SSEKMSEncryptionContext' => '<p>Specifies the AWS KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>', 'CreateMultipartUploadOutput$SSEKMSEncryptionContext' => '<p>If present, specifies the AWS KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>', 'CreateMultipartUploadRequest$SSEKMSEncryptionContext' => '<p>Specifies the AWS KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>', 'PutObjectOutput$SSEKMSEncryptionContext' => '<p>If present, specifies the AWS KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>', 'PutObjectRequest$SSEKMSEncryptionContext' => '<p>Specifies the AWS KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>', ], ], 'SSEKMSKeyId' => [ 'base' => NULL, 'refs' => [ 'CompleteMultipartUploadOutput$SSEKMSKeyId' => '<p>If present, specifies the ID of the AWS Key Management Service (AWS KMS) symmetric customer managed customer master key (CMK) that was used for the object.</p>', 'CopyObjectOutput$SSEKMSKeyId' => '<p>If present, specifies the ID of the AWS Key Management Service (AWS KMS) symmetric customer managed customer master key (CMK) that was used for the object.</p>', 'CopyObjectRequest$SSEKMSKeyId' => '<p>Specifies the AWS KMS key ID to use for object encryption. All GET and PUT requests for an object protected by AWS KMS will fail if not made via SSL or using SigV4. For information about configuring using any of the officially supported AWS SDKs and AWS CLI, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version">Specifying the Signature Version in Request Authentication</a> in the <i>Amazon S3 Developer Guide</i>.</p>', 'CreateMultipartUploadOutput$SSEKMSKeyId' => '<p>If present, specifies the ID of the AWS Key Management Service (AWS KMS) symmetric customer managed customer master key (CMK) that was used for the object.</p>', 'CreateMultipartUploadRequest$SSEKMSKeyId' => '<p>Specifies the ID of the symmetric customer managed AWS KMS CMK to use for object encryption. All GET and PUT requests for an object protected by AWS KMS will fail if not made via SSL or using SigV4. For information about configuring using any of the officially supported AWS SDKs and AWS CLI, see <a href="https://docs.aws.amazon.com/http:/docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version">Specifying the Signature Version in Request Authentication</a> in the <i>Amazon S3 Developer Guide</i>.</p>', 'Encryption$KMSKeyId' => '<p>If the encryption type is <code>aws:kms</code>, this optional value specifies the ID of the symmetric customer managed AWS KMS CMK to use for encryption of job results. Amazon S3 only supports symmetric CMKs. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and Asymmetric Keys</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'GetObjectOutput$SSEKMSKeyId' => '<p>If present, specifies the ID of the AWS Key Management Service (AWS KMS) symmetric customer managed customer master key (CMK) that was used for the object.</p>', 'HeadObjectOutput$SSEKMSKeyId' => '<p>If present, specifies the ID of the AWS Key Management Service (AWS KMS) symmetric customer managed customer master key (CMK) that was used for the object.</p>', 'PutObjectOutput$SSEKMSKeyId' => '<p>If <code>x-amz-server-side-encryption</code> is present and has the value of <code>aws:kms</code>, this header specifies the ID of the AWS Key Management Service (AWS KMS) symmetric customer managed customer master key (CMK) that was used for the object. </p>', 'PutObjectRequest$SSEKMSKeyId' => '<p>If <code>x-amz-server-side-encryption</code> is present and has the value of <code>aws:kms</code>, this header specifies the ID of the AWS Key Management Service (AWS KMS) symmetrical customer managed customer master key (CMK) that was used for the object.</p> <p> If the value of <code>x-amz-server-side-encryption</code> is <code>aws:kms</code>, this header specifies the ID of the symmetric customer managed AWS KMS CMK that will be used for the object. If you specify <code>x-amz-server-side-encryption:aws:kms</code>, but do not provide<code> x-amz-server-side-encryption-aws-kms-key-id</code>, Amazon S3 uses the AWS managed CMK in AWS to protect the data.</p>', 'SSEKMS$KeyId' => '<p>Specifies the ID of the AWS Key Management Service (AWS KMS) symmetric customer managed customer master key (CMK) to use for encrypting inventory reports.</p>', 'ServerSideEncryptionByDefault$KMSMasterKeyID' => '<p>AWS Key Management Service (KMS) customer master key ID to use for the default encryption. This parameter is allowed if and only if <code>SSEAlgorithm</code> is set to <code>aws:kms</code>.</p> <p>You can specify the key ID or the Amazon Resource Name (ARN) of the CMK. However, if you are using encryption with cross-account operations, you must use a fully qualified CMK ARN. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html#bucket-encryption-update-bucket-policy">Using encryption for cross-account operations</a>. </p> <p> <b>For example:</b> </p> <ul> <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> </ul> <important> <p>Amazon S3 only supports symmetric CMKs and not asymmetric CMKs. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and Asymmetric Keys</a> in the <i>AWS Key Management Service Developer Guide</i>.</p> </important>', 'UploadPartCopyOutput$SSEKMSKeyId' => '<p>If present, specifies the ID of the AWS Key Management Service (AWS KMS) symmetric customer managed customer master key (CMK) that was used for the object.</p>', 'UploadPartOutput$SSEKMSKeyId' => '<p>If present, specifies the ID of the AWS Key Management Service (AWS KMS) symmetric customer managed customer master key (CMK) was used for the object.</p>', ], ], 'SSES3' => [ 'base' => '<p>Specifies the use of SSE-S3 to encrypt delivered inventory reports.</p>', 'refs' => [ 'InventoryEncryption$SSES3' => '<p>Specifies the use of SSE-S3 to encrypt delivered inventory reports.</p>', ], ], 'ScanRange' => [ 'base' => '<p>Specifies the byte range of the object to get the records from. A record is processed when its first byte is contained by the range. This parameter is optional, but when specified, it must not be empty. See RFC 2616, Section 14.35.1 about how to specify the start and end of the range.</p>', 'refs' => [ 'SelectObjectContentRequest$ScanRange' => '<p>Specifies the byte range of the object to get the records from. A record is processed when its first byte is contained by the range. This parameter is optional, but when specified, it must not be empty. See RFC 2616, Section 14.35.1 about how to specify the start and end of the range.</p> <p> <code>ScanRange</code>may be used in the following ways:</p> <ul> <li> <p> <code>&lt;scanrange&gt;&lt;start&gt;50&lt;/start&gt;&lt;end&gt;100&lt;/end&gt;&lt;/scanrange&gt;</code> - process only the records starting between the bytes 50 and 100 (inclusive, counting from zero)</p> </li> <li> <p> <code>&lt;scanrange&gt;&lt;start&gt;50&lt;/start&gt;&lt;/scanrange&gt;</code> - process only the records starting after the byte 50</p> </li> <li> <p> <code>&lt;scanrange&gt;&lt;end&gt;50&lt;/end&gt;&lt;/scanrange&gt;</code> - process only the records within the last 50 bytes of the file.</p> </li> </ul>', ], ], 'SelectObjectContentEventStream' => [ 'base' => '<p>The container for selecting objects from a content event stream.</p>', 'refs' => [ 'SelectObjectContentOutput$Payload' => '<p>The array of results.</p>', ], ], 'SelectObjectContentOutput' => [ 'base' => NULL, 'refs' => [], ], 'SelectObjectContentRequest' => [ 'base' => '<p>Request to filter the contents of an Amazon S3 object based on a simple Structured Query Language (SQL) statement. In the request, along with the SQL expression, you must specify a data serialization format (JSON or CSV) of the object. Amazon S3 uses this to parse object data into records. It returns only records that match the specified SQL expression. You must also specify the data serialization format for the response. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectSELECTContent.html">S3Select API Documentation</a>.</p>', 'refs' => [], ], 'SelectParameters' => [ 'base' => '<p>Describes the parameters for Select job types.</p>', 'refs' => [ 'RestoreRequest$SelectParameters' => '<p>Describes the parameters for Select job types.</p>', ], ], 'ServerSideEncryption' => [ 'base' => NULL, 'refs' => [ 'CompleteMultipartUploadOutput$ServerSideEncryption' => '<p>If you specified server-side encryption either with an Amazon S3-managed encryption key or an AWS KMS customer master key (CMK) in your initiate multipart upload request, the response includes this header. It confirms the encryption algorithm that Amazon S3 used to encrypt the object.</p>', 'CopyObjectOutput$ServerSideEncryption' => '<p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>', 'CopyObjectRequest$ServerSideEncryption' => '<p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>', 'CreateMultipartUploadOutput$ServerSideEncryption' => '<p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>', 'CreateMultipartUploadRequest$ServerSideEncryption' => '<p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>', 'Encryption$EncryptionType' => '<p>The server-side encryption algorithm used when storing job results in Amazon S3 (for example, AES256, aws:kms).</p>', 'GetObjectOutput$ServerSideEncryption' => '<p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>', 'HeadObjectOutput$ServerSideEncryption' => '<p>If the object is stored using server-side encryption either with an AWS KMS customer master key (CMK) or an Amazon S3-managed encryption key, the response includes this header with the value of the server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>', 'PutObjectOutput$ServerSideEncryption' => '<p>If you specified server-side encryption either with an AWS KMS customer master key (CMK) or Amazon S3-managed encryption key in your PUT request, the response includes this header. It confirms the encryption algorithm that Amazon S3 used to encrypt the object.</p>', 'PutObjectRequest$ServerSideEncryption' => '<p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>', 'ServerSideEncryptionByDefault$SSEAlgorithm' => '<p>Server-side encryption algorithm to use for the default encryption.</p>', 'UploadPartCopyOutput$ServerSideEncryption' => '<p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>', 'UploadPartOutput$ServerSideEncryption' => '<p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>', ], ], 'ServerSideEncryptionByDefault' => [ 'base' => '<p>Describes the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn\'t specify any server-side encryption, this default encryption will be applied. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTencryption.html">PUT Bucket encryption</a> in the <i>Amazon Simple Storage Service API Reference</i>.</p>', 'refs' => [ 'ServerSideEncryptionRule$ApplyServerSideEncryptionByDefault' => '<p>Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn\'t specify any server-side encryption, this default encryption will be applied.</p>', ], ], 'ServerSideEncryptionConfiguration' => [ 'base' => '<p>Specifies the default server-side-encryption configuration.</p>', 'refs' => [ 'GetBucketEncryptionOutput$ServerSideEncryptionConfiguration' => NULL, 'PutBucketEncryptionRequest$ServerSideEncryptionConfiguration' => NULL, ], ], 'ServerSideEncryptionRule' => [ 'base' => '<p>Specifies the default server-side encryption configuration.</p>', 'refs' => [ 'ServerSideEncryptionRules$member' => NULL, ], ], 'ServerSideEncryptionRules' => [ 'base' => NULL, 'refs' => [ 'ServerSideEncryptionConfiguration$Rules' => '<p>Container for information about a particular server-side encryption configuration rule.</p>', ], ], 'Setting' => [ 'base' => NULL, 'refs' => [ 'PublicAccessBlockConfiguration$BlockPublicAcls' => '<p>Specifies whether Amazon S3 should block public access control lists (ACLs) for this bucket and objects in this bucket. Setting this element to <code>TRUE</code> causes the following behavior:</p> <ul> <li> <p>PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.</p> </li> <li> <p>PUT Object calls fail if the request includes a public ACL.</p> </li> <li> <p>PUT Bucket calls fail if the request includes a public ACL.</p> </li> </ul> <p>Enabling this setting doesn\'t affect existing policies or ACLs.</p>', 'PublicAccessBlockConfiguration$IgnorePublicAcls' => '<p>Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket. Setting this element to <code>TRUE</code> causes Amazon S3 to ignore all public ACLs on this bucket and objects in this bucket.</p> <p>Enabling this setting doesn\'t affect the persistence of any existing ACLs and doesn\'t prevent new public ACLs from being set.</p>', 'PublicAccessBlockConfiguration$BlockPublicPolicy' => '<p>Specifies whether Amazon S3 should block public bucket policies for this bucket. Setting this element to <code>TRUE</code> causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. </p> <p>Enabling this setting doesn\'t affect existing bucket policies.</p>', 'PublicAccessBlockConfiguration$RestrictPublicBuckets' => '<p>Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to <code>TRUE</code> restricts access to this bucket to only AWS services and authorized users within this account if the bucket has a public policy.</p> <p>Enabling this setting doesn\'t affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.</p>', ], ], 'Size' => [ 'base' => NULL, 'refs' => [ 'Object$Size' => '<p>Size in bytes of the object</p>', 'ObjectVersion$Size' => '<p>Size in bytes of the object.</p>', 'Part$Size' => '<p>Size in bytes of the uploaded part data.</p>', ], ], 'SourceSelectionCriteria' => [ 'base' => '<p>A container that describes additional filters for identifying the source objects that you want to replicate. You can choose to enable or disable the replication of these objects. Currently, Amazon S3 supports only the filter that you can specify for objects created with server-side encryption using a customer master key (CMK) stored in AWS Key Management Service (SSE-KMS).</p>', 'refs' => [ 'ReplicationRule$SourceSelectionCriteria' => '<p>A container that describes additional filters for identifying the source objects that you want to replicate. You can choose to enable or disable the replication of these objects. Currently, Amazon S3 supports only the filter that you can specify for objects created with server-side encryption using a customer master key (CMK) stored in AWS Key Management Service (SSE-KMS).</p>', ], ], 'SseKmsEncryptedObjects' => [ 'base' => '<p>A container for filter information for the selection of S3 objects encrypted with AWS KMS.</p>', 'refs' => [ 'SourceSelectionCriteria$SseKmsEncryptedObjects' => '<p> A container for filter information for the selection of Amazon S3 objects encrypted with AWS KMS. If you include <code>SourceSelectionCriteria</code> in the replication configuration, this element is required. </p>', ], ], 'SseKmsEncryptedObjectsStatus' => [ 'base' => NULL, 'refs' => [ 'SseKmsEncryptedObjects$Status' => '<p>Specifies whether Amazon S3 replicates objects created with server-side encryption using a customer master key (CMK) stored in AWS Key Management Service.</p>', ], ], 'Start' => [ 'base' => NULL, 'refs' => [ 'ScanRange$Start' => '<p>Specifies the start of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is 0. If only start is supplied, it means scan from that point to the end of the file.For example; <code>&lt;scanrange&gt;&lt;start&gt;50&lt;/start&gt;&lt;/scanrange&gt;</code> means scan from byte 50 until the end of the file.</p>', ], ], 'StartAfter' => [ 'base' => NULL, 'refs' => [ 'ListObjectsV2Output$StartAfter' => '<p>If StartAfter was sent with the request, it is included in the response.</p>', 'ListObjectsV2Request$StartAfter' => '<p>StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this specified key. StartAfter can be any key in the bucket.</p>', ], ], 'Stats' => [ 'base' => '<p>Container for the stats details.</p>', 'refs' => [ 'StatsEvent$Details' => '<p>The Stats event details.</p>', ], ], 'StatsEvent' => [ 'base' => '<p>Container for the Stats Event.</p>', 'refs' => [ 'SelectObjectContentEventStream$Stats' => '<p>The Stats Event.</p>', ], ], 'StorageClass' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$StorageClass' => '<p>The type of storage to use for the object. Defaults to \'STANDARD\'.</p>', 'CreateMultipartUploadRequest$StorageClass' => '<p>The type of storage to use for the object. Defaults to \'STANDARD\'.</p>', 'Destination$StorageClass' => '<p> The storage class to use when replicating objects, such as S3 Standard or reduced redundancy. By default, Amazon S3 uses the storage class of the source object to create the object replica. </p> <p>For valid values, see the <code>StorageClass</code> element of the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html">PUT Bucket replication</a> action in the <i>Amazon Simple Storage Service API Reference</i>.</p>', 'GetObjectOutput$StorageClass' => '<p>Provides storage class information of the object. Amazon S3 returns this header for all objects except for S3 Standard storage class objects.</p>', 'HeadObjectOutput$StorageClass' => '<p>Provides storage class information of the object. Amazon S3 returns this header for all objects except for S3 Standard storage class objects.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a>.</p>', 'ListPartsOutput$StorageClass' => '<p>Class of storage (STANDARD or REDUCED_REDUNDANCY) used to store the uploaded object.</p>', 'MultipartUpload$StorageClass' => '<p>The class of storage used to store the object.</p>', 'PutObjectRequest$StorageClass' => '<p>If you don\'t specify, S3 Standard is the default storage class. Amazon S3 supports other storage classes.</p>', 'S3Location$StorageClass' => '<p>The class of storage used to store the restore results.</p>', ], ], 'StorageClassAnalysis' => [ 'base' => '<p>Specifies data related to access patterns to be collected and made available to analyze the tradeoffs between different storage classes for an Amazon S3 bucket.</p>', 'refs' => [ 'AnalyticsConfiguration$StorageClassAnalysis' => '<p> Contains data related to access patterns to be collected and made available to analyze the tradeoffs between different storage classes. </p>', ], ], 'StorageClassAnalysisDataExport' => [ 'base' => '<p>Container for data related to the storage class analysis for an Amazon S3 bucket for export.</p>', 'refs' => [ 'StorageClassAnalysis$DataExport' => '<p>Specifies how data related to the storage class analysis for an Amazon S3 bucket should be exported.</p>', ], ], 'StorageClassAnalysisSchemaVersion' => [ 'base' => NULL, 'refs' => [ 'StorageClassAnalysisDataExport$OutputSchemaVersion' => '<p>The version of the output schema to use when exporting data. Must be <code>V_1</code>.</p>', ], ], 'Suffix' => [ 'base' => NULL, 'refs' => [ 'IndexDocument$Suffix' => '<p>A suffix that is appended to a request that is for a directory on the website endpoint (for example,if the suffix is index.html and you make a request to samplebucket/images/ the data that is returned will be for the object with the key name images/index.html) The suffix must not be empty and must not include a slash character.</p>', ], ], 'Tag' => [ 'base' => '<p>A container of a key value name pair.</p>', 'refs' => [ 'AnalyticsFilter$Tag' => '<p>The tag to use when evaluating an analytics filter.</p>', 'LifecycleRuleFilter$Tag' => '<p>This tag must exist in the object\'s tag set in order for the rule to apply.</p>', 'MetricsFilter$Tag' => '<p>The tag used when evaluating a metrics filter.</p>', 'ReplicationRuleFilter$Tag' => '<p>A container for specifying a tag key and value. </p> <p>The rule applies only to objects that have the tag in their tag set.</p>', 'TagSet$member' => NULL, ], ], 'TagCount' => [ 'base' => NULL, 'refs' => [ 'GetObjectOutput$TagCount' => '<p>The number of tags, if any, on the object.</p>', ], ], 'TagSet' => [ 'base' => NULL, 'refs' => [ 'AnalyticsAndOperator$Tags' => '<p>The list of tags to use when evaluating an AND predicate.</p>', 'GetBucketTaggingOutput$TagSet' => '<p>Contains the tag set.</p>', 'GetObjectTaggingOutput$TagSet' => '<p>Contains the tag set.</p>', 'LifecycleRuleAndOperator$Tags' => '<p>All of these tags must exist in the object\'s tag set in order for the rule to apply.</p>', 'MetricsAndOperator$Tags' => '<p>The list of tags used when evaluating an AND predicate.</p>', 'ReplicationRuleAndOperator$Tags' => '<p>An array of tags containing key and value pairs.</p>', 'Tagging$TagSet' => '<p>A collection for a set of tags</p>', ], ], 'Tagging' => [ 'base' => '<p>Container for <code>TagSet</code> elements.</p>', 'refs' => [ 'PutBucketTaggingRequest$Tagging' => '<p>Container for the <code>TagSet</code> and <code>Tag</code> elements.</p>', 'PutObjectTaggingRequest$Tagging' => '<p>Container for the <code>TagSet</code> and <code>Tag</code> elements</p>', 'S3Location$Tagging' => '<p>The tag-set that is applied to the restore results.</p>', ], ], 'TaggingDirective' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$TaggingDirective' => '<p>Specifies whether the object tag-set are copied from the source object or replaced with tag-set provided in the request.</p>', ], ], 'TaggingHeader' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$Tagging' => '<p>The tag-set for the object destination object this value must be used in conjunction with the <code>TaggingDirective</code>. The tag-set must be encoded as URL Query parameters.</p>', 'CreateMultipartUploadRequest$Tagging' => '<p>The tag-set for the object. The tag-set must be encoded as URL Query parameters.</p>', 'PutObjectRequest$Tagging' => '<p>The tag-set for the object. The tag-set must be encoded as URL Query parameters. (For example, "Key1=Value1")</p>', ], ], 'TargetBucket' => [ 'base' => NULL, 'refs' => [ 'LoggingEnabled$TargetBucket' => '<p>Specifies the bucket where you want Amazon S3 to store server access logs. You can have your logs delivered to any bucket that you own, including the same bucket that is being logged. You can also configure multiple buckets to deliver their logs to the same target bucket. In this case, you should choose a different <code>TargetPrefix</code> for each source bucket so that the delivered log files can be distinguished by key.</p>', ], ], 'TargetGrant' => [ 'base' => '<p>Container for granting information.</p>', 'refs' => [ 'TargetGrants$member' => NULL, ], ], 'TargetGrants' => [ 'base' => NULL, 'refs' => [ 'LoggingEnabled$TargetGrants' => '<p>Container for granting information.</p>', ], ], 'TargetPrefix' => [ 'base' => NULL, 'refs' => [ 'LoggingEnabled$TargetPrefix' => '<p>A prefix for all log object keys. If you store log files from multiple Amazon S3 buckets in a single bucket, you can use a prefix to distinguish which log files came from which bucket.</p>', ], ], 'Tier' => [ 'base' => NULL, 'refs' => [ 'GlacierJobParameters$Tier' => '<p>S3 Glacier retrieval tier at which the restore will be processed.</p>', 'RestoreRequest$Tier' => '<p>S3 Glacier retrieval tier at which the restore will be processed.</p>', ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'ListBucketAnalyticsConfigurationsOutput$ContinuationToken' => '<p>The marker that is used as a starting point for this analytics configuration list response. This value is present if it was sent in the request.</p>', 'ListBucketAnalyticsConfigurationsRequest$ContinuationToken' => '<p>The ContinuationToken that represents a placeholder from where this request should begin.</p>', 'ListBucketInventoryConfigurationsOutput$ContinuationToken' => '<p>If sent in the request, the marker that is used as a starting point for this inventory configuration list response.</p>', 'ListBucketInventoryConfigurationsRequest$ContinuationToken' => '<p>The marker used to continue an inventory configuration listing that has been truncated. Use the NextContinuationToken from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.</p>', 'ListBucketMetricsConfigurationsOutput$ContinuationToken' => '<p>The marker that is used as a starting point for this metrics configuration list response. This value is present if it was sent in the request.</p>', 'ListBucketMetricsConfigurationsRequest$ContinuationToken' => '<p>The marker that is used to continue a metrics configuration listing that has been truncated. Use the NextContinuationToken from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.</p>', 'ListObjectsV2Output$ContinuationToken' => '<p> If ContinuationToken was sent with the request, it is included in the response.</p>', 'ListObjectsV2Request$ContinuationToken' => '<p>ContinuationToken indicates Amazon S3 that the list is being continued on this bucket with a token. ContinuationToken is obfuscated and is not a real key.</p>', ], ], 'TopicArn' => [ 'base' => NULL, 'refs' => [ 'TopicConfiguration$TopicArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which Amazon S3 publishes a message when it detects events of the specified type.</p>', 'TopicConfigurationDeprecated$Topic' => '<p>Amazon SNS topic to which Amazon S3 will publish a message to report the specified events for the bucket.</p>', ], ], 'TopicConfiguration' => [ 'base' => '<p>A container for specifying the configuration for publication of messages to an Amazon Simple Notification Service (Amazon SNS) topic when Amazon S3 detects specified events.</p>', 'refs' => [ 'TopicConfigurationList$member' => NULL, ], ], 'TopicConfigurationDeprecated' => [ 'base' => '<p>A container for specifying the configuration for publication of messages to an Amazon Simple Notification Service (Amazon SNS) topic when Amazon S3 detects specified events. This data type is deprecated. Use <a>TopicConfiguration</a> instead.</p>', 'refs' => [ 'NotificationConfigurationDeprecated$TopicConfiguration' => '<p>This data type is deprecated. A container for specifying the configuration for publication of messages to an Amazon Simple Notification Service (Amazon SNS) topic when Amazon S3 detects specified events. </p>', ], ], 'TopicConfigurationList' => [ 'base' => NULL, 'refs' => [ 'NotificationConfiguration$TopicConfigurations' => '<p>The topic to which notifications are sent and the events for which notifications are generated.</p>', ], ], 'Transition' => [ 'base' => '<p>Specifies when an object transitions to a specified storage class. For more information about Amazon S3 lifecycle configuration rules, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-transition-general-considerations.html">Transitioning Objects Using Amazon S3 Lifecycle</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'refs' => [ 'Rule$Transition' => '<p>Specifies when an object transitions to a specified storage class. For more information about Amazon S3 lifecycle configuration rules, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-transition-general-considerations.html">Transitioning Objects Using Amazon S3 Lifecycle</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'TransitionList$member' => NULL, ], ], 'TransitionList' => [ 'base' => NULL, 'refs' => [ 'LifecycleRule$Transitions' => '<p>Specifies when an Amazon S3 object transitions to a specified storage class.</p>', ], ], 'TransitionStorageClass' => [ 'base' => NULL, 'refs' => [ 'NoncurrentVersionTransition$StorageClass' => '<p>The class of storage used to store the object.</p>', 'Transition$StorageClass' => '<p>The storage class to which you want the object to transition.</p>', ], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'Grantee$Type' => '<p>Type of grantee</p>', ], ], 'URI' => [ 'base' => NULL, 'refs' => [ 'Grantee$URI' => '<p>URI of the grantee group.</p>', ], ], 'UploadIdMarker' => [ 'base' => NULL, 'refs' => [ 'ListMultipartUploadsOutput$UploadIdMarker' => '<p>Upload ID after which listing began.</p>', 'ListMultipartUploadsRequest$UploadIdMarker' => '<p>Together with key-marker, specifies the multipart upload after which listing should begin. If key-marker is not specified, the upload-id-marker parameter is ignored. Otherwise, any multipart uploads for a key equal to the key-marker might be included in the list only if they have an upload ID lexicographically greater than the specified <code>upload-id-marker</code>.</p>', ], ], 'UploadPartCopyOutput' => [ 'base' => NULL, 'refs' => [], ], 'UploadPartCopyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UploadPartOutput' => [ 'base' => NULL, 'refs' => [], ], 'UploadPartRequest' => [ 'base' => NULL, 'refs' => [], ], 'UserMetadata' => [ 'base' => NULL, 'refs' => [ 'S3Location$UserMetadata' => '<p>A list of metadata to store with the restore results in S3.</p>', ], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>Value of the tag.</p>', ], ], 'VersionIdMarker' => [ 'base' => NULL, 'refs' => [ 'ListObjectVersionsOutput$VersionIdMarker' => '<p>Marks the last version of the key returned in a truncated response.</p>', 'ListObjectVersionsRequest$VersionIdMarker' => '<p>Specifies the object version you want to start listing from.</p>', ], ], 'VersioningConfiguration' => [ 'base' => '<p>Describes the versioning state of an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTVersioningStatus.html">PUT Bucket versioning</a> in the <i>Amazon Simple Storage Service API Reference</i>.</p>', 'refs' => [ 'PutBucketVersioningRequest$VersioningConfiguration' => '<p>Container for setting the versioning state.</p>', ], ], 'WebsiteConfiguration' => [ 'base' => '<p>Specifies website configuration parameters for an Amazon S3 bucket.</p>', 'refs' => [ 'PutBucketWebsiteRequest$WebsiteConfiguration' => '<p>Container for the request.</p>', ], ], 'WebsiteRedirectLocation' => [ 'base' => NULL, 'refs' => [ 'CopyObjectRequest$WebsiteRedirectLocation' => '<p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p>', 'CreateMultipartUploadRequest$WebsiteRedirectLocation' => '<p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p>', 'GetObjectOutput$WebsiteRedirectLocation' => '<p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p>', 'HeadObjectOutput$WebsiteRedirectLocation' => '<p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p>', 'PutObjectRequest$WebsiteRedirectLocation' => '<p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata. For information about object metadata, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html">Object Key and Metadata</a>.</p> <p>In the following example, the request header sets the redirect to an object (anotherPage.html) in the same bucket:</p> <p> <code>x-amz-website-redirect-location: /anotherPage.html</code> </p> <p>In the following example, the request header sets the object redirect to another website:</p> <p> <code>x-amz-website-redirect-location: http://www.example.com/</code> </p> <p>For more information about website hosting in Amazon S3, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html">How to Configure Website Page Redirects</a>. </p>', ], ], 'Years' => [ 'base' => NULL, 'refs' => [ 'DefaultRetention$Years' => '<p>The number of years that you want to specify for the default retention period.</p>', ], ], ],];
